/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.math.stats;

import umcg.genetica.containers.Pair;
import umcg.genetica.math.stats.ChiSquare;

public class Heterogeneity {
    public static Pair<Double, Double> getISq(Double[] datasetZ, int[] datasetWeights) {
        double weightedZ = 0.0;
        int totalSample = 0;
        for (int d = 0; d < datasetZ.length; ++d) {
            if (datasetZ[d] == null) continue;
            weightedZ += Math.sqrt(datasetWeights[d]) * datasetZ[d];
            totalSample += datasetWeights[d];
        }
        double hetSum = 0.0;
        int hetDf = 0;
        for (int d = 0; d < datasetZ.length; ++d) {
            if (datasetZ[d] == null) continue;
            double expectedZ = Math.sqrt(datasetWeights[d]) * weightedZ / (double)totalSample;
            hetSum += (datasetZ[d] - expectedZ) * (datasetZ[d] - expectedZ);
            ++hetDf;
        }
        double p = 1.0;
        double i = 0.0;
        double iExp = (hetSum - (double)hetDf + 1.0) / hetSum * 100.0;
        p = hetDf <= 1 || hetSum < 1.0E-7 ? 1.0 : ChiSquare.getP(hetDf - 1, hetSum);
        i = hetSum <= (double)(hetDf - 1) || hetDf <= 1 ? 0.0 : iExp;
        return new Pair<Double, Double>(i, p);
    }

    public static Pair<Double, Double> getISq(double[] datasetZ, int[] datasetWeights) {
        double weightedZ = 0.0;
        int totalSample = 0;
        for (int d = 0; d < datasetZ.length; ++d) {
            if (Double.isNaN(datasetZ[d])) continue;
            weightedZ += Math.sqrt(datasetWeights[d]) * datasetZ[d];
            totalSample += datasetWeights[d];
        }
        double hetSum = 0.0;
        int hetDf = 0;
        for (int d = 0; d < datasetZ.length; ++d) {
            if (Double.isNaN(datasetZ[d])) continue;
            double expectedZ = Math.sqrt(datasetWeights[d]) * weightedZ / (double)totalSample;
            hetSum += (datasetZ[d] - expectedZ) * (datasetZ[d] - expectedZ);
            ++hetDf;
        }
        double p = 1.0;
        double i = 0.0;
        double iExp = (hetSum - (double)hetDf + 1.0) / hetSum * 100.0;
        p = hetDf <= 1 || hetSum < 1.0E-7 ? 1.0 : ChiSquare.getP(hetDf - 1, hetSum);
        i = hetSum <= (double)(hetDf - 1) || hetDf <= 1 ? 0.0 : iExp;
        return new Pair<Double, Double>(i, p);
    }
}

