/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.math.stats;

import JSci.maths.statistics.NormalDistribution;
import umcg.genetica.containers.Pair;

public class Descriptives {
    public static double[] m_zScoreToPValue = null;
    public static double[] m_sqrtSample = null;

    public static double mean(float[] v) {
        double sum = 0.0;
        for (int k = 0; k < v.length; ++k) {
            sum += (double)v[k];
        }
        return sum / (double)v.length;
    }

    public static double variance(float[] v, double mean) {
        double ans = 0.0;
        for (int i = 0; i < v.length; ++i) {
            ans += ((double)v[i] - mean) * ((double)v[i] - mean);
        }
        return ans / (double)(v.length - 1);
    }

    public static void lookupSqrt(int totalNrSamples) {
        double[] sqrtSample = new double[totalNrSamples + 1];
        for (int nrSamples = 0; nrSamples <= totalNrSamples; ++nrSamples) {
            sqrtSample[nrSamples] = Math.sqrt(nrSamples);
        }
        m_sqrtSample = sqrtSample;
    }

    public static void initializeZScoreToPValue() {
        NormalDistribution normDist = new NormalDistribution();
        m_zScoreToPValue = new double[376501];
        for (int z = 0; z <= 376500; ++z) {
            double zScore = ((double)z - 188250.0) / 5000.0;
            double pValue = zScore > 0.0 ? normDist.cumulative(-zScore) : normDist.cumulative(zScore);
            if (pValue > 0.5) {
                pValue = 1.0 - pValue;
            }
            Descriptives.m_zScoreToPValue[z] = pValue *= 2.0;
        }
    }

    public static double convertZscoreToPvalue(double zScore) {
        if (Double.isNaN(zScore)) {
            return 1.0;
        }
        if (m_zScoreToPValue == null) {
            Descriptives.initializeZScoreToPValue();
        }
        return m_zScoreToPValue[Descriptives.getZScorePvalueIndex(zScore)];
    }

    public static int getZScorePvalueIndex(double zScore) {
        int zScoreIndex = (int)(zScore * 5000.0 + 188250.0);
        if (zScoreIndex < 0) {
            zScoreIndex = 0;
        }
        if (zScoreIndex > 376500) {
            zScoreIndex = 376500;
        }
        return zScoreIndex;
    }

    public static double zScore(double value, double mean, double variance) {
        if (variance > 0.0 && mean > 0.0) {
            double sd = Math.sqrt(variance);
            double val = value - mean;
            double zscore = val / sd;
            zscore = Math.sqrt(Math.pow(zscore, 2.0));
            return zscore;
        }
        return Double.MAX_VALUE;
    }

    public static double mean(double[] v) {
        double sum = 0.0;
        for (int k = 0; k < v.length; ++k) {
            sum += v[k];
        }
        return sum / (double)v.length;
    }

    public static Pair<Double, Double> mean(double[] v, double[] w) {
        double sumV = 0.0;
        double sumW = 0.0;
        for (int k = 0; k < v.length; ++k) {
            sumV += v[k];
            sumW += w[k];
        }
        return new Pair<Double, Double>(sumV / (double)v.length, sumW / (double)v.length);
    }

    public static double variance(double[] v) {
        double mean = Descriptives.mean(v);
        return Descriptives.variance(v, mean);
    }

    public static double variance(double[] v, double mean) {
        double ans = 0.0;
        for (int i = 0; i < v.length; ++i) {
            ans += (v[i] - mean) * (v[i] - mean);
        }
        return ans / (double)(v.length - 1);
    }

    public static double getSqrt(int nrTotalSamples) {
        if (m_sqrtSample == null) {
            System.out.println("ERROR: square-root table not correctly initialized.");
            System.exit(-1);
        }
        return m_sqrtSample[nrTotalSamples];
    }

    public static double sum(double[] v) {
        double sum = 0.0;
        for (double d : v) {
            sum += d;
        }
        return sum;
    }

    public static double absSum(double[] v) {
        double sum = 0.0;
        for (double d : v) {
            sum += Math.abs(d);
        }
        return sum;
    }

    public static double cityBlockDistance(double[] v, double[] w) {
        double summedDistance = 0.0;
        for (int i = 0; i < v.length; ++i) {
            summedDistance += Math.abs(v[i] - w[i]);
        }
        return summedDistance;
    }

    public static double BrayCurtisDistance(double[] v, double[] w) {
        double summedDistance = 0.0;
        double sum = 0.0;
        for (int i = 0; i < v.length; ++i) {
            summedDistance += Math.abs(v[i] - w[i]);
            sum += v[i];
            sum += w[i];
        }
        return summedDistance / sum;
    }
}

