/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.math.stats;

import cern.jet.random.tdouble.StudentT;
import cern.jet.random.tdouble.engine.DRand;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;
import cern.jet.stat.tdouble.Probability;
import umcg.genetica.containers.Pair;
import umcg.genetica.math.stats.Descriptives;
import umcg.genetica.util.RankDoubleArray;

public class Correlation {
    public static double[][] m_correlationToZScore;

    public static double rankCorrelate(double[] x, double[] y) {
        RankDoubleArray rda = new RankDoubleArray();
        if (x == null || y == null) {
            throw new IllegalArgumentException("Error calculating correlation: x or y is null!");
        }
        if (y.length != x.length) {
            throw new IllegalArgumentException("Error calculating correlation: x and y should have the same length!");
        }
        double[] xNew = new double[x.length];
        double[] yNew = new double[y.length];
        for (int a = 0; a < x.length; ++a) {
            xNew[a] = x[a];
            yNew[a] = y[a];
        }
        double[] xranked = rda.rank(xNew);
        double[] yranked = rda.rank(yNew);
        return Correlation.correlate(xranked, yranked);
    }

    public static void correlationToZScore(int maxNrSamples) {
        if (m_correlationToZScore == null || m_correlationToZScore.length < maxNrSamples + 1) {
            double[][] correlationToZScore = new double[maxNrSamples + 1][2001];
            DRand randomEngine = new DRand();
            for (int nrSamples = 0; nrSamples <= maxNrSamples; ++nrSamples) {
                if (nrSamples < 3) {
                    for (int sc = 0; sc <= 2000; ++sc) {
                        correlationToZScore[nrSamples][sc] = 0.0;
                    }
                    continue;
                }
                StudentT tDistColt = new StudentT((double)(nrSamples - 2), (DoubleRandomEngine)randomEngine);
                for (int s = 0; s <= 2000; ++s) {
                    double spearman = (double)(s - 1000) / 1000.0;
                    if (Math.abs(spearman - -1.0) < 1.0E-7) {
                        spearman = -0.9999;
                    }
                    if (Math.abs(spearman - 1.0) < 1.0E-7) {
                        spearman = 0.9999;
                    }
                    double t = spearman / Math.sqrt((1.0 - spearman * spearman) / (double)(nrSamples - 2));
                    double pValueColt = 1.0;
                    double zScoreColt = 0.0;
                    if (t < 0.0) {
                        pValueColt = tDistColt.cdf(t);
                        if (pValueColt < 2.0E-323) {
                            pValueColt = 2.0E-323;
                        }
                        zScoreColt = Probability.normalInverse((double)pValueColt);
                    } else {
                        pValueColt = tDistColt.cdf(-t);
                        if (pValueColt < 2.0E-323) {
                            pValueColt = 2.0E-323;
                        }
                        zScoreColt = -Probability.normalInverse((double)pValueColt);
                    }
                    correlationToZScore[nrSamples][s] = zScoreColt;
                }
            }
            m_correlationToZScore = correlationToZScore;
        }
    }

    public static double correlateMeanCenteredData(double[] x, double[] y, double varX, double varY) {
        double covarianceInterim = 0.0;
        for (int i = 0; i < x.length; ++i) {
            covarianceInterim += x[i] * y[i];
        }
        return covarianceInterim / (double)(x.length - 1) / Math.sqrt(varX * varY);
    }

    public static double correlateMeanCenteredData(double[] x, double[] y, double sdXsdY) {
        double covarianceInterim = 0.0;
        for (int i = 0; i < x.length; ++i) {
            covarianceInterim += x[i] * y[i];
        }
        return covarianceInterim / (double)(x.length - 1) / sdXsdY;
    }

    public static double correlate(double[] x, double[] y) {
        if (x.length == y.length) {
            Pair<Double, Double> tmpMean = Descriptives.mean(x, y);
            double meanX = tmpMean.getLeft();
            double meanY = tmpMean.getRight();
            double varX = 0.0;
            double varY = 0.0;
            double covarianceInterim = 0.0;
            for (int a = 0; a < x.length; ++a) {
                double varXT = x[a] - meanX;
                double varYT = y[a] - meanY;
                covarianceInterim += varXT * varYT;
                varX += varXT * varXT;
                varY += varYT * varYT;
            }
            double denominator = Math.sqrt((varX /= (double)(x.length - 1)) * (varY /= (double)(y.length - 1)));
            double covariance = covarianceInterim / (double)(x.length - 1);
            double correlation = covariance / denominator;
            return correlation;
        }
        System.out.println("Warning two arrays of non identical length are put in for correlation.");
        System.out.println("Returning NaN");
        return Double.NaN;
    }

    public static double correlate(double meanX, double meanY, double[] x, double[] y) {
        if (x.length == y.length) {
            double varX = 0.0;
            double varY = 0.0;
            double covarianceInterim = 0.0;
            for (int a = 0; a < x.length; ++a) {
                double varXT = x[a] - meanX;
                double varYT = y[a] - meanY;
                covarianceInterim += varXT * varYT;
                varX += varXT * varXT;
                varY += varYT * varYT;
            }
            double denominator = Math.sqrt((varX /= (double)(x.length - 1)) * (varY /= (double)(y.length - 1)));
            double covariance = covarianceInterim / (double)(x.length - 1);
            double correlation = covariance / denominator;
            return correlation;
        }
        System.out.println("Warning two arrays of non identical length are put in for correlation.");
        System.out.println("Returning NaN");
        return Double.NaN;
    }

    public static double covariate(double[] x, double[] y) {
        if (x.length == y.length) {
            Pair<Double, Double> tmpMean = Descriptives.mean(x, y);
            double meanX = tmpMean.getLeft();
            double meanY = tmpMean.getRight();
            double covarianceInterim = 0.0;
            for (int a = 0; a < x.length; ++a) {
                double varXT = x[a] - meanX;
                double varYT = y[a] - meanY;
                covarianceInterim += varXT * varYT;
            }
            double covariance = covarianceInterim / (double)(x.length - 1);
            return covariance;
        }
        System.out.println("Warning two arrays of non identical length are put in for correlation.");
        System.out.println("Returning NaN");
        return Double.NaN;
    }

    public static double covariate(double meanX, double meanY, double[] x, double[] y) {
        if (x.length == y.length) {
            double covarianceInterim = 0.0;
            for (int a = 0; a < x.length; ++a) {
                double varXT = x[a] - meanX;
                double varYT = y[a] - meanY;
                covarianceInterim += varXT * varYT;
            }
            double covariance = covarianceInterim / (double)(x.length - 1);
            return covariance;
        }
        System.out.println("Warning two arrays of non identical length are put in for correlation.");
        System.out.println("Returning NaN");
        return Double.NaN;
    }

    public static double convertCorrelationToZScore(int length, double correlation) {
        int correlationIndex = (int)Math.round((correlation + 1.0) * 1000.0);
        if (m_correlationToZScore == null) {
            throw new IllegalArgumentException("Correlation to ZScore lookup table is not initialized.");
        }
        if (m_correlationToZScore.length < length) {
            throw new IllegalArgumentException("Correlation to ZScore lookup table is not initialized properly. Expected: " + length + ". Actual length: " + m_correlationToZScore.length);
        }
        if (correlationIndex > m_correlationToZScore[length].length - 1) {
            throw new IllegalArgumentException("ERROR! correlation: " + correlation + " does not fit Z-score table for " + m_correlationToZScore[length] + " samples (length is: " + m_correlationToZScore[length].length + ")");
        }
        return m_correlationToZScore[length][correlationIndex];
    }

    public static double correlate(double[] a1, double[] a2, double mean1, double mean2, double var1, double var2) {
        double denom = Math.sqrt(var1 * var2);
        if (denom != 0.0) {
            if (a1.length != a2.length) {
                throw new IllegalArgumentException("Arrays must have the same length : " + a1.length + ", " + a2.length);
            }
            double ans = 0.0;
            for (int i = 0; i < a1.length; ++i) {
                ans += (a1[i] - mean1) * (a2[i] - mean2);
            }
            return ans / (double)(a1.length - 1) / denom;
        }
        if (var1 == 0.0 && var2 == 0.0) {
            return 1.0;
        }
        return 0.0;
    }
}

