/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.math.stats;

import JSci.maths.statistics.NormalDistribution;
import java.util.logging.Level;
import java.util.logging.Logger;
import umcg.genetica.math.stats.Normalization;
import umontreal.iro.lecuyer.probdist.AndersonDarlingDist;

public class AndersonDarling {
    private static final Logger LOGGER = Logger.getLogger(AndersonDarling.class.getName());
    private static final NormalDistribution norm = new NormalDistribution();

    private AndersonDarling() {
    }

    public static double getASquared(double[] vals) {
        return AndersonDarling.getASquared(vals, IS_DATA_NORMALIZED.NO);
    }

    public static double getASquared(double[] vals, IS_DATA_NORMALIZED idn) {
        if (vals == null || vals.length < 3) {
            throw new IllegalArgumentException("An array of at least 3 values should be given.");
        }
        if (idn == IS_DATA_NORMALIZED.NO) {
            LOGGER.log(Level.INFO, "Standard normalizing data.");
            vals = Normalization.standardNormalize(vals);
            LOGGER.log(Level.INFO, "Data normalized.");
        }
        double n = vals.length;
        double a2 = 0.0;
        for (int i = 1; i <= vals.length; ++i) {
            a2 += (double)(2 * i - 1) * Math.log(norm.cumulative(vals[i - 1])) + (2.0 * (n - (double)i) + 1.0) * Math.log(1.0 - norm.cumulative(vals[i - 1]));
        }
        a2 = -n - a2 / n;
        return a2;
    }

    public static double getP(double[] vals, IS_DATA_NORMALIZED idn) {
        double asq = AndersonDarling.getASquared(vals, idn);
        return AndersonDarling.getP(asq, vals.length);
    }

    public static double getP(double asq, int n) {
        return AndersonDarlingDist.cdf((int)n, (double)asq);
    }

    public static enum IS_DATA_NORMALIZED {
        YES,
        NO;

    }
}

