/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.math.matrix2;

import JSci.maths.ArrayMath;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections.primitives.ArrayDoubleList;
import umcg.genetica.math.matrix2.DoubleMatrixDataset;

public class MatrixHandling {
    public static void RemoveColumnsWithToManyMissingValues(DoubleMatrixDataset<String, String> dataset, int maxMissingValuesPerColumn, double missingValue) {
        HashSet<String> columnsToInclude = new HashSet<String>();
        for (int c = 0; c < dataset.columns(); ++c) {
            int nrMissing = 0;
            for (int r = 0; r < dataset.rows(); ++r) {
                if (dataset.getMatrix().get(r, c) != missingValue && !Double.isNaN(dataset.getMatrix().get(r, c))) continue;
                ++nrMissing;
            }
            if (nrMissing >= maxMissingValuesPerColumn) {
                System.out.println("Excluding:\t" + c + "\t" + dataset.getColObjects().get(c) + "\t" + nrMissing);
                continue;
            }
            columnsToInclude.add(dataset.getColObjects().get(c));
        }
        MatrixHandling.CreatSubsetBasedOnColumns(dataset, columnsToInclude, true);
    }

    public static void RemoveRowsWithToManyMissingValues(DoubleMatrixDataset<String, String> dataset, int maxMissingValuesPerRow, double missingValue) {
        String[] rowNames = dataset.getRowObjects().toArray(new String[0]);
        HashSet<String> hashRowsToInclude = new HashSet<String>();
        for (int r = 0; r < dataset.rows(); ++r) {
            int nrMissing = 0;
            for (int c = 0; c < dataset.columns(); ++c) {
                if (dataset.getMatrix().get(r, c) != missingValue && !Double.isNaN(dataset.getMatrix().get(r, c))) continue;
                ++nrMissing;
            }
            if (nrMissing >= maxMissingValuesPerRow) {
                System.out.println("Excluding:\t" + r + "\t" + rowNames[r] + "\t" + nrMissing);
                continue;
            }
            hashRowsToInclude.add(rowNames[r]);
        }
        MatrixHandling.CreatSubsetBasedOnRows(dataset, hashRowsToInclude, false);
    }

    public static void RemoveDuplicatesSamples(DoubleMatrixDataset<String, String> dataset) {
        HashSet<String> removeEntry = new HashSet<String>();
        for (int c = 0; c < dataset.columns(); ++c) {
            DoubleMatrix1D colc = dataset.getMatrix().viewColumn(c);
            for (int c2 = 0; c2 < dataset.columns(); ++c2) {
                DoubleMatrix1D colc2 = dataset.getMatrix().viewColumn(c2);
                boolean identical = true;
                for (int r = 0; r < dataset.rows(); ++r) {
                    if (colc.getQuick(r) == colc2.getQuick(r)) continue;
                    identical = false;
                    break;
                }
                if (!identical) continue;
                removeEntry.add(dataset.getColObjects().get(c));
            }
        }
        if (removeEntry.size() > 0) {
            MatrixHandling.RemoveColumns(dataset, removeEntry);
        }
    }

    public static void appendPrefixToColnames(DoubleMatrixDataset<String, String> in, String prefix) {
        LinkedHashMap<String, Integer> newColObjects = new LinkedHashMap<String, Integer>();
        for (Map.Entry<String, Integer> t : in.getHashCols().entrySet()) {
            StringBuilder colName = new StringBuilder();
            colName.append(prefix);
            colName.append("_");
            colName.append(t);
            newColObjects.put(colName.toString(), t.getValue());
        }
        in.setHashCols(newColObjects);
    }

    public static void ReplaceMissingValuesPerColumn(DoubleMatrix2D rawData, boolean useMedian, double NaValue) {
        for (int s = 0; s < rawData.columns(); ++s) {
            System.out.println("Processing sample: " + s);
            boolean needsReplacement = false;
            ArrayDoubleList nonNAvalues = new ArrayDoubleList();
            for (int p = 0; p < rawData.rows(); ++p) {
                if (rawData.get(p, s) == NaValue) {
                    needsReplacement = true;
                    continue;
                }
                nonNAvalues.add(rawData.get(p, s));
            }
            if (!needsReplacement) continue;
            double replacementValue = useMedian ? ArrayMath.median((double[])nonNAvalues.toArray(new double[0])) : ArrayMath.mean((double[])nonNAvalues.toArray(new double[0]));
            for (int p = 0; p < rawData.rows(); ++p) {
                if (rawData.get(p, s) != NaValue) continue;
                rawData.set(p, s, replacementValue);
            }
        }
    }

    public static void ReplaceMissingValuesPerRow(DoubleMatrix2D rawData, boolean useMedian, double NaValue) {
        for (int p = 0; p < rawData.rows(); ++p) {
            System.out.println("Processing row: " + p);
            boolean needsReplacement = false;
            ArrayDoubleList nonNAvalues = new ArrayDoubleList();
            for (int s = 0; s < rawData.rows(); ++s) {
                if (rawData.get(p, s) == NaValue) {
                    needsReplacement = true;
                    continue;
                }
                nonNAvalues.add(rawData.get(p, s));
            }
            if (!needsReplacement) continue;
            double replacementValue = useMedian ? ArrayMath.median((double[])nonNAvalues.toArray(new double[0])) : ArrayMath.mean((double[])nonNAvalues.toArray(new double[0]));
            for (int s = 0; s < rawData.rows(); ++s) {
                if (rawData.get(p, s) != NaValue) continue;
                rawData.set(p, s, replacementValue);
            }
        }
    }

    public static DoubleMatrixDataset<String, String> RemoveProbes(DoubleMatrixDataset<String, String> dataset, HashSet<String> probesToBeRemoved) {
        return MatrixHandling.CreatSubsetBasedOnRows(dataset, probesToBeRemoved, true);
    }

    public static void fixLinkedHashes(LinkedHashMap<String, Integer> hashMap) {
        int i = 0;
        for (Map.Entry<String, Integer> e : hashMap.entrySet()) {
            e.setValue(i);
            ++i;
        }
    }

    public static void RenameRows(DoubleMatrixDataset<String, ?> dataset, HashMap<String, String> mappedProbeList) {
        LinkedHashMap<String, Integer> newRowNames = new LinkedHashMap<String, Integer>(dataset.rows());
        for (Map.Entry<String, Integer> e : dataset.getHashRows().entrySet()) {
            if (mappedProbeList.containsKey(e.getKey())) {
                newRowNames.put(mappedProbeList.get(e.getKey()), e.getValue());
                continue;
            }
            newRowNames.put(e.getKey(), e.getValue());
        }
        dataset.setHashRows(newRowNames);
    }

    public static DoubleMatrixDataset<String, String> MergeMatrixWithNonOverlappingColNames(DoubleMatrixDataset<String, String> m1, DoubleMatrixDataset<String, String> m2) {
        int newRowId;
        int originalRowId;
        int newColId;
        int originalColId;
        HashSet<String> colNames = new HashSet<String>();
        HashSet<String> rowNames = new HashSet<String>();
        colNames.addAll(m1.getColObjects());
        colNames.addAll(m2.getColObjects());
        rowNames.addAll(m1.getRowObjects());
        rowNames.addAll(m2.getRowObjects());
        DoubleMatrixDataset<String, String> mergedMatrix = new DoubleMatrixDataset<String, String>(rowNames, colNames);
        for (String colsM1 : m1.getColObjects()) {
            originalColId = m1.getHashCols().get(colsM1);
            newColId = mergedMatrix.getHashCols().get(colsM1);
            for (String rowsM1 : m1.getRowObjects()) {
                originalRowId = m1.getHashRows().get(rowsM1);
                newRowId = mergedMatrix.getHashRows().get(rowsM1);
                mergedMatrix.matrix.setQuick(newRowId, newColId, m1.matrix.getQuick(originalRowId, originalColId));
            }
        }
        for (String colsM2 : m2.getColObjects()) {
            originalColId = m2.getHashCols().get(colsM2);
            newColId = mergedMatrix.getHashCols().get(colsM2);
            for (String rowsM2 : m2.getRowObjects()) {
                originalRowId = m2.getHashRows().get(rowsM2);
                newRowId = mergedMatrix.getHashRows().get(rowsM2);
                mergedMatrix.matrix.setQuick(newRowId, newColId, m2.matrix.getQuick(originalRowId, originalColId));
            }
        }
        return mergedMatrix;
    }

    public DoubleMatrixDataset<String, String> RemoveRows(DoubleMatrixDataset<String, String> dataset, HashSet<String> probesToBeRemoved) {
        return MatrixHandling.CreatSubsetBasedOnRows(dataset, probesToBeRemoved, true);
    }

    public static DoubleMatrixDataset<String, String> CreatSubsetBasedOnRows(DoubleMatrixDataset<String, String> dataset, HashSet<String> rowNames, boolean removeRows) {
        LinkedHashMap<String, Integer> rowMap = new LinkedHashMap<String, Integer>();
        int newCounter = 0;
        for (String t : dataset.getRowObjects()) {
            if (removeRows && !rowNames.contains(t)) {
                rowMap.put(t, newCounter);
                ++newCounter;
                continue;
            }
            if (removeRows || !rowNames.contains(t)) continue;
            rowMap.put(t, newCounter);
            ++newCounter;
        }
        DoubleMatrixDataset<String, String> matrix = new DoubleMatrixDataset<String, String>(rowMap, dataset.getHashCols());
        for (int p = 0; p < matrix.rows(); ++p) {
            int originalRowNumer = dataset.getHashRows().get(matrix.getRowObjects().get(p));
            for (int s = 0; s < matrix.columns(); ++s) {
                matrix.getMatrix().setQuick(p, s, dataset.getMatrix().getQuick(originalRowNumer, s));
            }
        }
        return matrix;
    }

    public static DoubleMatrixDataset<String, String> RemoveSamples(DoubleMatrixDataset<String, String> dataset, HashSet<String> samplesToBeRemoved) {
        return MatrixHandling.CreatSubsetBasedOnColumns(dataset, samplesToBeRemoved, true);
    }

    public static DoubleMatrixDataset<String, String> RemoveColumns(DoubleMatrixDataset<String, String> dataset, HashSet<String> samplesToBeRemoved) {
        return MatrixHandling.CreatSubsetBasedOnColumns(dataset, samplesToBeRemoved, true);
    }

    public static DoubleMatrixDataset<String, String> CreatSubsetBasedOnColumns(DoubleMatrixDataset<String, String> dataset, HashSet<String> colNames, boolean remove) {
        LinkedHashMap<String, Integer> columnMap = new LinkedHashMap<String, Integer>();
        int newCounter = 0;
        for (String t : dataset.getColObjects()) {
            if (remove && !colNames.contains(t)) {
                columnMap.put(t, newCounter);
                ++newCounter;
                continue;
            }
            if (remove || !colNames.contains(t)) continue;
            columnMap.put(t, newCounter);
            ++newCounter;
        }
        DoubleMatrixDataset<String, String> matrix = new DoubleMatrixDataset<String, String>(dataset.getHashRows(), columnMap);
        for (int s = 0; s < matrix.columns(); ++s) {
            int originalSampleNumer = dataset.getHashCols().get(matrix.getColObjects().get(s));
            for (int p = 0; p < matrix.rows(); ++p) {
                matrix.getMatrix().setQuick(p, s, dataset.getMatrix().getQuick(p, originalSampleNumer));
            }
        }
        return matrix;
    }

    public static void RenameCols(DoubleMatrixDataset<?, String> dataset, HashMap<String, String> newNames) {
        LinkedHashMap<String, Integer> newColNames = new LinkedHashMap<String, Integer>(dataset.columns());
        for (Map.Entry<String, Integer> e : dataset.getHashCols().entrySet()) {
            if (newNames.containsKey(e.getKey())) {
                newColNames.put(newNames.get(e.getKey()), e.getValue());
                continue;
            }
            newColNames.put(e.getKey(), e.getValue());
        }
        dataset.setHashCols(newColNames);
    }

    public static void ReplaceZerosToNull(DoubleMatrix2D rawData) {
        for (int c = 0; c < rawData.columns(); ++c) {
            for (int r = 0; r < rawData.rows(); ++r) {
                if (rawData.getQuick(r, c) != 0.0) continue;
                rawData.setQuick(r, c, Double.NaN);
            }
        }
    }
}

