/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.math.matrix2;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseLargeDoubleMatrix2D;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import umcg.genetica.io.text.TextFile;

public class DoubleMatrixDataset<R extends Comparable, C extends Comparable> {
    static final IOException doubleMatrixDatasetNonUniqueHeaderException = new IOException("Tried to use a non-unique header set in an identifier HashMap");
    static final Logger LOGGER = Logger.getLogger(DoubleMatrixDataset.class.getName());
    protected DoubleMatrix2D matrix;
    protected LinkedHashMap<R, Integer> hashRows;
    protected LinkedHashMap<C, Integer> hashCols;

    public static DoubleMatrixDataset<String, String> loadDoubleTextData(String expressionDataPath, char c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DoubleMatrixDataset() {
        this.hashRows = new LinkedHashMap();
        this.hashCols = new LinkedHashMap();
    }

    public DoubleMatrixDataset(int rows, int columns) {
        this.hashRows = new LinkedHashMap((int)Math.ceil((double)rows / 0.75));
        this.hashCols = new LinkedHashMap((int)Math.ceil((double)columns / 0.75));
        this.matrix = (long)rows * (long)columns < 0x7FFFFFFDL ? new DenseDoubleMatrix2D(rows, columns) : new DenseLargeDoubleMatrix2D(rows, columns);
    }

    public DoubleMatrixDataset(LinkedHashMap<R, Integer> hashRows, LinkedHashMap<C, Integer> hashCols) {
        this.hashRows = hashRows;
        this.hashCols = hashCols;
        this.matrix = (long)hashRows.size() * (long)hashCols.size() < 0x7FFFFFFDL ? new DenseDoubleMatrix2D(hashRows.size(), hashCols.size()) : new DenseLargeDoubleMatrix2D(hashRows.size(), hashCols.size());
    }

    public DoubleMatrixDataset(DoubleMatrix2D matrix, LinkedHashMap<R, Integer> hashRows, LinkedHashMap<C, Integer> hashCols) {
        this.hashRows = hashRows;
        this.hashCols = hashCols;
        this.matrix = matrix;
    }

    public DoubleMatrixDataset(Collection<R> rowNames, Collection<C> colNames) {
        this.hashRows = new LinkedHashMap(rowNames.size());
        this.hashCols = new LinkedHashMap(colNames.size());
        int i = 0;
        for (Comparable row : rowNames) {
            this.hashRows.put(row, i);
            ++i;
        }
        i = 0;
        for (Comparable col : colNames) {
            this.hashCols.put(col, i);
            ++i;
        }
        this.matrix = (long)this.hashRows.size() * (long)this.hashCols.size() < 0x7FFFFFFDL ? new DenseDoubleMatrix2D(this.hashRows.size(), this.hashCols.size()) : new DenseLargeDoubleMatrix2D(this.hashRows.size(), this.hashCols.size());
    }

    public static DoubleMatrixDataset<String, String> loadDoubleData(String fileName) throws IOException {
        if (fileName.endsWith(".txt") || fileName.endsWith(".tsv") || fileName.endsWith(".txt.gz")) {
            return DoubleMatrixDataset.loadDoubleTextData(fileName, "\t");
        }
        if (fileName.endsWith(".binary")) {
            return DoubleMatrixDataset.loadDoubleBinaryData(fileName);
        }
        throw new IllegalArgumentException("File type must be \".txt\", \".tsv\" or \".txt.gz\" when delimiter is set to: \"tab\" \n Input filename: " + fileName);
    }

    public static DoubleMatrixDataset<String, String> loadDoubleTextData(String fileName, String delimiter) throws IOException {
        if (!(fileName.endsWith(".txt") || fileName.endsWith(".tsv") || fileName.endsWith(".txt.gz"))) {
            throw new IllegalArgumentException("File type must be \".txt\", \".tsv\" or \".txt.gz\" when delimiter is set. \n Input filename: " + fileName);
        }
        Pattern splitPatern = Pattern.compile(delimiter);
        int columnOffset = 1;
        TextFile in = new TextFile(fileName, false);
        String str = in.readLine();
        String[] data = splitPatern.split(str);
        int tmpCols = data.length - columnOffset;
        LinkedHashMap<String, Integer> colMap = new LinkedHashMap<String, Integer>((int)Math.ceil((double)tmpCols / 0.75));
        for (int s = 0; s < tmpCols; ++s) {
            String colName = data[s + columnOffset];
            if (colMap.containsKey(colName)) {
                LOGGER.warning("Duplicated column name!");
                throw doubleMatrixDatasetNonUniqueHeaderException;
            }
            colMap.put(colName, s);
        }
        int tmpRows = 0;
        while (in.readLine() != null) {
            ++tmpRows;
        }
        in.close();
        LinkedHashMap<String, Integer> rowMap = new LinkedHashMap<String, Integer>((int)Math.ceil((double)tmpRows / 0.75));
        Object tmpMatrix = (long)tmpRows * (long)tmpCols < 0x7FFFFFFDL ? new DenseDoubleMatrix2D(tmpRows, tmpCols) : new DenseLargeDoubleMatrix2D(tmpRows, tmpCols);
        in.open();
        in.readLine();
        int row = 0;
        boolean correctData = true;
        while ((str = in.readLine()) != null) {
            data = splitPatern.split(str);
            if (!rowMap.containsKey(data[0])) {
                rowMap.put(data[0], row);
                for (int s = 0; s < tmpCols; ++s) {
                    double d;
                    try {
                        d = Double.parseDouble(data[s + columnOffset]);
                    }
                    catch (NumberFormatException e) {
                        correctData = false;
                        d = Double.NaN;
                    }
                    tmpMatrix.setQuick(row, s, d);
                }
                ++row;
                continue;
            }
            LOGGER.warning("Duplicated row name!");
            throw doubleMatrixDatasetNonUniqueHeaderException;
        }
        if (!correctData) {
            LOGGER.warning("Your data contains NaN/unparseable values!");
        }
        in.close();
        DoubleMatrixDataset<String, String> dataset = new DoubleMatrixDataset<String, String>((DoubleMatrix2D)tmpMatrix, rowMap, colMap);
        LOGGER.log(Level.INFO, "''{0}'' has been loaded, nrRows: {1} nrCols: {2}", new Object[]{fileName, dataset.matrix.rows(), dataset.matrix.columns()});
        return dataset;
    }

    public static DoubleMatrixDataset<String, String> loadSubsetOfTextDoubleData(String fileName, String delimiter, HashSet<String> desiredRows, HashSet<String> desiredCols) throws IOException {
        if (!fileName.endsWith(".txt") && !fileName.endsWith(".txt.gz")) {
            throw new IllegalArgumentException("File type must be .txt when delimiter is given (given filename: " + fileName + ")");
        }
        LinkedHashSet<Integer> desiredColPos = new LinkedHashSet<Integer>();
        Pattern splitPatern = Pattern.compile(delimiter);
        int columnOffset = 1;
        TextFile in = new TextFile(fileName, false);
        String str = in.readLine();
        String[] data = splitPatern.split(str);
        int tmpCols = data.length - columnOffset;
        LinkedHashMap<String, Integer> colMap = new LinkedHashMap<String, Integer>((int)Math.ceil((double)tmpCols / 0.75));
        int storedCols = 0;
        for (int s = 0; s < tmpCols; ++s) {
            String colName = data[s + columnOffset];
            if (!colMap.containsKey(colName) && (desiredCols == null || desiredCols.contains(colName) || desiredCols.isEmpty())) {
                colMap.put(colName, storedCols);
                desiredColPos.add(s);
                ++storedCols;
                continue;
            }
            if (!colMap.containsKey(colName)) continue;
            LOGGER.warning("Duplicated column name!");
            System.out.println("Tried to add: " + colName);
            throw doubleMatrixDatasetNonUniqueHeaderException;
        }
        LinkedHashSet<Integer> desiredRowPos = new LinkedHashSet<Integer>();
        int rowsToStore = 0;
        int totalRows = 0;
        while ((str = in.readLine()) != null) {
            String[] info = splitPatern.split(str);
            if (desiredRows == null || desiredRows.contains(info[0]) || desiredRows.isEmpty()) {
                ++rowsToStore;
                desiredRowPos.add(totalRows);
            }
            ++totalRows;
        }
        in.close();
        Object matrix = (long)rowsToStore * (long)tmpCols < 0x7FFFFFFDL ? new DenseDoubleMatrix2D(rowsToStore, storedCols) : new DenseLargeDoubleMatrix2D(rowsToStore, storedCols);
        in.open();
        in.readLine();
        int storingRow = 0;
        totalRows = 0;
        LinkedHashMap<String, Integer> rowMap = new LinkedHashMap<String, Integer>((int)Math.ceil((double)rowsToStore / 0.75));
        boolean correctData = true;
        while ((str = in.readLine()) != null) {
            if (desiredRowPos.contains(totalRows)) {
                data = splitPatern.split(str);
                if (!rowMap.containsKey(data[0])) {
                    rowMap.put(data[0], storingRow);
                    int storingCol = 0;
                    Iterator iterator = desiredColPos.iterator();
                    while (iterator.hasNext()) {
                        double d;
                        int s = (Integer)iterator.next();
                        try {
                            d = Double.parseDouble(data[s + columnOffset]);
                        }
                        catch (NumberFormatException e) {
                            correctData = false;
                            d = Double.NaN;
                        }
                        matrix.setQuick(storingRow, storingCol, d);
                        ++storingCol;
                    }
                    ++storingRow;
                } else if (rowMap.containsKey(data[0])) {
                    LOGGER.warning("Duplicated row name!");
                    System.out.println("Tried to add: " + data[0]);
                    throw doubleMatrixDatasetNonUniqueHeaderException;
                }
            }
            ++totalRows;
        }
        if (!correctData) {
            LOGGER.warning("Your data contains NaN/unparseable values!");
        }
        in.close();
        DoubleMatrixDataset<String, String> dataset = new DoubleMatrixDataset<String, String>((DoubleMatrix2D)matrix, rowMap, colMap);
        LOGGER.log(Level.INFO, "''{0}'' has been loaded, nrRows: {1} nrCols: {2}", new Object[]{fileName, dataset.matrix.rows(), dataset.matrix.columns()});
        return dataset;
    }

    private static DoubleMatrixDataset<String, String> loadDoubleBinaryData(String fileName) throws FileNotFoundException, IOException {
        File fileBinary = new File(fileName + ".dat");
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(fileBinary));
        byte[] bytes = new byte[4];
        in.read(bytes, 0, 4);
        int nrRows = DoubleMatrixDataset.byteArrayToInt(bytes);
        in.read(bytes, 0, 4);
        int nrCols = DoubleMatrixDataset.byteArrayToInt(bytes);
        Object matrix = (long)nrRows * (long)nrCols < 0x7FFFFFFDL ? new DenseDoubleMatrix2D(nrRows, nrCols) : new DenseLargeDoubleMatrix2D(nrRows, nrCols);
        LinkedHashMap<String, Integer> rowMap = DoubleMatrixDataset.loadIdentifiers(fileName + ".rows.txt");
        LinkedHashMap<String, Integer> colMap = DoubleMatrixDataset.loadIdentifiers(fileName + ".cols.txt");
        byte[] buffer = new byte[nrCols * 8];
        for (int row = 0; row < nrRows; ++row) {
            in.read(buffer, 0, nrCols * 8);
            int bufferLoc = 0;
            for (int col = 0; col < nrCols; ++col) {
                long bits = (long)(0xFF & buffer[bufferLoc + 7]) | (long)(0xFF & buffer[bufferLoc + 6]) << 8 | (long)(0xFF & buffer[bufferLoc + 5]) << 16 | (long)(0xFF & buffer[bufferLoc + 4]) << 24 | (long)(0xFF & buffer[bufferLoc + 3]) << 32 | (long)(0xFF & buffer[bufferLoc + 2]) << 40 | (long)(0xFF & buffer[bufferLoc + 1]) << 48 | (long)buffer[bufferLoc] << 56;
                matrix.setQuick(row, col, Double.longBitsToDouble(bits));
                bufferLoc += 8;
            }
        }
        in.close();
        DoubleMatrixDataset<String, String> dataset = new DoubleMatrixDataset<String, String>((DoubleMatrix2D)matrix, rowMap, colMap);
        LOGGER.log(Level.INFO, "Binary file ''{0}'' has been loaded, nrRows: {1} nrCols: {2}", new Object[]{fileName, nrRows, nrCols});
        return dataset;
    }

    private static LinkedHashMap<String, Integer> loadIdentifiers(String filename) throws IOException {
        TextFile tf = new TextFile(filename, false);
        String[] rowsArr = tf.readAsArray();
        tf.close();
        LinkedHashMap<String, Integer> rowMap = new LinkedHashMap<String, Integer>();
        for (String row : rowsArr) {
            rowMap.put(row, rowMap.size());
        }
        return rowMap;
    }

    public void save(File file) throws IOException {
        TextFile out = new TextFile(file, true);
        out.append('-');
        for (Comparable col : this.hashCols.keySet()) {
            out.append('\t');
            out.append(col.toString());
        }
        out.append('\n');
        int r = 0;
        for (Comparable row : this.hashRows.keySet()) {
            out.append(row.toString());
            for (int c = 0; c < this.matrix.columns(); ++c) {
                out.append('\t');
                out.append(String.valueOf(this.matrix.getQuick(r, c)));
            }
            out.append('\n');
            ++r;
        }
        out.close();
    }

    public void save(String fileName) throws IOException {
        this.save(new File(fileName));
    }

    public void saveDice(String fileName) throws IOException {
        TextFile out = new TextFile(fileName, true);
        out.append('-');
        for (Comparable row : this.hashRows.keySet()) {
            out.append('\t');
            out.append(row.toString());
        }
        out.append('\n');
        int c = 0;
        for (Comparable col : this.hashCols.keySet()) {
            out.append(col.toString());
            for (int r = 0; r < this.matrix.rows(); ++r) {
                out.append('\t');
                out.append(String.valueOf(this.matrix.getQuick(r, c)));
            }
            out.append('\n');
            ++c;
        }
        out.close();
    }

    private static byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    private static int byteArrayToInt(byte[] b) {
        return (b[0] << 24) + ((b[1] & 0xFF) << 16) + ((b[2] & 0xFF) << 8) + (b[3] & 0xFF);
    }

    public int rows() {
        return this.matrix.rows();
    }

    public int columns() {
        return this.matrix.columns();
    }

    public LinkedHashMap<R, Integer> getHashRows() {
        return this.hashRows;
    }

    public void setHashRows(LinkedHashMap<R, Integer> hashRows) {
        this.hashRows = hashRows;
    }

    public LinkedHashMap<C, Integer> getHashCols() {
        return this.hashCols;
    }

    public void setHashCols(LinkedHashMap<C, Integer> hashCols) {
        this.hashCols = hashCols;
    }

    public ArrayList<R> getRowObjects() {
        return new ArrayList<R>(this.hashRows.keySet());
    }

    public void setRowObjects(List<R> arrayList) throws Exception {
        LinkedHashMap<Comparable, Integer> newHashRows = new LinkedHashMap<Comparable, Integer>((int)Math.ceil((double)arrayList.size() / 0.75));
        int i = 0;
        for (Comparable s : arrayList) {
            if (newHashRows.containsKey(s)) {
                System.out.println("Error, new row names contains dupilcates.");
                throw doubleMatrixDatasetNonUniqueHeaderException;
            }
            newHashRows.put(s, i);
            ++i;
        }
        this.hashRows = newHashRows;
    }

    public ArrayList<C> getColObjects() {
        return new ArrayList<C>(this.hashCols.keySet());
    }

    public void setColObjects(List<C> arrayList) throws Exception {
        LinkedHashMap<Comparable, Integer> newHashCols = new LinkedHashMap<Comparable, Integer>((int)Math.ceil((double)arrayList.size() / 0.75));
        int i = 0;
        for (Comparable s : arrayList) {
            if (newHashCols.containsKey(s)) {
                System.out.println("Error, new column names contains dupilcates.");
                throw doubleMatrixDatasetNonUniqueHeaderException;
            }
            newHashCols.put(s, i);
            ++i;
        }
        this.hashCols = newHashCols;
    }

    public DoubleMatrix2D getMatrix() {
        return this.matrix;
    }

    public void setMatrix(DoubleMatrix2D matrix) {
        this.matrix = matrix;
    }

    public void setMatrix(double[][] matrix) {
        if ((long)matrix.length * (long)matrix[0].length < 0x7FFFFFFDL) {
            this.matrix = new DenseDoubleMatrix2D(matrix);
        } else {
            this.matrix = new DenseLargeDoubleMatrix2D(matrix.length, matrix[0].length);
            this.matrix.assign(matrix);
        }
    }

    public void OrderOnColumnnames() {
        LinkedHashMap<Comparable, Integer> newColHash = new LinkedHashMap<Comparable, Integer>((int)Math.ceil((double)this.matrix.columns() / 0.75));
        ArrayList<C> names = this.getColObjects();
        Collections.sort(names);
        int pos = 0;
        for (Comparable name : names) {
            newColHash.put(name, pos);
            ++pos;
        }
        this.reorderCols(newColHash);
    }

    public void OrderOnRownames() {
        LinkedHashMap<Comparable, Integer> newRowHash = new LinkedHashMap<Comparable, Integer>((int)Math.ceil((double)this.matrix.rows() / 0.75));
        ArrayList<R> names = this.getRowObjects();
        Collections.sort(names);
        int pos = -1;
        for (Comparable name : names) {
            newRowHash.put(name, ++pos);
        }
        this.reorderRows(newRowHash);
    }

    public void reorderRows(LinkedHashMap<R, Integer> mappingIndex) {
        boolean equal = this.compareHashRows(mappingIndex, this.hashRows);
        if (!equal) {
            Object newRawData = (long)this.rows() * (long)this.columns() < 0x7FFFFFFDL ? new DenseDoubleMatrix2D(this.rows(), this.columns()) : new DenseLargeDoubleMatrix2D(this.rows(), this.columns());
            for (Map.Entry<R, Integer> ent : mappingIndex.entrySet()) {
                int pos = this.getHashRows().get(ent.getKey());
                for (int s = 0; s < this.columns(); ++s) {
                    newRawData.set(ent.getValue().intValue(), s, this.getMatrix().get(pos, s));
                }
            }
            this.setHashRows(mappingIndex);
            this.setMatrix((DoubleMatrix2D)newRawData);
        }
    }

    public void reorderCols(LinkedHashMap<C, Integer> mappingIndex) {
        boolean equal = this.compareHashCols(mappingIndex, this.hashCols);
        if (!equal) {
            Object newRawData = (long)this.rows() * (long)this.columns() < 0x7FFFFFFDL ? new DenseDoubleMatrix2D(this.rows(), this.columns()) : new DenseLargeDoubleMatrix2D(this.rows(), this.columns());
            for (Map.Entry<C, Integer> ent : mappingIndex.entrySet()) {
                int pos = this.getHashCols().get(ent.getKey());
                for (int p = 0; p < this.rows(); ++p) {
                    newRawData.set(p, ent.getValue().intValue(), this.getMatrix().get(p, pos));
                }
            }
            this.setHashCols(mappingIndex);
            this.setMatrix((DoubleMatrix2D)newRawData);
        }
    }

    public DoubleMatrixDataset<C, R> viewDice() {
        return new DoubleMatrixDataset<C, R>(this.matrix.viewDice(), this.hashCols, this.hashRows);
    }

    private boolean compareHashCols(LinkedHashMap<C, Integer> mappingIndex, LinkedHashMap<C, Integer> originalHash) {
        for (Map.Entry<C, Integer> entry : mappingIndex.entrySet()) {
            if (entry.getValue() == originalHash.get(entry.getKey())) continue;
            return false;
        }
        return true;
    }

    private boolean compareHashRows(LinkedHashMap<R, Integer> mappingIndex, LinkedHashMap<R, Integer> originalHash) {
        for (Map.Entry<R, Integer> entry : mappingIndex.entrySet()) {
            if (entry.getValue() == originalHash.get(entry.getKey())) continue;
            return false;
        }
        return true;
    }

    public void setElement(R rowName, C columnName, double value) {
        Integer row = this.hashRows.get(rowName);
        Integer column = this.hashCols.get(columnName);
        if (row == null || column == null) {
            if (row == null) {
                throw new NoSuchElementException("Row not found: " + rowName.toString());
            }
            throw new NoSuchElementException("Column not found: " + columnName.toString());
        }
        this.matrix.setQuick(row.intValue(), column.intValue(), value);
    }

    public double getElement(R rowName, C columnName) {
        Integer row = this.hashRows.get(rowName);
        Integer column = this.hashCols.get(columnName);
        if (row != null && column != null) {
            return this.matrix.getQuick(row.intValue(), column.intValue());
        }
        if (row == null) {
            throw new NoSuchElementException("Row not found: " + rowName.toString());
        }
        throw new NoSuchElementException("Column not found: " + columnName.toString());
    }

    public DoubleMatrix1D getRow(R rowName) {
        Integer row = this.hashRows.get(rowName);
        if (row != null) {
            return this.matrix.viewRow(row.intValue());
        }
        throw new NoSuchElementException("Row not found: " + rowName.toString());
    }

    public double getElement(int row, int column) {
        return this.matrix.get(row, column);
    }

    public boolean containsRow(R rowId) {
        return this.hashRows.containsKey(rowId);
    }

    public boolean containsCol(C colId) {
        return this.hashCols.containsKey(colId);
    }
}

