/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.math.matrix;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class SymmetricShortDistanceMatrix {
    private int size;
    private short[] matrix;
    private static final double eLog10 = Math.log(10.0);
    private static final int MAX_ALL_PAIRS_STEPS = 50;
    public static final int MAX_VALUE = 65535;
    private long[] elementIndex;

    public SymmetricShortDistanceMatrix(int size) {
        this.size = size;
        long arraySize = (long)size * (long)(size + 1) / 2L;
        this.matrix = new short[(int)arraySize];
        this.elementIndex = new long[size];
        for (int x = 0; x < size; ++x) {
            this.elementIndex[x] = (long)x * (long)size - (long)x * (long)(x + 1) / 2L;
        }
        this.setMaxDistance();
    }

    public SymmetricShortDistanceMatrix(int size, boolean setMaxDistance) {
        this.size = size;
        long arraySize = (long)size * (long)(size + 1) / 2L;
        this.matrix = new short[(int)arraySize];
        this.elementIndex = new long[size];
        for (int x = 0; x < size; ++x) {
            this.elementIndex[x] = (long)x * (long)size - (long)x * (long)(x + 1) / 2L;
        }
        if (setMaxDistance) {
            this.setMaxDistance();
        }
    }

    public void setAllElements(int value) {
        for (int x = 0; x < this.size; ++x) {
            for (int y = x; y < this.size; ++y) {
                this.matrix[(int)this.getElement((int)x, (int)y)] = (short)(value - 32768);
            }
        }
    }

    private void setMaxDistance() {
        for (int x = 0; x < this.size; ++x) {
            for (int y = x; y < this.size; ++y) {
                this.matrix[(int)this.getElement((int)x, (int)y)] = Short.MAX_VALUE;
            }
        }
    }

    private long getElement(int x, int y) {
        if (x > y) {
            return this.elementIndex[y] + (long)x;
        }
        return this.elementIndex[x] + (long)y;
    }

    public void set(int x, int y, int value) {
        this.matrix[(int)this.getElement((int)x, (int)y)] = (short)(value - 32768);
    }

    public int get(int x, int y) {
        return this.matrix[(int)this.getElement(x, y)] + 32768;
    }

    public int size() {
        return this.size;
    }

    public int maxValue() {
        return 65535;
    }

    public void getAllPairsShortestPath() {
        int y;
        int x;
        short[][] matrixCopy = new short[this.size()][this.size()];
        for (x = 0; x < this.size(); ++x) {
            for (y = x + 1; y < this.size(); ++y) {
                int value = this.get(x, y);
                if (value > Short.MAX_VALUE) {
                    value = Short.MAX_VALUE;
                }
                matrixCopy[x][y] = (short)value;
                matrixCopy[y][x] = (short)value;
            }
        }
        for (int v = 0; v < this.size(); ++v) {
            matrixCopy[v][v] = 0;
        }
        this.matrix = null;
        System.gc();
        this.performLoops(matrixCopy, (short)this.size());
        this.matrix = new short[this.size * (this.size + 1) / 2];
        for (x = 0; x < this.size(); ++x) {
            for (y = x + 1; y < this.size(); ++y) {
                this.set(x, y, matrixCopy[x][y]);
            }
        }
        matrixCopy = null;
        System.gc();
    }

    private void performLoops(short[][] matrixCopy, short sz) {
        boolean previousPercentage = false;
        int[] genes = new int[]{925, 9077, 10207, 17440};
        for (short k = 0; k < sz; k = (short)(k + 1)) {
            for (short i = 0; i < sz; i = (short)(i + 1)) {
                short matrix_ik = matrixCopy[i][k];
                for (short j = i; j < sz; j = (short)(j + 1)) {
                    short valueShort;
                    int value = matrix_ik + matrixCopy[k][j];
                    if (value >= matrixCopy[i][j]) continue;
                    matrixCopy[i][j] = valueShort = (short)value;
                    matrixCopy[j][i] = valueShort;
                    matrix_ik = matrixCopy[i][k];
                }
            }
            if (sz <= 1000 || k % 10 != 9) continue;
            System.out.println(k);
        }
        System.out.println("");
    }

    public Vector getShortestPath(int x, int y) {
        int i;
        Vector<Integer> path = new Vector<Integer>();
        boolean[] S = new boolean[this.size()];
        int[][] T = new int[2][this.size()];
        for (i = 0; i < this.size(); ++i) {
            S[i] = false;
            T[0][i] = this.maxValue();
            T[1][i] = -1;
        }
        S[x] = true;
        T[0][x] = 0;
        T[1][x] = x;
        for (i = 0; i < this.size(); ++i) {
            if (i == x || this.get(i, x) >= this.maxValue()) continue;
            T[0][i] = this.get(i, x);
            T[1][i] = x;
        }
        boolean pathPossible = false;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (this.get(i2, x) <= 0) continue;
            pathPossible = true;
        }
        boolean pathExists = true;
        boolean traversePath = true;
        block3: while (pathPossible && pathExists && traversePath) {
            int i3;
            int tMin = this.maxValue();
            int v = -1;
            for (i3 = 0; i3 < this.size(); ++i3) {
                if (S[i3] || T[0][i3] >= tMin) continue;
                tMin = T[0][i3];
                v = i3;
            }
            if (v == -1) {
                pathExists = false;
                break;
            }
            S[v] = true;
            for (i3 = 0; i3 < this.size(); ++i3) {
                if (S[i3] || this.get(v, i3) <= 0 || T[0][v] + this.get(v, i3) >= T[0][i3]) continue;
                T[0][i3] = T[0][v] + this.get(v, i3);
                T[1][i3] = v;
            }
            if (S[y]) {
                traversePath = false;
                continue;
            }
            pathExists = false;
            for (i3 = 0; i3 < this.size(); ++i3) {
                if (S[i3] || T[0][i3] >= this.maxValue()) continue;
                pathExists = true;
                continue block3;
            }
        }
        if (pathExists && pathPossible) {
            path.add(new Integer(y));
            int totalDistance = T[0][y];
            int predecessor = T[1][y];
            path.add(new Integer(predecessor));
            while (predecessor != x) {
                totalDistance += T[0][predecessor];
                predecessor = T[1][predecessor];
                path.add(new Integer(predecessor));
            }
        }
        return path;
    }

    public int getDistance(double pValue) {
        return (int)(Math.max(Math.log(pValue) / eLog10, -7.9998779296875) * 8192.0 + 65535.0);
    }

    public double getPValue(int distance) {
        return Math.pow(10.0, ((double)distance - 65535.0) / 8192.0);
    }

    public int getDistanceFromCorrelation(double correlation) {
        int distance = correlation > 0.0 ? (int)(32768.0 + correlation * 32767.0) : (int)(32768.0 + correlation * -32768.0);
        return distance;
    }

    public double getCorrelationFromDistance(int distance) {
        double correlation = distance > 32768 ? ((double)distance + -32768.0) / 32767.0 : ((double)distance + -32768.0) / 32768.0;
        return correlation;
    }

    public void save(File fileName) {
        try {
            int x;
            int bufferLoc;
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fileName));
            int bufferLength = 2560000;
            byte[] buffer = new byte[bufferLength * 2];
            int len = 0;
            int loc = 0;
            while (loc + bufferLength <= this.matrix.length) {
                len = bufferLength;
                bufferLoc = 0;
                for (x = loc; x < len + loc; ++x) {
                    buffer[bufferLoc] = (byte)(this.matrix[x] >> 8);
                    buffer[bufferLoc + 1] = (byte)(this.matrix[x] & 0xFF);
                    bufferLoc += 2;
                }
                loc += len;
                System.out.print(".");
                ((OutputStream)out).write(buffer);
            }
            len = this.matrix.length - loc;
            buffer = new byte[len * 2];
            bufferLoc = 0;
            for (x = loc; x < len + loc; ++x) {
                buffer[bufferLoc] = (byte)(this.matrix[x] >> 8);
                buffer[bufferLoc + 1] = (byte)(this.matrix[x] & 0xFF);
                bufferLoc += 2;
            }
            ((OutputStream)out).write(buffer);
            System.out.print(".");
            System.out.println("");
            buffer = null;
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            System.out.println("Cannot write to file! (" + e.getMessage() + ")");
        }
    }

    public void load(File fileName) {
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(fileName));
            long length = fileName.length();
            long matrixLength = 2L * (long)this.matrix.length;
            if (length == matrixLength) {
                int bufferLength = 5120000;
                byte[] buffer = new byte[bufferLength];
                int len = 0;
                int loc = 0;
                while ((len = ((InputStream)in).read(buffer, 0, bufferLength)) != -1) {
                    for (int x = 0; x < len; x += 2) {
                        this.matrix[loc] = (short)(buffer[x] << 8 | buffer[x + 1] & 0xFF);
                        ++loc;
                    }
                }
                buffer = null;
            } else {
                System.out.println("File does not adhere to the matrix size! Actual file length:\t" + length + "\t, should be:\t" + this.matrix.length * 2);
            }
            ((InputStream)in).close();
        }
        catch (IOException e) {
            System.out.println("Cannot read from file! (" + e.getMessage() + ")");
        }
    }
}

