/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.math;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import Jama.SingularValueDecomposition;

public class PCA {
    private EigenvalueDecomposition eig;
    private double[][] eigenVectors;

    public void PCA() {
    }

    public static EigenvalueDecomposition eigenValueDecomposition(double[][] data) {
        Matrix m = new Matrix(data);
        EigenvalueDecomposition eig = m.eig();
        return eig;
    }

    public static double[] getRealEigenvalues(EigenvalueDecomposition eig) {
        return eig.getRealEigenvalues();
    }

    public static double[] getEigenVector(EigenvalueDecomposition eig, double[] eigenValues, int pca) {
        Matrix eigenValueMatrix = eig.getV();
        double[][] eigenValueMat = eigenValueMatrix.getArray();
        double[] eigenVector = new double[eigenValueMat.length];
        for (int i = 0; i < eigenValueMat.length; ++i) {
            eigenVector[i] = eigenValueMat[i][eigenValueMat.length - 1 - pca];
        }
        return eigenVector;
    }

    public static double[] getEigenVector(EigenvalueDecomposition eig, int pca) {
        Matrix eigenValueMatrix = eig.getV();
        double[][] eigenValueMat = eigenValueMatrix.getArray();
        double[] eigenVector = new double[eigenValueMat.length];
        for (int i = 0; i < eigenValueMat.length; ++i) {
            eigenVector[i] = eigenValueMat[i][eigenValueMat.length - 1 - pca];
        }
        return eigenVector;
    }

    public static double getEigenValueVar(double[] eigenValues, int pca) {
        double sumEigenvalues = 0.0;
        double[] dArray = eigenValues;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double d = dArray[i];
            sumEigenvalues += Math.abs(d);
        }
        double result = eigenValues[eigenValues.length - 1 - pca] / sumEigenvalues;
        return result;
    }

    public static double[] getEigenVectorSVD(SingularValueDecomposition svd, double[] singularValues, int pca) {
        Matrix eigenValueMatrix = svd.getV();
        double[][] eigenValueMat = eigenValueMatrix.getArray();
        double[] eigenVector = new double[eigenValueMat.length];
        for (int i = 0; i < eigenValueMat.length; ++i) {
            eigenVector[i] = eigenValueMat[i][pca] * Math.sqrt(singularValues[pca]);
        }
        return eigenVector;
    }

    public void eigenValueDecomposition(double[][] data, int numPCAs) {
        Matrix m = new Matrix(data);
        this.eig = m.eig();
        this.eigenVectors = new double[data.length][data.length];
        for (int pca = 0; pca < numPCAs; ++pca) {
            this.eigenVectors[pca] = PCA.getEigenVector(this.eig, pca);
        }
    }

    public double[][] getDataMatrixPCScores(double[][] dataMatrix, int size, int sampleCount) {
        double[][] dataMatrixPCScores = new double[size][sampleCount];
        for (int sample = 0; sample < sampleCount; ++sample) {
            for (int p = 0; p < size; ++p) {
                for (int snp = 0; snp < size; ++snp) {
                    double probeCoefficient = this.eigenVectors[p][snp];
                    double[] dArray = dataMatrixPCScores[p];
                    int n = sample;
                    dArray[n] = dArray[n] + dataMatrix[snp][sample] * probeCoefficient;
                }
            }
        }
        return dataMatrixPCScores;
    }

    public double[] getRealEigenvalues() {
        return this.eig.getRealEigenvalues();
    }
}

