/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.ucsc;

import java.io.IOException;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.util.ChrAnnotation;
import umcg.genetica.io.ucsc.UCSCDataObject;
import umcg.genetica.text.Strings;

public class PeakFile
extends TextFile {
    private byte currentChr = (byte)-1;
    private int currentStart = 0;
    private int currentStep = 1;
    private int currentSpan = 1;
    private long nrLnsReadAfterHeader = 0L;
    private PEAKFORMAT peakformat = null;

    public PeakFile(String name, boolean mode) throws IOException {
        super(name, mode);
    }

    public PeakFile(String name, boolean mode, PEAKFORMAT format) throws IOException {
        super(name, mode);
        this.peakformat = format;
    }

    public UCSCDataObject parseLn() throws IOException {
        String line = this.readLine();
        if (line == null) {
            return null;
        }
        boolean isHeaderLine = false;
        if (line.toLowerCase().contains("track") || line.toLowerCase().contains("narrowpeak") || line.toLowerCase().contains("gappedpeak") || line.toLowerCase().contains("broadpeak")) {
            if (line.toLowerCase().contains("narrowpeak")) {
                this.peakformat = PEAKFORMAT.NARROWPEAK;
            } else if (line.toLowerCase().contains("gappedpeak")) {
                this.peakformat = PEAKFORMAT.GAPPEDPEAK;
            } else if (line.toLowerCase().contains("broadpeak")) {
                this.peakformat = PEAKFORMAT.BROADPEAK;
            } else {
                System.out.println("Error: unkown peak format!\n" + line);
            }
            System.out.println("File is: " + (Object)((Object)this.peakformat));
            isHeaderLine = true;
        }
        if (this.peakformat == null) {
            throw new IOException("Error: " + this.file.getAbsolutePath() + " does not adhere to any of the peak formats");
        }
        String[] elems = Strings.whitespace.split(line);
        if (isHeaderLine && elems.length > 1) {
            this.nrLnsReadAfterHeader = 0L;
            return this.parseLn();
        }
        if (elems.length > 0) {
            UCSCDataObject output = null;
            try {
                byte chr = -1;
                int chrStart = -1;
                int chrStop = -1;
                String name = null;
                int score = -1;
                String Strand = null;
                double signal = -1.0;
                double pval = -1.0;
                double qval = -1.0;
                int peak = -1;
                chr = ChrAnnotation.parseChr(elems[0].replace("chr", ""));
                chrStart = Integer.parseInt(elems[1]);
                chrStop = Integer.parseInt(elems[2]);
                name = elems[3];
                score = Integer.parseInt(elems[4]);
                Strand = elems[5];
                if (this.peakformat == PEAKFORMAT.NARROWPEAK || this.peakformat == PEAKFORMAT.BROADPEAK) {
                    signal = Double.parseDouble(elems[6]);
                    pval = Double.parseDouble(elems[7]);
                    qval = Double.parseDouble(elems[8]);
                }
                if (this.peakformat == PEAKFORMAT.NARROWPEAK) {
                    peak = Integer.parseInt(elems[9]);
                }
                output = new UCSCDataObject(chr, chrStart, chrStop, signal, UCSCDataObject.SORTBY.CHRPOS);
                ++this.nrLnsReadAfterHeader;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (output == null) {
                return this.parseLn();
            }
            return output;
        }
        return null;
    }

    public long size() {
        return this.file.length();
    }

    public static enum PEAKFORMAT {
        NARROWPEAK,
        BROADPEAK,
        GAPPEDPEAK;

    }
}

