/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper.probeannotation;

import java.io.IOException;
import java.util.HashMap;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.util.ChrAnnotation;

public class ProbeTranslation {
    private String[] probeSymbol;
    private byte[] probeChr;
    private int[] probeChrPos;
    private HashMap<Integer, String> actualMappingPosition;
    private String[] probeName;
    private HashMap<String, Integer> oldToNewProbeAddress;
    private HashMap<String, Integer> toProbeAnnotationId;

    public void load(String probeAnnotation) throws IOException {
        TextFile tf = new TextFile(probeAnnotation, false);
        int numSeq = tf.countLines();
        String[] elems = tf.readLineElemsReturnReference(TextFile.tab);
        int numAnnotations = elems.length - 5;
        int num = 0;
        System.out.println("Available annotations: ");
        String[] annotationname = new String[numAnnotations];
        for (int i = 5; i < elems.length; ++i) {
            String name;
            annotationname[i - 5] = name = elems[i];
            System.out.println(name);
        }
        this.probeName = new String[numSeq];
        this.probeChr = new byte[numSeq];
        this.probeChrPos = new int[numSeq];
        this.probeSymbol = new String[numSeq];
        this.oldToNewProbeAddress = new HashMap();
        this.toProbeAnnotationId = new HashMap();
        elems = tf.readLineElemsReturnObjects(TextFile.tab);
        this.actualMappingPosition = new HashMap();
        int probeNum = 0;
        while (elems != null) {
            Integer newProbeNum = null;
            try {
                newProbeNum = Integer.parseInt(elems[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (newProbeNum != null) {
                String seq = elems[1];
                String chr = elems[2];
                String chrpos = elems[3];
                String symbol = elems[4];
                num = 0;
                this.probeName[probeNum] = elems[0].intern();
                int bchr = -1;
                try {
                    bchr = ChrAnnotation.parseChr(chr);
                }
                catch (Exception e) {
                    bchr = -1;
                    System.out.println("Cannot parse chr: " + chr);
                }
                int bchrpos = -1;
                try {
                    bchrpos = Integer.parseInt(chrpos);
                }
                catch (Exception e) {
                    String[] list = chrpos.split("-");
                    int max = -1;
                    int min = Integer.MAX_VALUE;
                    try {
                        for (String s : list) {
                            String[] list2;
                            for (String s2 : list2 = s.split(":")) {
                                int p = Integer.parseInt(s2);
                                if (p > max) {
                                    max = p;
                                }
                                if (p >= min) continue;
                                min = p;
                            }
                        }
                        bchrpos = (int)Math.floor((double)(max + min) / 2.0);
                    }
                    catch (Exception e2) {
                        System.out.println("Could not calculate midpos");
                        bchrpos = -1;
                    }
                }
                this.actualMappingPosition.put(probeNum, chrpos);
                this.probeChr[probeNum] = bchr;
                this.probeChrPos[probeNum] = bchrpos;
                this.probeSymbol[probeNum] = symbol.intern();
                for (int i = 5; i < elems.length; ++i) {
                    String arrayaddress = elems[i];
                    if (!arrayaddress.equals("-")) {
                        try {
                            String[] addresselems = arrayaddress.split(",");
                            for (int q = 0; q < addresselems.length; ++q) {
                                String address = addresselems[q].intern();
                                this.oldToNewProbeAddress.put(annotationname[i - 5] + address.intern(), probeNum);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++num;
                }
            }
            elems = tf.readLineElemsReturnObjects(TextFile.tab);
            ++probeNum;
        }
        tf.close();
    }

    public HashMap<String, String> getProbeTranslation(String probeTranslationFile, String source, String dest) throws IOException {
        System.out.println("Reading probe annotation table from: " + probeTranslationFile);
        System.out.println("Selecting " + source + " as translation for " + dest);
        HashMap<String, String> output = new HashMap<String, String>();
        TextFile tf = new TextFile(probeTranslationFile, false);
        String[] header = tf.readLineElems(TextFile.tab);
        int sourcecol = -1;
        int destcol = -1;
        for (int i = 0; i < header.length; ++i) {
            if (header[i].equals(source)) {
                sourcecol = i;
            }
            if (!header[i].equals(dest)) continue;
            destcol = i;
        }
        if (sourcecol < 0) {
            System.err.println("Column: " + source + " not found");
            return null;
        }
        if (destcol < 0) {
            System.err.println("Column: " + dest + " not found");
            return null;
        }
        System.out.println("Source: " + sourcecol + "\tDest: " + destcol);
        if (destcol >= 0 && sourcecol >= 0) {
            String[] elems = tf.readLineElems(TextFile.tab);
            while (elems != null) {
                String sourceStr = elems[sourcecol];
                String destStr = elems[destcol];
                output.put(sourceStr, destStr);
                elems = tf.readLineElems(TextFile.tab);
            }
        }
        tf.close();
        return output;
    }

    public byte getProbeChr(int p) {
        return this.probeChr[p];
    }

    public String getActualMappingPosition(Integer probeId) {
        return this.actualMappingPosition.get(probeId);
    }

    public int getProbeChrPos(int p) {
        return this.probeChrPos[p];
    }

    public String getProbeSymbol(int p) {
        return this.probeSymbol[p];
    }

    public int getNumProbes() {
        return this.probeName.length;
    }

    public Integer getProbeId(String string) {
        return this.oldToNewProbeAddress.get(string);
    }

    public HashMap<String, Integer> getProbeTranslationTable() {
        return this.oldToNewProbeAddress;
    }

    public String[] getProbes() {
        return this.probeName;
    }
}

