/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper.converters;

import JSci.maths.ArrayMath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import umcg.genetica.console.ProgressBar;
import umcg.genetica.containers.SortableSNP;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.SNP;
import umcg.genetica.io.trityper.SNPLoader;
import umcg.genetica.io.trityper.TriTyperGenotypeData;
import umcg.genetica.io.trityper.util.DetermineLD;

public class TriTyperReferenceConcordantPedAndMapExporter {
    private Double CRTHRESHOLD = 0.95;
    private Double HWEPTHRESHOLD = 1.0E-4;
    private Double MAFTHRESHOLD = 0.01;
    int numDatasetIndividuals = 0;
    int numReferenceIndividuals = 0;
    private int[] alleleIndex;
    String[] alleleNames = new String[]{"A", "C", "G", "T"};
    private TriTyperGenotypeData referenceGenotypeDataset;
    private TriTyperGenotypeData dataGenotypeDataset;
    private TextFile log;
    private DetermineLD ldcalcdataset;
    private DetermineLD ldcalchapmap;
    private HashSet<String> uniquebatches = null;
    private HashMap<String, String> sampleInBatch = null;
    private Object familyData;
    private HashMap<String, String> referenceAlleles = new HashMap();
    private HashSet<String> snpsExcluded = new HashSet();
    private static int selectedchr = -1;

    public TriTyperReferenceConcordantPedAndMapExporter() {
        this.alleleIndex = new int[256];
        for (int a = 0; a < 256; ++a) {
            this.alleleIndex[a] = 4;
        }
        this.alleleIndex[65] = 0;
        this.alleleIndex[67] = 1;
        this.alleleIndex[71] = 2;
        this.alleleIndex[84] = 3;
        this.ldcalcdataset = new DetermineLD();
        this.ldcalchapmap = new DetermineLD();
    }

    public void export(String referenceLoc, String datasetLoc, String batches, String excludesnps, String output) throws IOException {
        int i;
        if (excludesnps != null) {
            this.loadExcludeSNPs(excludesnps);
        }
        if (batches != null) {
            this.loadBatches(batches);
        }
        this.referenceGenotypeDataset = new TriTyperGenotypeData();
        this.referenceGenotypeDataset.load(referenceLoc);
        this.numReferenceIndividuals = this.referenceGenotypeDataset.getIndividuals().length;
        this.dataGenotypeDataset = new TriTyperGenotypeData();
        this.dataGenotypeDataset.load(datasetLoc);
        this.numDatasetIndividuals = this.dataGenotypeDataset.getIndividuals().length;
        String[] referenceSNPs = this.referenceGenotypeDataset.getSNPs();
        String[] datasetSNPs = this.dataGenotypeDataset.getSNPs();
        ArrayList<SortableSNP> sortedOverlapSNPList = new ArrayList<SortableSNP>();
        int nrnotinref = 0;
        int nrrefwrongmapping = 0;
        int nrwrongmapping = 0;
        int nrdiffchrpos = 0;
        if (!output.endsWith("/")) {
            output = output + "/";
        }
        this.log = new TextFile(output + "exportlog.txt", true);
        for (int i2 = 0; i2 < datasetSNPs.length; ++i2) {
            String s = datasetSNPs[i2];
            if (this.snpsExcluded.contains(s)) {
                this.log.writeln(s + "\t excluded by user");
                continue;
            }
            int refSNPId = this.referenceGenotypeDataset.getSnpToSNPId().get((Object)s);
            if (refSNPId == -9) {
                this.log.writeln(s + "\t is not in reference");
                ++nrnotinref;
                continue;
            }
            byte refsnpchr = this.referenceGenotypeDataset.getChr(refSNPId);
            int refsnpchrpos = this.referenceGenotypeDataset.getChrPos(refSNPId);
            if (refsnpchr < 1 || refsnpchrpos < 1 || refsnpchr > 22) {
                this.log.writeln(s + "\t is wrongly mapped or on sex chr in reference (chr: " + refsnpchr + ", chrpos: " + refsnpchrpos + ")");
                ++nrrefwrongmapping;
                continue;
            }
            byte chr = this.dataGenotypeDataset.getChr(i2);
            int chrpos = this.dataGenotypeDataset.getChrPos(i2);
            if (chr < 1 || chrpos < 1) {
                this.log.writeln(s + "\t is wrongly mapped in dataset (chr: " + chr + ", chrpos: " + chrpos + ")");
                ++nrwrongmapping;
                continue;
            }
            if (refsnpchr == chr && refsnpchrpos == chrpos && (selectedchr < 1 || selectedchr == chr)) {
                sortedOverlapSNPList.add(new SortableSNP(s, i2, chr, chrpos, SortableSNP.SORTBY.ID));
                continue;
            }
            this.log.writeln(s + "\t maps to a different position in reference (dataset chr: " + chr + ", chrpos: " + chrpos + ", reference chr: " + refsnpchr + ", chrpos: " + refsnpchrpos + ")");
            ++nrdiffchrpos;
        }
        System.out.println(sortedOverlapSNPList.size() + "\t SNPs overlap between reference and dataset");
        System.out.println(nrnotinref + "\tnot in reference");
        System.out.println(nrrefwrongmapping + "\tref wrongly mapped (chr < 1 || chrpos < 1)");
        System.out.println(nrwrongmapping + "\tdataset wrongly mapped");
        System.out.println(nrdiffchrpos + "\tref and data have different mapping positions");
        Collections.sort(sortedOverlapSNPList);
        SNPLoader referenceLoader = this.referenceGenotypeDataset.createSNPLoader();
        SNPLoader datasetLoader = this.dataGenotypeDataset.createSNPLoader();
        int buffersize = 10000;
        int snpcounter = 0;
        int nrExcludedByAllelicDirectionFilter = 0;
        int nrWithSwappedDirection = 0;
        ArrayList includedSortedDatasetSNPList = new ArrayList();
        HashMap<String, Boolean> alleleswapped = new HashMap<String, Boolean>();
        System.out.println("Checking allelic directions and SNP quality checks");
        ProgressBar pb = new ProgressBar(sortedOverlapSNPList.size());
        int chr1snpspassingqc = 0;
        int chr1snpsnotpassingqc = 0;
        int chr1snpsnotalleleqc = 0;
        int chr1snpstotal = 0;
        int chr1snpspassingalleleqc = 0;
        Boolean[] snpIncluded = new Boolean[sortedOverlapSNPList.size()];
        while (snpcounter < sortedOverlapSNPList.size()) {
            SNP datasetSNP;
            Object refSNP;
            if (snpcounter + buffersize > sortedOverlapSNPList.size()) {
                buffersize = sortedOverlapSNPList.size() - snpcounter;
            }
            SNP[] datasetSNPBuffer = new SNP[buffersize];
            SNP[] referenceSNPBuffer = new SNP[buffersize];
            boolean[] snpPassesQC = new boolean[buffersize];
            ArrayList<Object> refbufferSortedSNPs = new ArrayList<Object>();
            HashMap<String, Object> datasetToReference = new HashMap<String, Object>();
            HashMap<String, Integer> referenceToDataset = new HashMap<String, Integer>();
            for (i = 0; i < buffersize; ++i) {
                snpIncluded[i + snpcounter] = false;
                SortableSNP snp = (SortableSNP)sortedOverlapSNPList.get(i + snpcounter);
                datasetSNPBuffer[i] = this.dataGenotypeDataset.getSNPObject(snp.id);
                datasetLoader.loadGenotypes(datasetSNPBuffer[i]);
                refSNP = new SortableSNP(snp.name, this.referenceGenotypeDataset.getSnpToSNPId().get((Object)snp.name), snp.chr, snp.chrpos, SortableSNP.SORTBY.ID);
                datasetToReference.put(snp.name, refSNP);
                referenceToDataset.put(snp.name, i);
                refbufferSortedSNPs.add(refSNP);
            }
            for (i = 0; i < buffersize; ++i) {
                datasetSNP = datasetSNPBuffer[i];
                if (datasetSNP.getChr() == 1) {
                    ++chr1snpstotal;
                }
                if (datasetSNP.getCR() > this.CRTHRESHOLD && datasetSNP.getHWEP() > this.HWEPTHRESHOLD && datasetSNP.getMAF() > this.MAFTHRESHOLD) {
                    snpPassesQC[i] = true;
                    if (datasetSNP.getChr() != 1) continue;
                    ++chr1snpspassingqc;
                    continue;
                }
                if (datasetSNP.getChr() == 1) {
                    ++chr1snpsnotpassingqc;
                }
                datasetSNP.clearGenotypes();
                datasetSNPBuffer[i] = null;
                snpPassesQC[i] = false;
                this.log.writeln(datasetSNP.getName() + "\t does not pass QC. CR: " + datasetSNP.getCR() + ", HWEP: " + datasetSNP.getHWEP() + ", MAF: " + datasetSNP.getMAF());
            }
            Collections.sort(refbufferSortedSNPs);
            for (i = 0; i < buffersize; ++i) {
                Integer id = ((SortableSNP)refbufferSortedSNPs.get((int)i)).id;
                refSNP = this.referenceGenotypeDataset.getSNPObject(id);
                referenceLoader.loadGenotypes((SNP)refSNP);
                Integer position = (Integer)referenceToDataset.get(((SNP)refSNP).getName());
                referenceSNPBuffer[position.intValue()] = refSNP;
            }
            for (i = 0; i < buffersize; ++i) {
                datasetSNP = datasetSNPBuffer[i];
                SNP referenceSNP = referenceSNPBuffer[i];
                if (datasetSNP != null && referenceSNP != null) {
                    if (datasetSNP.getName().equals(referenceSNP.getName())) {
                        if (!snpPassesQC[i]) continue;
                        Boolean swapalleles = this.compareAllelicDirection(referenceSNP, datasetSNP);
                        if (swapalleles == null) {
                            if (datasetSNP.getChr() == 1) {
                                ++chr1snpsnotalleleqc;
                            }
                            ++nrExcludedByAllelicDirectionFilter;
                            ++chr1snpsnotpassingqc;
                            continue;
                        }
                        if (datasetSNP.getChr() == 1) {
                            ++chr1snpspassingalleleqc;
                        }
                        SortableSNP selected = (SortableSNP)sortedOverlapSNPList.get(i + snpcounter);
                        selected.s = SortableSNP.SORTBY.CHR;
                        includedSortedDatasetSNPList.add(sortedOverlapSNPList.get(i + snpcounter));
                        alleleswapped.put(datasetSNP.getName(), swapalleles);
                        if (!swapalleles.booleanValue()) continue;
                        ++nrWithSwappedDirection;
                        continue;
                    }
                    System.out.println("ERROR names of SNPs not equal:" + datasetSNP.getName() + "\t" + referenceSNP.getName());
                    System.exit(0);
                    continue;
                }
                if (datasetSNP == null || referenceSNP != null) continue;
                System.out.println("ERROR: REFERENCE SNP IS NULL WHILE DATASET IS NOT");
            }
            for (i = 0; i < buffersize; ++i) {
                if (datasetSNPBuffer[i] != null) {
                    datasetSNPBuffer[i].clearGenotypes();
                }
                if (referenceSNPBuffer[i] != null) {
                    referenceSNPBuffer[i].clearGenotypes();
                }
                datasetSNPBuffer[i] = null;
                referenceSNPBuffer[i] = null;
            }
            pb.set(snpcounter += buffersize);
        }
        pb.close();
        System.out.println("pqc " + chr1snpspassingqc + ", npqc " + chr1snpsnotpassingqc + ", naqc " + chr1snpsnotalleleqc + ", tot " + chr1snpstotal + ", totpaqc " + chr1snpspassingalleleqc + "");
        System.out.println(includedSortedDatasetSNPList.size() + "/" + sortedOverlapSNPList.size() + "\t pass allelic direction check.\t" + nrExcludedByAllelicDirectionFilter + " excluded");
        System.out.println(nrWithSwappedDirection + "\t snps with swapped direction alleles");
        Collections.sort(includedSortedDatasetSNPList);
        for (int chr = 1; chr < 23; ++chr) {
            int i3;
            int snp;
            ArrayList<SortableSNP> snpsForChr = new ArrayList<SortableSNP>();
            for (snp = 0; snp < includedSortedDatasetSNPList.size(); ++snp) {
                if (((SortableSNP)includedSortedDatasetSNPList.get((int)snp)).chr != chr) continue;
                SortableSNP selected = (SortableSNP)includedSortedDatasetSNPList.get(snp);
                selected.s = SortableSNP.SORTBY.CHRPOS;
                snpsForChr.add(selected);
            }
            Collections.sort(snpsForChr);
            System.out.println(snpsForChr.size() + "\t SNPs for chr " + chr);
            for (snp = 0; snp < snpsForChr.size() - 1; ++snp) {
                if (((SortableSNP)snpsForChr.get((int)snp)).chrpos <= ((SortableSNP)snpsForChr.get((int)(snp + 1))).chrpos) continue;
                System.out.println("SNP LIST NOT PROPERLY SORTED");
                System.exit(0);
            }
            SNP[] datasetSNPObjs = new SNP[snpsForChr.size()];
            boolean[] takeComplement = new boolean[datasetSNPObjs.length];
            SNP[] referenceSNPObjs = new SNP[snpsForChr.size()];
            for (i3 = 0; i3 < datasetSNPObjs.length; ++i3) {
                SortableSNP datasetSNP = (SortableSNP)snpsForChr.get(i3);
                Integer refSNPId = this.referenceGenotypeDataset.getSnpToSNPId().get((Object)datasetSNP.name);
                referenceSNPObjs[i3] = this.referenceGenotypeDataset.getSNPObject(refSNPId);
                datasetSNPObjs[i3] = this.dataGenotypeDataset.getSNPObject(datasetSNP.id);
                datasetLoader.loadGenotypes(datasetSNPObjs[i3]);
                takeComplement[i3] = (Boolean)alleleswapped.get(datasetSNP.name);
            }
            for (i3 = 0; i3 < datasetSNPObjs.length; ++i3) {
                referenceLoader.loadGenotypes(referenceSNPObjs[i3]);
            }
            System.out.println("Now testing LD structure for chromosome: " + chr);
            boolean[] snpsPassingQC = this.testLDStructure(referenceSNPObjs, datasetSNPObjs, takeComplement);
            for (i = 0; i < datasetSNPObjs.length; ++i) {
                referenceSNPObjs[i].clearGenotypes();
                referenceSNPObjs[i] = null;
            }
            this.writePedMapDat(output, chr, datasetSNPObjs, takeComplement, snpsPassingQC);
            for (i = 0; i < datasetSNPObjs.length; ++i) {
                datasetSNPObjs[i].clearGenotypes();
                datasetSNPObjs[i] = null;
            }
        }
        this.log.close();
    }

    private Boolean compareAllelicDirection(SNP snpDataObjectHapMap, SNP snpDataObject) throws IOException {
        byte[] allelesbytesreference = snpDataObjectHapMap.getAlleles();
        String alleles = new String(snpDataObject.getAlleles());
        String allelesreference = null;
        Boolean takeComplement = false;
        try {
            allelesreference = new String(snpDataObjectHapMap.getAlleles(), "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.referenceAlleles.put(snpDataObject.getName(), allelesreference);
        boolean allelesOk = true;
        if (allelesbytesreference[0] == 0 || allelesbytesreference[1] == 0) {
            this.log.writeln(snpDataObject.getName() + "\t has a null allele in reference: " + allelesreference);
            return null;
        }
        if (allelesreference == null) {
            System.out.println("Alleles in HAPMAP are NULL");
            System.exit(1);
        }
        boolean strandForward = true;
        int[] alleleIndex1 = new int[5];
        for (int ind = 0; ind < this.numDatasetIndividuals; ++ind) {
            if (!this.dataGenotypeDataset.getIsIncluded()[ind].booleanValue()) continue;
            byte[] snpallele1 = snpDataObject.getAllele1();
            byte[] snpallele2 = snpDataObject.getAllele2();
            byte allele1Byte = snpallele1[ind];
            int n = this.alleleIndex[allele1Byte];
            alleleIndex1[n] = alleleIndex1[n] + 1;
            byte allele2Byte = snpallele2[ind];
            int n2 = this.alleleIndex[allele2Byte];
            alleleIndex1[n2] = alleleIndex1[n2] + 1;
        }
        int[] alleleIndex2 = new int[5];
        for (int ind = 0; ind < this.numReferenceIndividuals; ++ind) {
            if (!this.referenceGenotypeDataset.getIsIncluded()[ind].booleanValue()) continue;
            byte[] snpallele1 = snpDataObjectHapMap.getAllele1();
            byte[] snpallele2 = snpDataObjectHapMap.getAllele2();
            byte allele1Byte = snpallele1[ind];
            int n = this.alleleIndex[allele1Byte];
            alleleIndex2[n] = alleleIndex2[n] + 1;
            byte allele2Byte = snpallele2[ind];
            int n3 = this.alleleIndex[allele2Byte];
            alleleIndex2[n3] = alleleIndex2[n3] + 1;
        }
        double[] alleleIndexFreq1 = new double[4];
        double[] alleleIndexFreq2 = new double[4];
        int itr = 0;
        boolean issueResolved = false;
        while (!issueResolved) {
            int a;
            if (!strandForward) {
                int[] alleleIndex1Copy = new int[4];
                System.arraycopy(alleleIndex1, 0, alleleIndex1Copy, 0, 4);
                alleleIndex1[0] = alleleIndex1Copy[3];
                alleleIndex1[1] = alleleIndex1Copy[2];
                alleleIndex1[2] = alleleIndex1Copy[1];
                alleleIndex1[3] = alleleIndex1Copy[0];
            }
            int totalCalled1 = 0;
            int totalCalled2 = 0;
            for (a = 0; a < 4; ++a) {
                totalCalled1 += alleleIndex1[a];
                totalCalled2 += alleleIndex2[a];
            }
            for (a = 0; a < 4; ++a) {
                alleleIndexFreq1[a] = (double)alleleIndex1[a] / (double)totalCalled1;
                alleleIndexFreq2[a] = (double)alleleIndex2[a] / (double)totalCalled2;
            }
            int nrDifferentAllelesPresent = 0;
            for (int a2 = 0; a2 < 4; ++a2) {
                if (!(alleleIndexFreq1[a2] > 0.0) && !(alleleIndexFreq2[a2] > 0.0)) continue;
                ++nrDifferentAllelesPresent;
            }
            if (nrDifferentAllelesPresent > 2) {
                strandForward = !strandForward;
            } else {
                issueResolved = true;
            }
            if (++itr < 2 || issueResolved) continue;
            this.log.writeln(snpDataObject.getName() + "\tIncompatibleAlleles:Dataset=" + alleles + ",HapMap=" + allelesreference);
            issueResolved = true;
            return null;
        }
        takeComplement = !strandForward;
        boolean concordant = true;
        for (int a = 0; a < 4; ++a) {
            if (!(alleleIndexFreq1[a] > 0.0) || !(alleleIndexFreq2[a] > 0.0)) continue;
            if (alleleIndexFreq1[a] > 0.5 && alleleIndexFreq2[a] < 0.5) {
                concordant = false;
            }
            if (!(alleleIndexFreq1[a] < 0.5) || !(alleleIndexFreq2[a] > 0.5)) continue;
            concordant = false;
        }
        byte[] snpAlleles = snpDataObject.getAlleles();
        if (!(snpAlleles[0] + snpAlleles[1] != 149 && snpAlleles[0] + snpAlleles[1] != 138 || concordant)) {
            takeComplement = takeComplement == false;
            concordant = true;
        }
        if (!concordant) {
            String output = "";
            double maxAlleleFrequencyDifference = 0.0;
            for (int a = 0; a < 4; ++a) {
                int freqHapMap;
                if (!(alleleIndexFreq1[a] > 0.0) && !(alleleIndexFreq2[a] > 0.0)) continue;
                int freqData = (int)Math.round(alleleIndexFreq1[a] * 100.0);
                double absDiffFreq = Math.abs(freqData - (freqHapMap = (int)Math.round(alleleIndexFreq2[a] * 100.0)));
                if (absDiffFreq > maxAlleleFrequencyDifference) {
                    maxAlleleFrequencyDifference = absDiffFreq;
                }
                if (output.length() > 0) {
                    output = output + " / ";
                }
                output = output + this.alleleNames[a] + ": " + freqData + "%, " + freqHapMap + "%";
            }
            if (maxAlleleFrequencyDifference > 25.0) {
                this.log.writeln(snpDataObject.getName() + "\t allele frequencies differ too much with reference: " + output);
                return null;
            }
        }
        return takeComplement;
    }

    private boolean[] testLDStructure(SNP[] referenceSNPObjs, SNP[] datasetSNPObjs, boolean[] takeComplement) throws IOException {
        ProgressBar pb = new ProgressBar(datasetSNPObjs.length);
        boolean[] output = new boolean[datasetSNPObjs.length];
        byte[] complementAllele = new byte[256];
        complementAllele[0] = 0;
        complementAllele[84] = 65;
        complementAllele[65] = 84;
        complementAllele[48] = 48;
        complementAllele[67] = 71;
        complementAllele[71] = 67;
        int numSNPs = datasetSNPObjs.length;
        int passingLDQC = 0;
        for (int s = 0; s < numSNPs; ++s) {
            String rsName = datasetSNPObjs[s].getName();
            SNP datasetSNP1 = datasetSNPObjs[s];
            SNP referenceSNP1 = referenceSNPObjs[s];
            int nrSNPsLDAssessed = 0;
            int nrSNPsLDAssessedPos = 0;
            int nrSNPsLDAssessedNeg = 0;
            String nrSNPsLDAssessedNegLog = "";
            for (int s2 = s - 50; s2 < s + 50; ++s2) {
                int a;
                if (s2 < 0 || s2 >= numSNPs || s2 == s) continue;
                SNP datasetSNP2 = datasetSNPObjs[s2];
                SNP referenceSNP2 = referenceSNPObjs[s2];
                String rsName2 = datasetSNP2.getName();
                byte[] snp2Alleles = referenceSNP2.getAlleles();
                if (snp2Alleles[0] + snp2Alleles[1] == 149 || snp2Alleles[0] + snp2Alleles[1] == 138) continue;
                double rSquared = this.ldcalcdataset.getRSquared(datasetSNP1, datasetSNP2, this.dataGenotypeDataset, 4, 1, false);
                double rSquaredHapMap = this.ldcalchapmap.getRSquared(referenceSNP1, referenceSNP2, this.referenceGenotypeDataset, 4, 1, false);
                if (!(rSquared > 0.1) || !(rSquaredHapMap > 0.1)) continue;
                double[] h = new double[]{this.ldcalcdataset.h11, this.ldcalcdataset.h21, this.ldcalcdataset.h12, this.ldcalcdataset.h22};
                double[] hHapMap = new double[]{this.ldcalchapmap.h11, this.ldcalchapmap.h21, this.ldcalchapmap.h12, this.ldcalchapmap.h22};
                byte[][] hAlleles = new byte[4][2];
                byte[] snpDataAlleles1 = datasetSNP1.getAlleles();
                byte[] snpDataAlleles2 = datasetSNP2.getAlleles();
                hAlleles[0][0] = snpDataAlleles1[0];
                hAlleles[1][0] = snpDataAlleles1[0];
                hAlleles[2][0] = snpDataAlleles1[1];
                hAlleles[3][0] = snpDataAlleles1[1];
                hAlleles[0][1] = snpDataAlleles2[0];
                hAlleles[1][1] = snpDataAlleles2[1];
                hAlleles[2][1] = snpDataAlleles2[0];
                hAlleles[3][1] = snpDataAlleles2[1];
                if (takeComplement[s]) {
                    for (a = 0; a < 4; ++a) {
                        hAlleles[a][0] = complementAllele[hAlleles[a][0]];
                    }
                }
                if (takeComplement[s2]) {
                    for (a = 0; a < 4; ++a) {
                        hAlleles[a][1] = complementAllele[hAlleles[a][1]];
                    }
                }
                byte[][] hAllelesHapMap = new byte[4][2];
                byte[] snpHapMapAlleles1 = referenceSNP1.getAlleles();
                byte[] snpHapMapAlleles2 = referenceSNP2.getAlleles();
                hAllelesHapMap[0][0] = snpHapMapAlleles1[0];
                hAllelesHapMap[1][0] = snpHapMapAlleles1[0];
                hAllelesHapMap[2][0] = snpHapMapAlleles1[1];
                hAllelesHapMap[3][0] = snpHapMapAlleles1[1];
                hAllelesHapMap[0][1] = snpHapMapAlleles2[0];
                hAllelesHapMap[1][1] = snpHapMapAlleles2[1];
                hAllelesHapMap[2][1] = snpHapMapAlleles2[0];
                hAllelesHapMap[3][1] = snpHapMapAlleles2[1];
                double[] xVals = new double[4];
                double[] yVals = new double[4];
                int itr = 0;
                for (int a2 = 0; a2 < 4; ++a2) {
                    for (int b = 0; b < 4; ++b) {
                        if (hAlleles[a2][0] != hAllelesHapMap[b][0] || hAlleles[a2][1] != hAllelesHapMap[b][1]) continue;
                        xVals[itr] = h[a2];
                        yVals[itr] = hHapMap[b];
                        ++itr;
                    }
                }
                double correlation = ArrayMath.correlation((double[])xVals, (double[])yVals);
                ++nrSNPsLDAssessed;
                if (correlation < 0.0) {
                    ++nrSNPsLDAssessedNeg;
                    nrSNPsLDAssessedNegLog = nrSNPsLDAssessedNegLog + "\t" + rsName2;
                }
                if (!(correlation > 0.0)) continue;
                ++nrSNPsLDAssessedPos;
            }
            if (nrSNPsLDAssessedNeg > nrSNPsLDAssessedPos) {
                output[s] = false;
                this.log.writeln(rsName + "\tFlankingSNPsLDPatternsDifferent.NrAssessed:" + nrSNPsLDAssessed + ",Pos:" + nrSNPsLDAssessedPos + ",Neg:" + nrSNPsLDAssessedNeg + ",NegSNPs:" + nrSNPsLDAssessedNegLog);
            } else {
                ++passingLDQC;
                output[s] = true;
            }
            pb.iterate();
        }
        pb.close();
        System.out.println(passingLDQC + " out of " + datasetSNPObjs.length + " snps pass LD QC");
        return output;
    }

    private void writePedMapDat(String output, int chr, SNP[] datasetSNPObjs, boolean[] takeComplement, boolean[] snpsPassingQC) throws IOException {
        int i;
        if (datasetSNPObjs.length == 0) {
            System.out.println("No SNPs for chr " + chr);
            return;
        }
        byte[] complementAllele = new byte[256];
        complementAllele[0] = 0;
        complementAllele[84] = 65;
        complementAllele[65] = 84;
        complementAllele[48] = 48;
        complementAllele[67] = 71;
        complementAllele[71] = 67;
        int numbatches = 0;
        HashMap<String, Integer> batchtofile = new HashMap<String, Integer>();
        String[] batchnames = null;
        if (this.uniquebatches != null) {
            numbatches = this.uniquebatches.size();
            batchnames = new String[numbatches];
            this.uniquebatches.toArray(batchnames);
            for (int i2 = 0; i2 < batchnames.length; ++i2) {
                batchtofile.put(batchnames[i2], i2);
                System.out.println(i2 + "\t" + batchnames[i2]);
            }
        } else {
            numbatches = 1;
        }
        TextFile[] batchpedfiles = new TextFile[numbatches];
        if (this.uniquebatches != null) {
            for (int i3 = 0; i3 < batchpedfiles.length; ++i3) {
                String batchname = batchnames[i3];
                batchpedfiles[i3] = new TextFile(output + "/chr" + chr + "-" + batchname + ".ped", true);
            }
        } else {
            batchpedfiles[0] = new TextFile(output + "/chr" + chr + ".ped", true);
        }
        String[] individuals = this.dataGenotypeDataset.getIndividuals();
        for (i = 0; i < individuals.length; ++i) {
            Integer filehandle;
            String individual = individuals[i];
            if (this.uniquebatches != null) {
                String batch = this.sampleInBatch.get(individual);
                if (batch == null) {
                    System.out.println(individual + "\t not included in any batch");
                    continue;
                }
                filehandle = (Integer)batchtofile.get(batch);
                if (filehandle == null) {
                    System.out.println(batch + "\t has no handle?");
                    continue;
                }
            } else {
                filehandle = 0;
            }
            StringBuilder individualOutputString = new StringBuilder();
            String affectionStatus = "-9";
            if (this.dataGenotypeDataset.getIsCase()[i] == null) {
                affectionStatus = "-9";
            } else if (this.dataGenotypeDataset.getIsCase()[i].booleanValue()) {
                affectionStatus = "2";
            } else if (!this.dataGenotypeDataset.getIsCase()[i].booleanValue()) {
                affectionStatus = "1";
            }
            String sex = "-9";
            if (this.dataGenotypeDataset.getIsFemale()[i] == null) {
                sex = "-9";
            } else if (this.dataGenotypeDataset.getIsFemale()[i].booleanValue()) {
                sex = "2";
            } else if (!this.dataGenotypeDataset.getIsFemale()[i].booleanValue()) {
                sex = "1";
            }
            if (individual.contains(" ")) {
                individual = individual.replaceAll(" ", "-");
            }
            if (this.familyData == null) {
                individualOutputString.append("1 ").append(individual).append(" 0 0 ").append(sex).append(" ").append(affectionStatus);
            }
            for (int snp = 0; snp < datasetSNPObjs.length; ++snp) {
                if (!snpsPassingQC[snp]) continue;
                byte[] content = new byte[4];
                SNP snpDataObject = datasetSNPObjs[snp];
                content[0] = 32;
                byte[] snpAlleles1 = snpDataObject.getAllele1();
                byte[] snpAlleles2 = snpDataObject.getAllele2();
                int value1 = snpAlleles1[i];
                int value2 = snpAlleles2[i];
                if (value1 == 0) {
                    value1 = 48;
                }
                if (value2 == 0) {
                    value2 = 48;
                }
                if (takeComplement[snp]) {
                    value1 = complementAllele[value1];
                    value2 = complementAllele[value2];
                }
                content[1] = value1;
                content[2] = 32;
                content[3] = value2;
                individualOutputString.append(new String(content));
            }
            batchpedfiles[filehandle].writeln(individualOutputString.toString());
        }
        for (i = 0; i < batchpedfiles.length; ++i) {
            batchpedfiles[i].close();
        }
        TextFile mapfile = new TextFile(output + "/chr" + chr + ".map", true);
        TextFile datfile = new TextFile(output + "/chr" + chr + ".dat", true);
        datfile.writeln("A Status");
        for (int s = 0; s < datasetSNPObjs.length; ++s) {
            if (!snpsPassingQC[s]) continue;
            SNP datasetSNP = datasetSNPObjs[s];
            String rsName = datasetSNP.getName();
            Integer snpID = datasetSNP.getId();
            byte snpchr = datasetSNP.getChr();
            int snpchrpos = datasetSNP.getChrPos();
            mapfile.writeln(chr + "\t" + rsName + "\t0\t" + snpchrpos);
            datfile.writeln("M " + rsName);
        }
        datfile.close();
        mapfile.close();
        ArrayList<SortableSNP> sortedSNPs = new ArrayList<SortableSNP>();
        for (int s = 0; s < datasetSNPObjs.length; ++s) {
            if (!snpsPassingQC[s]) continue;
            SNP datasetSNP = datasetSNPObjs[s];
            sortedSNPs.add(new SortableSNP(datasetSNP.getName(), s, datasetSNP.getChr(), datasetSNP.getChrPos(), SortableSNP.SORTBY.CHRPOS));
        }
        TextFile bglfile = new TextFile(output + "/chr" + chr + ".markersbeagleformat", true);
        for (int s = 0; s < sortedSNPs.size(); ++s) {
            SortableSNP sortedSNP = (SortableSNP)sortedSNPs.get(s);
            String rsName = sortedSNP.name;
            int pos = sortedSNP.chrpos;
            String allelesHapMap = this.referenceAlleles.get(rsName);
            if (allelesHapMap == null) continue;
            bglfile.writeln(rsName + " " + pos + " " + allelesHapMap.substring(0, 1) + " " + allelesHapMap.substring(1, 2));
        }
        bglfile.close();
    }

    private void loadBatches(String batches) throws IOException {
        TextFile tf = new TextFile(batches, false);
        String[] elems = tf.readLineElemsReturnReference(TextFile.tab);
        this.uniquebatches = new HashSet();
        this.sampleInBatch = new HashMap();
        while (elems != null) {
            this.uniquebatches.add(elems[0]);
            this.sampleInBatch.put(elems[1], elems[0]);
            elems = tf.readLineElemsReturnReference(TextFile.tab);
        }
        tf.close();
        System.out.println("Loaded " + this.uniquebatches.size() + " batches," + this.sampleInBatch.size() + " samples");
    }

    private void loadExcludeSNPs(String excludesnps) throws IOException {
        TextFile tf = new TextFile(excludesnps, false);
        ArrayList<String> snps = tf.readAsArrayList();
        this.snpsExcluded.addAll(snps);
        tf.close();
    }
}

