/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper.converters;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import umcg.genetica.console.ProgressBar;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.WGAFileMatrixGenotype;

public class PedAndMapToTriTyper {
    public void importPEDFile(String[] mapFile, String mapFileDelimiter, int mapFileChrColumn, int mapFileChrPosColumn, int mapFileSNPColumn, String[] pedFile, String pedFileDelimiter, String outputDir, String[] casesToInclude) throws IOException {
        int snp;
        int mf;
        File fileOutputDir;
        System.out.println("PED File importer v1.0");
        if (!outputDir.endsWith("/")) {
            outputDir = outputDir + "/";
        }
        if (!(fileOutputDir = new File(outputDir)).isDirectory()) {
            System.out.println("Critical Error!\nThe output directory you have provided does not exist!:\t" + fileOutputDir.getAbsolutePath());
            System.exit(-1);
        }
        if (!fileOutputDir.canWrite()) {
            System.out.println("Critical Error!\nCannot write to output directory:\t" + outputDir);
            System.exit(-1);
        }
        boolean ignoreFirstLinePEDFile = false;
        int genotypeColumnOffset = 6;
        if (mapFile == null) {
            ignoreFirstLinePEDFile = true;
            System.out.println("Assuming the SNPs that are present within the PED file(s) are described in the first line of the PED file:");
            HashMap<String, Integer> hashUniqueSNPs = new HashMap<String, Integer>();
            ArrayList<String> vecUniqueSNPs = new ArrayList<String>();
            System.out.println("\nProcessing first line of PED file(s):");
            mapFile = new String[pedFile.length];
            for (int pf = 0; pf < pedFile.length; ++pf) {
                mapFile[pf] = outputDir + "MAPFile.txt";
                TextFile in = new TextFile(pedFile[pf], false);
                String str2 = in.readLine();
                String[] data = str2.split(pedFileDelimiter);
                for (int c = 6; c < data.length; ++c) {
                    if (hashUniqueSNPs.containsKey(data[c])) continue;
                    hashUniqueSNPs.put(data[c], new Integer(vecUniqueSNPs.size()));
                    vecUniqueSNPs.add(data[c]);
                }
            }
            System.out.println("Number of unique SNPs parsed from file:\t" + vecUniqueSNPs.size());
            TextFile mapOut = new TextFile(outputDir + "MAPFile.txt", true);
            for (int s = 0; s < vecUniqueSNPs.size(); ++s) {
                mapOut.write((String)vecUniqueSNPs.get(s) + "\n");
            }
            mapOut.close();
            mapFileChrColumn = 0;
            mapFileChrPosColumn = 0;
            mapFileSNPColumn = 0;
            System.out.println("Please make sure you update SNPMappings.txt!!! This file is currently not correct, as no physical mapping information is available for each of the SNPs!");
        } else {
            for (int mf2 = 0; mf2 < mapFile.length; ++mf2) {
                if (!new File(mapFile[mf2]).canRead()) {
                    System.out.println("Critical Error!\nCannot read from file:\t" + mapFile[mf2]);
                    System.exit(-1);
                }
                if (new File(pedFile[mf2]).canRead()) continue;
                System.out.println("Critical Error!\nCannot read from file:\t" + pedFile[mf2]);
                System.exit(-1);
            }
            if (mapFile.length != pedFile.length) {
                System.out.println("Critical Error!\nThe number of entered map files and ped files is not identical!");
                System.exit(-1);
            }
        }
        HashMap<String, Integer> hashSNP = new HashMap<String, Integer>();
        ArrayList<String> vectorSNP = new ArrayList<String>();
        ArrayList<String> vectorSNPMappings = new ArrayList<String>();
        int[] mapFileNrSNPs = new int[mapFile.length];
        HashMap[] hashMapFileSNPIndex = new HashMap[mapFile.length];
        for (mf = 0; mf < mapFile.length; ++mf) {
            hashMapFileSNPIndex[mf] = new HashMap();
        }
        System.out.println("\nDetermining number of makers per .map file:");
        for (mf = 0; mf < mapFile.length; ++mf) {
            String str2;
            TextFile inSNP = new TextFile(mapFile[mf], false);
            while ((str2 = inSNP.readLine()) != null) {
                str2 = new String(str2.getBytes());
                String[] data = str2.split(mapFileDelimiter);
                if (str2.trim().length() <= 0) continue;
                hashSNP.put(data[mapFileSNPColumn], new Integer(vectorSNP.size()));
                hashMapFileSNPIndex[mf].put(mapFileNrSNPs[mf], vectorSNP.size());
                vectorSNP.add(data[mapFileSNPColumn]);
                int n = mf;
                mapFileNrSNPs[n] = mapFileNrSNPs[n] + 1;
                String snpMapping = data[mapFileChrColumn] + "\t" + data[mapFileChrPosColumn] + "\t" + data[mapFileSNPColumn];
                vectorSNPMappings.add(snpMapping);
            }
            System.out.println("Number of markers in map file '" + mapFile[mf] + "':\t" + mapFileNrSNPs[mf]);
            inSNP.close();
        }
        System.out.println("Number of markers:\t" + vectorSNP.size() + "\t" + hashSNP.size());
        int nrSNPs = vectorSNP.size();
        HashMap<String, Integer> hashInd = new HashMap<String, Integer>();
        ArrayList<String> vectorInd = new ArrayList<String>();
        System.out.println("\nProcessing individuals");
        TextFile out = new TextFile(outputDir + "PhenotypeInformation.txt", true);
        for (int pf = 0; pf < pedFile.length; ++pf) {
            System.out.println("Parsing: " + pedFile[pf]);
            TextFile in = new TextFile(pedFile[pf], false);
            String str2 = "";
            if (ignoreFirstLinePEDFile) {
                str2 = in.readLine();
            }
            Pattern p = Pattern.compile(pedFileDelimiter);
            Pattern idmatcher = Pattern.compile("^([a-zA-Z_0-9\\S]*)\\s([\\Sa-zA-Z_0-9]*)\\s([a-zA-Z_0-9\\S]*)\\s([a-zA-Z_0-9\\S]*)\\s(-{0,1}\\d*\\.{0,1}\\d+)\\s(-{0,1}\\d*\\.{0,1}\\d+)\\s");
            while ((str2 = in.readLine()) != null) {
                Matcher m = idmatcher.matcher(str2);
                if (m.find()) {
                    String group = m.group(0);
                    String famid = m.group(1);
                    String samid = m.group(2);
                    String fatid = m.group(3);
                    String momid = m.group(4);
                    String sexid = m.group(5);
                    String affid = m.group(6);
                    String individual = famid + "-" + samid;
                    String sex = "male";
                    if (sexid.equals("2")) {
                        sex = "female";
                    }
                    String affectionStatus = "unknown";
                    String include = "include";
                    if (affid.equals("0")) {
                        include = "include";
                    }
                    if (affid.equals("1")) {
                        affectionStatus = "control";
                        include = "include";
                    }
                    for (int c = 0; c < casesToInclude.length; ++c) {
                        if (!affid.equals(casesToInclude[c])) continue;
                        affectionStatus = "case";
                        include = "include";
                    }
                    if (hashInd.containsKey(individual)) continue;
                    out.write(individual + "\t" + affectionStatus + "\t" + include + "\t" + sex + "\n");
                    hashInd.put(individual, new Integer(vectorInd.size()));
                    vectorInd.add(individual);
                    continue;
                }
                System.out.println("Line does not match PED pattern: check the format in your file!");
                System.out.println(str2);
                System.exit(-1);
            }
            System.out.println("Number of total individuals parsed:\t" + vectorInd.size());
            in.close();
        }
        out.close();
        System.out.println("Number of unique individuals in all datasets:\t" + vectorInd.size());
        int numSamples = vectorInd.size();
        ProgressBar pb = new ProgressBar(vectorInd.size(), "Writing individuals to file: " + outputDir + "Individuals.txt");
        TextFile outInd = new TextFile(outputDir + "Individuals.txt", true);
        for (int ind = 0; ind < vectorInd.size(); ++ind) {
            outInd.write((String)vectorInd.get(ind) + "\n");
            pb.iterate();
        }
        pb.close();
        outInd.close();
        pb = new ProgressBar(vectorSNP.size(), "Writing marker definition to file: " + outputDir + "SNPs.txt");
        TextFile outSNP = new TextFile(outputDir + "SNPs.txt", true);
        for (snp = 0; snp < vectorSNP.size(); ++snp) {
            outSNP.write((String)vectorSNP.get(snp) + "\n");
            pb.iterate();
        }
        pb.close();
        outSNP.close();
        pb = new ProgressBar(vectorSNP.size(), "Writing marker mapping definition to file: " + outputDir + "SNPMappings.txt");
        outSNP = new TextFile(outputDir + "SNPMappings.txt", true);
        for (snp = 0; snp < vectorSNP.size(); ++snp) {
            outSNP.write((String)vectorSNPMappings.get(snp) + "\n");
            pb.iterate();
        }
        pb.close();
        outSNP.close();
        int nrSamples = vectorInd.size();
        WGAFileMatrixGenotype fileMatrixGenotype = new WGAFileMatrixGenotype(nrSNPs, nrSamples, new File(outputDir + "GenotypeMatrix.dat"), false);
        System.out.println("\nLoading genotype data from PED file and writing into TriTyper format:");
        for (int pf = 0; pf < pedFile.length; ++pf) {
            TextFile in = new TextFile(pedFile[pf], false);
            System.out.println();
            String str2 = "";
            if (ignoreFirstLinePEDFile) {
                str2 = in.readLine();
            }
            byte[] conversionAllele = new byte[]{0, 65, 67, 71, 84};
            boolean endOfFile = false;
            int individualCounterTotal = 0;
            int sampleBufferSize = 250;
            if (sampleBufferSize > vectorInd.size()) {
                sampleBufferSize = vectorInd.size();
            }
            pb = new ProgressBar(vectorInd.size(), "Parsing file:\t" + pedFile[pf]);
            while (!endOfFile) {
                int individualCounter = 0;
                byte[][] dataAllele1 = new byte[sampleBufferSize][mapFileNrSNPs[pf]];
                byte[][] dataAllele2 = new byte[sampleBufferSize][mapFileNrSNPs[pf]];
                for (int i = 0; i < sampleBufferSize; ++i) {
                    str2 = in.readLine();
                    if (str2 != null) {
                        String[] data = str2.split(pedFileDelimiter);
                        for (int snp2 = 0; snp2 < mapFileNrSNPs[pf]; ++snp2) {
                            byte allele1 = data[genotypeColumnOffset + snp2 * 2].getBytes()[0];
                            byte allele2 = data[genotypeColumnOffset + 1 + snp2 * 2].getBytes()[0];
                            if (allele1 == 48) {
                                allele1 = 0;
                            }
                            if (allele2 == 48) {
                                allele2 = 0;
                            }
                            if (allele1 == 73 || allele1 == 68) {
                                allele1 = 0;
                            }
                            if (allele2 == 73 || allele2 == 68) {
                                allele2 = 0;
                            }
                            if (allele1 == 78) {
                                allele1 = 0;
                            }
                            if (allele2 == 78) {
                                allele2 = 0;
                            }
                            if (allele1 != 0 && allele1 != 65 && allele1 != 67 && allele1 != 71 && allele1 != 84) {
                                allele1 = conversionAllele[Integer.parseInt(data[genotypeColumnOffset + snp2 * 2])];
                                allele2 = conversionAllele[Integer.parseInt(data[genotypeColumnOffset + 1 + snp2 * 2])];
                            }
                            dataAllele1[individualCounter][snp2] = allele1;
                            dataAllele2[individualCounter][snp2] = allele2;
                        }
                    } else {
                        endOfFile = true;
                        break;
                    }
                    ++individualCounter;
                }
                for (int snp3 = 0; snp3 < mapFileNrSNPs[pf]; ++snp3) {
                    byte[] allele1 = new byte[individualCounter];
                    byte[] allele2 = new byte[individualCounter];
                    for (int b = 0; b < individualCounter; ++b) {
                        allele1[b] = dataAllele1[b][snp3];
                        allele2[b] = dataAllele2[b][snp3];
                    }
                    int snpIndex = (Integer)hashMapFileSNPIndex[pf].get(snp3);
                    fileMatrixGenotype.setAllele1(snpIndex, individualCounterTotal, allele1);
                    fileMatrixGenotype.setAllele2(snpIndex, individualCounterTotal, allele2);
                }
                pb.set(individualCounterTotal += individualCounter);
            }
            in.close();
            pb.close();
        }
        fileMatrixGenotype.close();
        System.out.println("");
        System.out.println("Import of PED files has completed.\n----------------------------------\n|          Please note:          |\n----------------------------------\nYour TriTyper files have been placed in the folder: " + outputDir + "\n" + "Please check whether the PhenotypeInformation.txt file in this folder reflects the data for your samples.\n" + "Have a nice day.\n");
    }

    public void importPEDFile(String dataLocation, String mapdelimiter, int chrcol, int chrpos, int snpcol, String peddelimiter, String outputLocation, String[] casesToInclude) throws IOException {
        String[] pedFile = Gpio.getListOfFiles(dataLocation, "ped");
        String[] mapFile = Gpio.getListOfFiles(dataLocation, "map");
        boolean filesok = true;
        if (pedFile.length == 0) {
            System.out.println("Error!: Directory does not contain any PED files");
            filesok = false;
        }
        if (mapFile.length == 0) {
            System.out.println("Error!: Directory does not contain any MAP files");
            filesok = false;
        }
        if (!filesok) {
            System.exit(-1);
        } else {
            this.importPEDFile(mapFile, mapdelimiter, chrcol, chrpos, snpcol, pedFile, peddelimiter, outputLocation, casesToInclude);
        }
    }

    public void importPEDFile(String dataLocation, String outputLocation) throws IOException {
        String[] pedFile = Gpio.getListOfFiles(dataLocation, "ped");
        String[] mapFile = Gpio.getListOfFiles(dataLocation, "map");
        if (pedFile.length == 0) {
            String[] files;
            ArrayList<String> gzippedPed = new ArrayList<String>();
            for (String file : files = Gpio.getListOfFiles(dataLocation)) {
                if (Gpio.isDir(file) || !file.toLowerCase().endsWith(".ped.gz")) continue;
                gzippedPed.add(file);
            }
            pedFile = gzippedPed.toArray(new String[0]);
            if (mapFile.length == 0) {
                HashSet<String> gzippedMap = new HashSet<String>();
                for (String file : files) {
                    if (Gpio.isDir(file) || !file.toLowerCase().endsWith(".map.gz")) continue;
                    gzippedMap.add(file);
                }
                boolean matchedMaps = true;
                mapFile = new String[pedFile.length];
                for (int p = 0; p < pedFile.length; ++p) {
                    String fWithOutExtension = pedFile[p].toLowerCase().replace(".ped.gz", "");
                    String matchingMap = fWithOutExtension + ".map.gz";
                    boolean fileFound = false;
                    for (String map : gzippedMap) {
                        if (!map.toLowerCase().equals(matchingMap)) continue;
                        mapFile[p] = map;
                        fileFound = true;
                    }
                    if (fileFound) continue;
                    System.out.println("No map file found for PED file: " + pedFile[p]);
                    matchedMaps = false;
                }
                if (!matchedMaps) {
                    System.err.println("ERROR: could not match all PED files to MAP files.");
                    System.exit(-1);
                }
            }
        } else {
            boolean matchedMaps = true;
            String[] mapFiletmp = new String[pedFile.length];
            for (int p = 0; p < pedFile.length; ++p) {
                String fWithOutExtension = pedFile[p].toLowerCase().replace(".ped", "");
                String matchingMap = fWithOutExtension + ".map";
                boolean fileFound = false;
                for (String map : mapFile) {
                    if (!map.toLowerCase().equals(matchingMap)) continue;
                    mapFiletmp[p] = map;
                    fileFound = true;
                }
                if (fileFound) continue;
                System.out.println("No map file found for PED file: " + pedFile[p]);
                matchedMaps = false;
            }
            if (!matchedMaps) {
                System.err.println("ERROR: could not match all PED files to MAP files.");
                System.exit(-1);
            }
            mapFile = mapFiletmp;
        }
        boolean filesok = true;
        if (pedFile.length == 0) {
            System.out.println("Error!: Directory does not contain any PED files");
            filesok = false;
        }
        if (mapFile.length == 0) {
            System.out.println("Error!: Directory does not contain any MAP files");
            filesok = false;
        }
        if (!filesok) {
            System.exit(-1);
        } else {
            String[] casesToInclude = new String[]{"2"};
            String pedSplit = this.determineFileSplitter(pedFile[0]);
            String mapSplit = this.determineFileSplitter(mapFile[0]);
            if (pedSplit == null || mapSplit == null) {
                System.err.println("ERROR: could not split your ped or map file by whitespace");
                System.exit(-1);
            } else {
                if (!outputLocation.endsWith("/")) {
                    outputLocation = outputLocation + "/";
                }
                Gpio.createDir(outputLocation);
                this.importPEDFile(mapFile, mapSplit, 0, 3, 1, pedFile, pedSplit, outputLocation, casesToInclude);
            }
        }
    }

    private String determineFileSplitter(String file) throws IOException {
        return "\\s";
    }
}

