/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper.converters;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.WGAFileMatrixGenotype;
import umcg.genetica.io.trityper.WGAFileMatrixImputedDosage;

public class BeagleImputedToTriTyper {
    private HashMap<String, String> familyData;
    private boolean familyDataLoaded;
    private ArrayList<String> vArrayListInd;
    private HashMap<String, Integer> vhashInd;
    private ArrayList<String> arrayListInd;
    private ArrayList<String> arrayListSNP;
    private HashMap<String, Double> SNPR2;
    private HashMap<String, Integer> SNPR2Present;
    private ArrayList<String> arrayListSNPMappings;
    private HashMap<String, Integer> hashInd;
    private HashMap<String, Integer> hashSNP;

    private String[] getBatches(int numBatches) {
        String[] batches = new String[numBatches];
        String[] alphabet = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
        String firstletter = "a";
        int alphacounter = 0;
        int betacounter = 0;
        for (int i = 0; i < numBatches; ++i) {
            if (i % 26 == 0) {
                firstletter = alphabet[alphacounter];
                ++alphacounter;
                betacounter = 0;
            }
            batches[i] = firstletter + alphabet[betacounter];
            ++betacounter;
        }
        return batches;
    }

    public boolean importImputedDataWithDosageInformationBeagleBatches(String inputDir, String template, int numBatches, String outputDir, int chrStart, int chrEnd) throws IOException {
        String[] batchNames = this.getBatches(numBatches);
        int nrBatches = batchNames.length;
        int[] batchSampleIndex = new int[nrBatches + 1];
        int[] batchNrSamples = new int[nrBatches + 1];
        this.hashSNP = new HashMap();
        this.arrayListSNP = new ArrayList();
        this.arrayListSNPMappings = new ArrayList();
        this.arrayListInd = new ArrayList();
        this.hashInd = new HashMap();
        long nrSNPsAvailable = 0L;
        boolean allFilesAvailable = true;
        int filesnotfound = 0;
        for (int batch = 0; batch < nrBatches; ++batch) {
            batchSampleIndex[batch] = this.arrayListInd.size();
            boolean nrSamplesThisBatch = false;
            for (int chr = chrStart; chr <= chrEnd; ++chr) {
                String templatecopy = new String(template);
                templatecopy = templatecopy.replace("BATCH", batchNames[batch]);
                templatecopy = templatecopy.replace("CHROMOSOME", "" + chr);
                String fileName = inputDir + "/" + templatecopy + ".gprobs.gz";
                String r2FileName = inputDir + "/" + templatecopy + ".r2";
                if (!Gpio.canRead(fileName)) {
                    System.out.println("Cannot open file:\t" + fileName);
                    allFilesAvailable = false;
                    ++filesnotfound;
                }
                if (Gpio.canRead(r2FileName)) continue;
                System.out.println("Cannot open file:\t" + r2FileName);
                allFilesAvailable = false;
                ++filesnotfound;
            }
        }
        if (!allFilesAvailable) {
            System.out.println("Not all imputed dosage files are available!!! (" + filesnotfound + " out of " + nrBatches * 22 + "). Exiting...");
            return false;
        }
        boolean preprocessingCompleted = false;
        String snpfile = outputDir + "SNPs.txt";
        String indfile = outputDir + "Individuals.txt";
        if (Gpio.canRead(snpfile) && Gpio.canRead(indfile)) {
            preprocessingCompleted = true;
        }
        if (preprocessingCompleted) {
            System.out.println("Preprocessing has already been completed, not necessary to conduct preprocessing again (SNPs.txt and Individuals.txt already exist):");
            System.out.println("Parsing SNPs.txt:");
            TextFile in = new TextFile(snpfile, false);
            String str = null;
            while ((str = in.readLine()) != null) {
                String snp = str.trim();
                this.hashSNP.put(snp, this.arrayListSNP.size());
                this.arrayListSNP.add(snp);
                ++nrSNPsAvailable;
            }
            in.close();
            for (int batch = 0; batch < nrBatches; ++batch) {
                batchSampleIndex[batch] = this.arrayListInd.size();
                System.out.println("BatchSampleIndex:\t" + batch + "\t" + batchSampleIndex[batch]);
                int nrSamplesThisBatch = 0;
                for (int chr = chrStart; chr <= chrEnd; ++chr) {
                    String templatecopy = new String(template);
                    templatecopy = templatecopy.replace("BATCH", batchNames[batch]);
                    templatecopy = templatecopy.replace("CHROMOSOME", "" + chr);
                    String fileName = inputDir + "/" + templatecopy + ".gprobs.gz";
                    String r2FileName = inputDir + "/" + templatecopy + ".r2";
                    System.out.print("Processing file:\t" + fileName);
                    in = new TextFile(fileName, false);
                    str = in.readLine();
                    String[] data = str.split(" ");
                    for (int c = 3; c < data.length; ++c) {
                        if (this.hashInd.containsKey(data[c])) continue;
                        this.hashInd.put(data[c], this.arrayListInd.size());
                        this.arrayListInd.add(data[c]);
                        ++nrSamplesThisBatch;
                    }
                    System.out.println("Number of individuals parsed so far:\t" + this.arrayListInd.size());
                    in.close();
                }
                System.out.println("Number of unique samples for batch:\t" + batch + "\t" + nrSamplesThisBatch);
                batchNrSamples[batch] = nrSamplesThisBatch;
            }
        } else {
            this.SNPR2 = new HashMap();
            this.SNPR2Present = new HashMap();
            for (int batch = 0; batch < nrBatches; ++batch) {
                batchSampleIndex[batch] = this.arrayListInd.size();
                int nrSamplesThisBatch = 0;
                for (int chr = chrStart; chr <= chrEnd; ++chr) {
                    String templatecopy = new String(template);
                    templatecopy = templatecopy.replace("BATCH", batchNames[batch]);
                    templatecopy = templatecopy.replace("CHROMOSOME", "" + chr);
                    String fileName = inputDir + "/" + templatecopy + ".gprobs.gz";
                    String r2FileName = inputDir + "/" + templatecopy + ".r2";
                    System.out.print("Processing file:\t" + fileName);
                    TextFile r2reader = new TextFile(r2FileName, false);
                    String ln = "";
                    while ((ln = r2reader.readLine()) != null) {
                        String[] elems = ln.split("\t");
                        if (elems.length != 2) continue;
                        try {
                            Double r2Val = Double.parseDouble(elems[1]);
                            Double r2Prev = this.SNPR2.get(elems[0]);
                            if (r2Prev == null) {
                                this.SNPR2.put(elems[0], r2Val);
                                this.SNPR2Present.put(elems[0], 1);
                                continue;
                            }
                            this.SNPR2.put(elems[0], r2Prev + r2Val);
                            this.SNPR2Present.put(elems[0], this.SNPR2Present.get(elems[0]) + 1);
                        }
                        catch (NumberFormatException e) {
                            if (!elems[1].toLowerCase().equals("nan")) continue;
                        }
                    }
                    r2reader.close();
                    TextFile in = new TextFile(fileName, false);
                    String str = in.readLine();
                    String[] data = str.split(" ");
                    for (int c = 3; c < data.length; ++c) {
                        if (this.hashInd.containsKey(data[c])) continue;
                        this.hashInd.put(data[c], this.arrayListInd.size());
                        this.arrayListInd.add(data[c]);
                        ++nrSamplesThisBatch;
                    }
                    int line = 0;
                    int prevLine = -1;
                    while ((str = in.readLine()) != null) {
                        data = str.split(" ");
                        String snp = new String(data[0].getBytes());
                        if (!this.hashSNP.containsKey(snp)) {
                            String snpPos = "1";
                            String snpMapping = chr + "\t" + snpPos + "\t" + snp;
                            this.arrayListSNPMappings.add(snpMapping);
                            this.hashSNP.put(snp, this.arrayListSNP.size());
                            this.arrayListSNP.add(snp);
                            ++nrSNPsAvailable;
                        }
                        if (line % 10000 == 0 && line > prevLine) {
                            System.out.print(".");
                            prevLine = line;
                        }
                        ++line;
                    }
                    System.out.println("");
                    System.out.println("Number of SNPs parsed so far:\t" + nrSNPsAvailable);
                    System.out.println("Number of individuals parsed so far:\t" + this.arrayListInd.size());
                    System.out.println("");
                    in.close();
                }
                System.out.println("Number of unique samples for batch:\t" + batch + "\t" + nrSamplesThisBatch);
                batchNrSamples[batch] = nrSamplesThisBatch;
            }
        }
        this.writeIndividuals(outputDir);
        this.writeSNPs(outputDir);
        int nrSNPs = (int)nrSNPsAvailable;
        int nrSamples = this.arrayListInd.size();
        WGAFileMatrixGenotype fileMatrixGenotype = new WGAFileMatrixGenotype(nrSNPs, nrSamples, new File(outputDir + "GenotypeMatrix.dat"), false);
        WGAFileMatrixImputedDosage matrixImputedDosage = new WGAFileMatrixImputedDosage(nrSNPs, nrSamples, new File(outputDir + "/ImputedDosageMatrix.dat"), false);
        for (int chr = chrEnd; chr >= chrStart; --chr) {
            TextFile[] in = new TextFile[nrBatches];
            for (int batch = 0; batch < nrBatches; ++batch) {
                String templatecopy = new String(template);
                templatecopy = templatecopy.replace("BATCH", batchNames[batch]);
                templatecopy = templatecopy.replace("CHROMOSOME", "" + chr);
                String fileName = inputDir + "/" + templatecopy + ".gprobs.gz";
                System.out.println("Processing file:\t" + fileName);
                in[batch] = new TextFile(fileName, false);
                in[batch].readLine();
            }
            System.out.print("Progress:");
            int line = 0;
            while (true) {
                int batch;
                String[] str = new String[nrBatches];
                String[] snp = new String[nrBatches];
                byte[] alleles = new byte[2];
                for (batch = 0; batch < nrBatches; ++batch) {
                    str[batch] = in[batch].readLine();
                }
                if (str[0] == null) break;
                for (batch = 0; batch < nrBatches; ++batch) {
                    while (str[batch].contains("  ")) {
                        str[batch] = str[batch].replace("  ", " ");
                    }
                    String[] data = str[batch].split(" ");
                    snp[batch] = new String(data[0].getBytes());
                    alleles[0] = data[1].getBytes()[0];
                    alleles[1] = data[2].getBytes()[0];
                }
                String firstSNP = snp[0];
                for (int batch2 = 0; batch2 < nrBatches; ++batch2) {
                    if (firstSNP.equals(snp[batch2])) continue;
                    System.out.println("Error! Format of different batches are not identical, different SNP names are found for the same readline!:\t" + firstSNP + "\t" + snp[batch2]);
                    System.exit(-1);
                }
                Integer snpIndex = this.hashSNP.get(firstSNP);
                byte[] allele1 = new byte[nrSamples];
                byte[] allele2 = new byte[nrSamples];
                byte[] dosage = new byte[nrSamples];
                for (int batch3 = 0; batch3 < nrBatches; ++batch3) {
                    String[] data = str[batch3].split(" ");
                    for (int sample = 0; sample < batchNrSamples[batch3]; ++sample) {
                        int sampleIndex = batchSampleIndex[batch3] + sample;
                        double dosageValue = Double.parseDouble(data[sample * 3 + 4]) * 1.0 + Double.parseDouble(data[sample * 3 + 5]) * 2.0;
                        int dosageInt = (int)Math.round(dosageValue * 100.0);
                        byte dosageByte = (byte)(-128 + dosageInt);
                        if (dosageInt < 0 || dosageInt > 200) {
                            System.out.println("Warning, incorrect dosage!:\t" + dosageInt + "\t" + snpIndex + "\t" + data[sample * 3 + 3] + "-" + data[sample * 3 + 4] + "-" + data[sample * 3 + 5]);
                        } else {
                            dosage[sampleIndex] = dosageByte;
                        }
                        if (dosageValue < 0.5) {
                            allele1[sampleIndex] = alleles[0];
                            allele2[sampleIndex] = alleles[0];
                            continue;
                        }
                        if (dosageValue > 1.5) {
                            allele1[sampleIndex] = alleles[1];
                            allele2[sampleIndex] = alleles[1];
                            continue;
                        }
                        allele1[sampleIndex] = alleles[0];
                        allele2[sampleIndex] = alleles[1];
                    }
                }
                fileMatrixGenotype.setAllele1((int)snpIndex, 0, allele1);
                fileMatrixGenotype.setAllele2((int)snpIndex, 0, allele2);
                matrixImputedDosage.setDosage((int)snpIndex, 0, dosage);
                if (line % 10000 == 0) {
                    System.out.print(".");
                }
                ++line;
            }
            System.out.println(" Completed.");
            for (int batch = 0; batch < nrBatches; ++batch) {
                in[batch].close();
            }
        }
        fileMatrixGenotype.close();
        matrixImputedDosage.close();
        return true;
    }

    public void importImputedDataWithDosageInformationBeagle(String inputLocation, String template, String extension, String outputDir) throws IOException {
        boolean allFilesAvailable = true;
        int filesnotfound = 0;
        int chrStart = 1;
        int chrEnd = 22;
        for (int chr = chrStart; chr <= chrEnd; ++chr) {
            String templatecopy = new String(template);
            templatecopy = templatecopy.replace("BATCH", "aa");
            templatecopy = templatecopy.replace("CHROMOSOME", "" + chr);
            String fileName = inputLocation + "/" + templatecopy + "." + extension;
            if (Gpio.canRead(fileName)) continue;
            System.out.println("Cannot open file:\t" + fileName);
            allFilesAvailable = false;
            ++filesnotfound;
        }
        if (!allFilesAvailable) {
            System.out.println("Not all imputed dosage files are available!!! (" + filesnotfound + " out of 22 ). Exiting...");
            System.exit(-1);
        }
        this.hashSNP = new HashMap();
        this.arrayListSNP = new ArrayList();
        this.arrayListSNPMappings = new ArrayList();
        this.arrayListInd = new ArrayList();
        this.hashInd = new HashMap();
        long nrSNPsAvailable = 0L;
        for (int chr = chrStart; chr <= chrEnd; ++chr) {
            String[] data;
            String str;
            String templatecopy = new String(template);
            templatecopy = templatecopy.replace("BATCH", "aa");
            templatecopy = templatecopy.replace("CHROMOSOME", "" + chr);
            String fileName = inputLocation + "/" + templatecopy + "." + extension;
            System.out.print("Processing file:\t" + fileName);
            TextFile in = new TextFile(fileName, false);
            if (!this.familyDataLoaded) {
                str = in.readLine();
                data = str.split(" ");
                for (int c = 3; c < data.length; ++c) {
                    if (this.hashInd.containsKey(data[c])) continue;
                    this.hashInd.put(data[c], this.arrayListInd.size());
                    this.arrayListInd.add(data[c]);
                    System.out.println("Found new individual:" + data[c]);
                }
            } else {
                this.hashInd = this.vhashInd;
                this.arrayListInd = this.vArrayListInd;
            }
            int prevLine = -1;
            int line = 0;
            int numValues = 0;
            while ((str = in.readLine()) != null) {
                while (str.contains("  ")) {
                    str = str.replace("  ", " ");
                }
                data = str.split(" ");
                numValues = (data.length - 3) / 3;
                String snp = new String(data[0].getBytes());
                if (!this.hashSNP.containsKey(snp)) {
                    String snpPos = "1";
                    String snpMapping = chr + "\t" + snpPos + "\t" + snp;
                    this.arrayListSNPMappings.add(snpMapping);
                    this.hashSNP.put(snp, this.arrayListSNP.size());
                    this.arrayListSNP.add(snp);
                    ++nrSNPsAvailable;
                }
                if (line % 10000 == 0 && line > prevLine) {
                    System.out.print(".");
                    prevLine = line;
                }
                ++line;
            }
            System.out.println("");
            System.out.println("Number of SNPs parsed so far:\t" + nrSNPsAvailable + " for " + numValues + " samples");
            System.out.println("");
            in.close();
        }
        System.out.println("Number of individuals parsed:\t" + this.arrayListInd.size());
        this.writeIndividuals(outputDir);
        this.writeSNPs(outputDir);
        int nrSNPs = (int)nrSNPsAvailable;
        int nrSamples = this.arrayListInd.size();
        WGAFileMatrixGenotype fileMatrixGenotype = new WGAFileMatrixGenotype(nrSNPs, nrSamples, new File(outputDir + "GenotypeMatrix.dat"), false);
        WGAFileMatrixImputedDosage matrixImputedDosage = new WGAFileMatrixImputedDosage(nrSNPs, nrSamples, new File(outputDir + "/ImputedDosageMatrix.dat"), false);
        for (int chr = chrStart; chr <= chrEnd; ++chr) {
            String templatecopy = new String(template);
            templatecopy = templatecopy.replace("BATCH", "aa");
            templatecopy = templatecopy.replace("CHROMOSOME", "" + chr);
            String fileName = inputLocation + "/" + templatecopy + "." + extension;
            System.out.print("Processing file:\t" + fileName);
            TextFile in = new TextFile(fileName, false);
            String str = in.readLine();
            int prevLine = -1;
            int line = 0;
            while ((str = in.readLine()) != null) {
                while (str.contains("  ")) {
                    str = str.replace("  ", " ");
                }
                String[] data = str.split(" ");
                String snp = new String(data[0].getBytes());
                int snpIndex = this.hashSNP.get(snp);
                byte[] allele1 = new byte[nrSamples];
                byte[] allele2 = new byte[nrSamples];
                byte[] alleles = new byte[]{data[1].getBytes()[0], data[2].getBytes()[0]};
                byte[] dosage = new byte[nrSamples];
                for (int sample = 0; sample < nrSamples; ++sample) {
                    double dosageValue = Double.parseDouble(data[sample * 3 + 4]) * 1.0 + Double.parseDouble(data[sample * 3 + 5]) * 2.0;
                    int dosageInt = (int)Math.round(dosageValue * 100.0);
                    byte dosageByte = (byte)(-128 + dosageInt);
                    if (dosageInt < 0 || dosageInt > 200) {
                        System.out.println("Warning, incorrect dosage!:\t" + dosageInt + "\t" + snpIndex + "\t" + data[sample * 3 + 3] + "-" + data[sample * 3 + 4] + "-" + data[sample * 3 + 5]);
                    } else {
                        dosage[sample] = dosageByte;
                    }
                    if (dosageValue < 0.5) {
                        allele1[sample] = alleles[0];
                        allele2[sample] = alleles[0];
                    } else if (dosageValue > 1.5) {
                        allele1[sample] = alleles[1];
                        allele2[sample] = alleles[1];
                    } else {
                        allele1[sample] = alleles[0];
                        allele2[sample] = alleles[1];
                    }
                    fileMatrixGenotype.setAllele1(snpIndex, sample, allele1);
                    fileMatrixGenotype.setAllele2(snpIndex, sample, allele2);
                    matrixImputedDosage.setDosage(snpIndex, sample, dosage);
                }
                if (line % 10000 == 0 && line > prevLine) {
                    System.out.print(".");
                    prevLine = line;
                }
                ++line;
            }
            in.close();
            System.out.println("");
        }
        fileMatrixGenotype.close();
        matrixImputedDosage.close();
    }

    public void loadFamFile(String file) {
        this.vArrayListInd = new ArrayList();
        this.vhashInd = new HashMap();
        System.out.println("Loading FAM file:\t" + file);
        try {
            TextFile in = new TextFile(file, false);
            String line = "";
            this.familyData = new HashMap();
            while ((line = in.readLine()) != null) {
                String[] elems = line.split(" ");
                if (elems.length < 6) continue;
                String sample = elems[1];
                String fid = elems[0];
                String pid = elems[2];
                String mid = elems[3];
                String sex = elems[4];
                String phe = elems[5];
                sex = sex.equals("1") ? "male" : (sex.equals("2") ? "female" : "unknown");
                phe = phe.equals("1") ? "control" : (phe.equals("2") ? "case" : "unknown");
                this.familyData.put(sample, sample + "\t" + phe + "\tinclude\t" + sex + "\t" + fid + "\t" + pid + "\t" + mid + "\n");
                if (this.vhashInd.containsKey(sample)) continue;
                this.vhashInd.put(sample, this.vArrayListInd.size());
                this.vArrayListInd.add(sample);
            }
            in.close();
            this.familyDataLoaded = true;
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private void writeSNPs(String outputDir) throws IOException {
        int snp;
        System.out.println("\nWriting SNP mappings to file:");
        TextFile outSNP = new TextFile(outputDir + "SNPMappings.txt", true);
        for (snp = 0; snp < this.arrayListSNPMappings.size(); ++snp) {
            outSNP.write(this.arrayListSNPMappings.get(snp) + "\n");
            if (snp % 2000 != 1999) continue;
            System.out.print(".");
        }
        System.out.println("");
        outSNP.close();
        outSNP = new TextFile(outputDir + "SNPR2Scores.txt", true);
        for (snp = 0; snp < this.arrayListSNP.size(); ++snp) {
            String rsName = this.arrayListSNP.get(snp);
            Double r2val = this.SNPR2.get(rsName);
            r2val = r2val == null ? Double.valueOf(Double.NaN) : Double.valueOf(r2val / (double)this.SNPR2Present.get(rsName).intValue());
            outSNP.write(rsName + "\t" + r2val + "\t" + this.SNPR2Present.get(rsName) + "\n");
            if (snp % 2000 != 1999) continue;
            System.out.print(".");
        }
        System.out.println("");
        outSNP.close();
        System.out.println("\nWriting marker definition to file:");
        outSNP = new TextFile(outputDir + "SNPs.txt", true);
        for (snp = 0; snp < this.arrayListSNP.size(); ++snp) {
            outSNP.write(this.arrayListSNP.get(snp) + "\n");
            if (snp % 2000 != 1999) continue;
            System.out.print(".");
        }
        System.out.println("");
        outSNP.close();
    }

    private void writeIndividuals(String outputDir) throws IOException {
        System.out.println("\nWriting individuals to file:");
        TextFile outInd = new TextFile(outputDir + "Individuals.txt", true);
        TextFile outPhe = new TextFile(outputDir + "PhenotypeInformation.txt", true);
        for (int ind = 0; ind < this.arrayListInd.size(); ++ind) {
            outInd.write(this.arrayListInd.get(ind) + "\n");
            if (this.familyDataLoaded) {
                if (this.familyData.get(this.arrayListInd.get(ind)) != null) {
                    outPhe.write(this.familyData.get(this.arrayListInd.get(ind)));
                } else {
                    outPhe.write(this.arrayListInd.get(ind) + "\tcontrol\tinclude\tunknown" + "\n");
                }
            } else {
                outPhe.write(this.arrayListInd.get(ind) + "\tcontrol\tinclude\tfemale" + "\n");
            }
            if (ind % 5 != 4) continue;
            System.out.print(".");
        }
        System.out.println("");
        outInd.close();
        outPhe.close();
    }
}

