/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper.bin;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import umcg.genetica.io.trityper.bin.BinaryResultSNP;

public class BinaryResultSNPSummary {
    private int counter = 0;
    private DataOutputStream out;
    private DataInputStream in;
    private int maxNrSamples;
    public static boolean W = true;
    public static boolean R = false;

    public BinaryResultSNPSummary(String filename, boolean W) throws IOException {
        if (W) {
            this.out = new DataOutputStream(new FileOutputStream(new File(filename + ".SNPSummary.dat")));
        } else {
            this.in = new DataInputStream(new FileInputStream(new File(filename)));
        }
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.flush();
            this.out.close();
        }
        if (this.in != null) {
            this.in.close();
        }
    }

    public void write(String snpname, byte snpchr, Integer snpchrpos, double HWE2, double MAF, double CR, byte[] alleles, byte minorallele, byte alleleassessed, Integer numsamples, long gzipIndex) throws IOException {
        this.out.writeInt(this.counter);
        this.out.writeUTF(snpname);
        this.out.writeByte(snpchr);
        this.out.writeInt(snpchrpos);
        this.out.writeDouble(HWE2);
        this.out.writeDouble(MAF);
        this.out.writeDouble(CR);
        for (int i = 0; i < 2; ++i) {
            this.out.writeByte(alleles[i]);
        }
        this.out.writeByte(minorallele);
        this.out.writeByte(alleleassessed);
        this.out.writeInt(numsamples);
        this.out.writeLong(gzipIndex);
        ++this.counter;
    }

    public BinaryResultSNP[] readAllSNPs() throws IOException {
        ArrayList<BinaryResultSNP> snps = new ArrayList<BinaryResultSNP>();
        BinaryResultSNP snp = this.readNextSNP();
        int ct = 0;
        while (snp != null) {
            snps.add(snp);
            snp = this.readNextSNP();
            ++ct;
        }
        BinaryResultSNP[] snplist = new BinaryResultSNP[snps.size()];
        this.maxNrSamples = 0;
        for (int s = 0; s < snplist.length; ++s) {
            snplist[s] = (BinaryResultSNP)snps.get(s);
            if (snplist[s].getNumsamples() <= this.maxNrSamples) continue;
            this.maxNrSamples = snplist[s].getNumsamples();
        }
        return snplist;
    }

    public BinaryResultSNP readNextSNP() throws IOException {
        BinaryResultSNP s = null;
        try {
            byte[] alleles = new byte[2];
            s = new BinaryResultSNP();
            s.setId(this.in.readInt());
            s.setName(this.in.readUTF().intern());
            s.setChr(this.in.readByte());
            s.setChrpos(this.in.readInt());
            s.setHwe(this.in.readDouble());
            s.setMaf(this.in.readDouble());
            s.setCr(this.in.readDouble());
            alleles[0] = this.in.readByte();
            alleles[1] = this.in.readByte();
            s.setAlleles(alleles);
            s.setMinorAllele(this.in.readByte());
            s.setAssessedAllele(this.in.readByte());
            s.setNumsamples(this.in.readInt());
            s.setzScoreIndex(this.in.readLong());
            return s;
        }
        catch (EOFException e) {
            return null;
        }
    }

    public int getMaxNrSamples() {
        return this.maxNrSamples;
    }
}

