/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper.bin;

import java.io.IOException;
import java.util.HashMap;
import java.util.zip.DataFormatException;
import umcg.genetica.console.ProgressBar;
import umcg.genetica.io.trityper.bin.BinaryGZipFloatMatrix;
import umcg.genetica.io.trityper.bin.BinaryResultProbe;
import umcg.genetica.io.trityper.bin.BinaryResultProbeSummary;
import umcg.genetica.io.trityper.bin.BinaryResultSNP;
import umcg.genetica.io.trityper.bin.BinaryResultSNPSummary;

public class BinaryResultDataset {
    private String m_name;
    private String m_location;
    private BinaryResultSNP[] snps;
    private HashMap<String, BinaryResultSNP> stringToSNP = new HashMap();
    private BinaryResultProbe[] probes;
    private HashMap<String, BinaryResultProbe> stringToProbe = new HashMap();
    private BinaryGZipFloatMatrix bgfm;
    private int maxNrSamples;
    private float maxfloat = Float.MIN_VALUE;
    private float minfloat = Float.MIN_VALUE;
    private int numprobes;

    public BinaryResultDataset(String location, String name, int permutation) throws IOException {
        this.m_location = location;
        this.m_name = name;
        System.out.println("Loading " + name + " from " + location);
        if (permutation == 0) {
            this.load(this.m_location + this.m_name + ".ProbeSummary.dat", this.m_location + this.m_name + ".SNPSummary.dat", this.m_location + this.m_name + ".ZScoreMatrix.dat");
        } else {
            this.load(this.m_location + this.m_name + ".ProbeSummary.dat", this.m_location + this.m_name + "-PermutationRound-" + permutation + ".SNPSummary.dat", this.m_location + this.m_name + "-PermutationRound-" + permutation + ".ZScoreMatrix.dat");
        }
    }

    private void load(String probesummaryloc, String snpsummaryloc, String zscoreloc) throws IOException {
        System.out.println("Loading files: \n - " + probesummaryloc + "\n - " + snpsummaryloc + "\n - " + zscoreloc);
        BinaryResultProbeSummary ps = new BinaryResultProbeSummary(probesummaryloc, BinaryResultProbeSummary.R);
        BinaryResultSNPSummary ss = new BinaryResultSNPSummary(snpsummaryloc, BinaryResultSNPSummary.R);
        this.snps = ss.readAllSNPs();
        this.probes = ps.readAllProbes();
        for (BinaryResultSNP s : this.snps) {
            this.stringToSNP.put(s.getName().intern(), s);
        }
        for (BinaryResultProbe p : this.probes) {
            this.stringToProbe.put(p.getName().intern(), p);
        }
        System.out.print("Dataset\t" + this.m_name + "\n" + "-------------------------------------------------------------------------------\n");
        System.out.println(this.snps.length + "\t\tSNPs read.");
        System.out.println(this.probes.length + "\t\tProbes read.");
        System.out.println(ss.getMaxNrSamples() + " samples.");
        this.maxNrSamples = ss.getMaxNrSamples();
        ps.close();
        ss.close();
        this.bgfm = new BinaryGZipFloatMatrix(zscoreloc, BinaryGZipFloatMatrix.R);
        this.numprobes = this.probes.length;
        System.out.println("-------------------------------------------------------------------------------\n");
    }

    public void closeMatrix() throws IOException {
        if (this.bgfm != null) {
            this.bgfm.close();
            this.bgfm = null;
        }
    }

    public void openMatrix(int permutation) throws IOException {
        this.closeMatrix();
    }

    public String getM_name() {
        return this.m_name;
    }

    public void setM_name(String m_name) {
        this.m_name = m_name;
    }

    public String getM_location() {
        return this.m_location;
    }

    public void setM_location(String m_location) {
        this.m_location = m_location;
    }

    public BinaryResultSNP[] getSnps() {
        return this.snps;
    }

    public void setSnps(BinaryResultSNP[] snps) {
        this.snps = snps;
    }

    public HashMap<String, BinaryResultSNP> getStringToSNP() {
        return this.stringToSNP;
    }

    public void setStringToSNP(HashMap<String, BinaryResultSNP> stringToSNP) {
        this.stringToSNP = stringToSNP;
    }

    public BinaryResultProbe[] getProbes() {
        return this.probes;
    }

    public void setProbes(BinaryResultProbe[] probes) {
        this.probes = probes;
    }

    public HashMap<String, BinaryResultProbe> getStringToProbe() {
        return this.stringToProbe;
    }

    public void setStringToProbe(HashMap<String, BinaryResultProbe> stringToProbe) {
        this.stringToProbe = stringToProbe;
    }

    private void checkMatrix() throws IOException {
        System.out.println("Detecting whether binary matrix corresponds to SNP and Probe definition.");
        long expectedsize = (long)this.snps.length * (long)this.probes.length;
        System.out.println("Expected matrix size:\t" + expectedsize + " Z-scores");
        System.out.println("Checking matrix: ");
        ProgressBar pb = new ProgressBar(this.snps.length);
        long count = 0L;
        for (int i = 0; i < this.snps.length; ++i) {
            long index = this.snps[i].getzScoreIndex();
            long next = -1L;
            if (i + 1 < this.snps.length) {
                next = this.snps[i + 1].getzScoreIndex();
            }
            try {
                this.bgfm.read(index, next, this.probes.length);
            }
            catch (DataFormatException e) {
                System.out.println("");
                e.printStackTrace();
                System.exit(-1);
            }
            pb.iterate();
        }
        pb.close();
        System.out.println("");
        System.out.println("All Probes are present");
        System.out.println("Matrix is OK");
    }

    public synchronized BinaryGZipFloatMatrix getMatrix() {
        return this.bgfm;
    }

    public int getNumProbes() {
        return this.numprobes;
    }

    public int getMaxNrSamples() {
        return this.maxNrSamples;
    }

    public Float[] readSNPZScores(BinaryResultSNP snp) throws IOException, DataFormatException {
        if (snp == null) {
            return null;
        }
        long index = snp.getzScoreIndex();
        long next = -1L;
        if (snp.getId() + 1 < this.snps.length) {
            next = this.snps[snp.getId() + 1].getzScoreIndex();
        }
        Float[] output = this.bgfm.read(index, next, this.probes.length);
        return output;
    }

    public float getMaxfloat() {
        return this.maxfloat;
    }

    public void setMaxfloat(float maxfloat) {
        this.maxfloat = maxfloat;
    }

    public float getMinfloat() {
        return this.minfloat;
    }

    public void setMinfloat(float minfloat) {
        this.minfloat = minfloat;
    }

    public void clearProbeObjects() {
        for (BinaryResultProbe p : this.probes) {
            p = null;
        }
        this.probes = null;
    }

    public void close() throws IOException {
        this.bgfm.close();
    }
}

