/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper;

import java.io.File;
import java.io.IOException;
import umcg.genetica.io.bin.RandomAccessFile;

public class WGAFileMatrixRawData {
    public int nrSNPs = 0;
    public int nrInds = 0;
    private RandomAccessFile file = null;
    private final byte[] snpCache;
    private int cachedSnp = -1;

    public WGAFileMatrixRawData(int nrSNPs, int nrInds, File fileName, boolean readOnly) throws IOException {
        this.nrSNPs = nrSNPs;
        this.nrInds = nrInds;
        this.snpCache = new byte[nrInds * 3];
        this.file = readOnly ? new RandomAccessFile(fileName, "r") : new RandomAccessFile(fileName, "rw");
        long fileSize = 3L * (long)nrSNPs * (long)nrInds;
        if (!readOnly && this.file.length() != fileSize) {
            this.file.seek(0L);
            byte[] byteString = new byte[1000];
            for (int g = 0; g < 1000; ++g) {
                byteString[g] = 0;
            }
            for (long x = 0L; x < fileSize - 1000L; x += 1000L) {
                this.file.write(byteString);
            }
            long remainder = fileSize % 1000L;
            byte[] byteSingle = new byte[]{0};
            for (long x = 0L; x < remainder; ++x) {
                this.file.write(byteSingle);
            }
            System.out.println("Size matrix:\t" + fileSize + "\tFile size:\t" + this.file.length());
        }
        if (fileSize != this.file.length()) {
            throw new RuntimeException("Raw datafile incorrect size. Expected: " + fileSize + " found: " + this.file.length());
        }
    }

    private long getElement(int snp, int ind) {
        return 3L * (long)snp * (long)this.nrInds + (long)ind;
    }

    private void readSnpIntoCache(int snp) throws IOException {
        this.file.seek(3L * (long)snp * (long)this.nrInds);
        int readBytes = this.file.read(this.snpCache);
        if (readBytes != this.nrInds * 3) {
            throw new IOException("RawMatrix read error. expected: " + this.snpCache.length + " read: " + readBytes + " snp index: " + snp + " file index: " + 3L * (long)snp * (long)this.nrInds);
        }
        this.cachedSnp = snp;
    }

    public void close() throws IOException {
        this.file.close();
    }

    public byte getGCScore(int snp, int ind) throws IOException {
        if (this.cachedSnp != snp) {
            this.readSnpIntoCache(snp);
        }
        return this.snpCache[ind];
    }

    public byte getR(int snp, int ind) throws IOException {
        if (this.cachedSnp != snp) {
            this.readSnpIntoCache(snp);
        }
        return this.snpCache[ind + this.nrInds];
    }

    public byte getTheta(int snp, int ind) throws IOException {
        if (this.cachedSnp != snp) {
            this.readSnpIntoCache(snp);
        }
        return this.snpCache[ind + this.nrInds + this.nrInds];
    }

    public void setGCScore(int snp, int ind, byte[] value) throws IOException {
        this.cachedSnp = -1;
        this.file.seek(this.getElement(snp, ind));
        this.file.write(value);
    }

    public void setR(int snp, int ind, byte[] value) throws IOException {
        this.cachedSnp = -1;
        this.file.seek(this.getElement(snp, ind) + (long)this.nrInds);
        this.file.write(value);
    }

    public void setTheta(int snp, int ind, byte[] value) throws IOException {
        this.cachedSnp = -1;
        this.file.seek(this.getElement(snp, ind) + (long)(this.nrInds * 2));
        this.file.write(value);
    }
}

