/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.util.ChrAnnotation;

public class TriTyperSNPMappings {
    private String[] snps;
    private Byte[] chr;
    private Integer[] chrPos;
    private TextFile snpFile;
    private HashMap<String, Integer> snpIndex = new HashMap();

    public TriTyperSNPMappings(String loc) throws IOException {
        System.out.println("SNP annotation loading: " + loc);
        this.snpFile = new TextFile(loc, false);
        this.parse(null);
        this.snpFile.close();
    }

    public TriTyperSNPMappings(String loc, String querySNPFile) throws IOException {
        System.out.println("SNP annotation loading: " + loc);
        this.snpFile = new TextFile(loc, false);
        Object querySNPs = null;
        TextFile tf = new TextFile(querySNPFile, false);
        this.parse(tf.readAsSet(0, TextFile.tab));
        tf.close();
        this.snpFile.close();
    }

    public TriTyperSNPMappings(String loc, Set<String> querySNPs) throws IOException {
        System.out.println("SNP annotation loading: " + loc);
        this.snpFile = new TextFile(loc, false);
        this.parse(querySNPs);
        this.snpFile.close();
    }

    private void parse(Set<String> query) throws IOException {
        String[] elems = this.snpFile.readLineElems(TextFile.tab);
        int snpCtr = 0;
        ArrayList<String> tmpSNPs = new ArrayList<String>();
        ArrayList<Byte> tmpChr = new ArrayList<Byte>();
        ArrayList<Integer> tmpChrPos = new ArrayList<Integer>();
        while (elems != null) {
            String snp = elems[2];
            if (query == null || query.contains(snp)) {
                tmpSNPs.add(snp);
                tmpChr.add(ChrAnnotation.parseChr(elems[0]));
                tmpChrPos.add(Integer.parseInt(elems[1]));
                this.snpIndex.put(snp, snpCtr);
                ++snpCtr;
            }
            elems = this.snpFile.readLineElems(TextFile.tab);
        }
        this.snps = tmpSNPs.toArray(new String[0]);
        this.chr = tmpChr.toArray(new Byte[0]);
        this.chrPos = tmpChrPos.toArray(new Integer[0]);
    }

    public Byte getChr(String snp) {
        Integer id = this.snpIndex.get(snp);
        if (id != null) {
            return this.chr[id];
        }
        return null;
    }

    public Integer getChrPos(String snp) {
        Integer id = this.snpIndex.get(snp);
        if (id != null) {
            return this.chrPos[id];
        }
        return null;
    }

    public Byte getChr(Integer id) {
        if (id != null) {
            return this.chr[id];
        }
        return null;
    }

    public Integer getChrPos(Integer id) {
        if (id != null) {
            return this.chrPos[id];
        }
        return null;
    }

    public String getSNP(Integer id) {
        if (id != null) {
            return this.snps[id];
        }
        return null;
    }

    public Integer getSNPId(String snp) {
        Integer id = this.snpIndex.get(snp);
        return id;
    }

    public String[] getSNPs() {
        return this.snps;
    }

    public int getNumSNPs() {
        return this.snps.length;
    }
}

