/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import umcg.genetica.containers.Pair;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.TriTyperExpressionData;
import umcg.genetica.io.trityper.TriTyperGeneticalGenomicsDatasetSettings;
import umcg.genetica.io.trityper.TriTyperGenotypeData;
import umcg.genetica.math.matrix.DoubleMatrixDataset;
import umcg.genetica.math.stats.Log2Transform;
import umcg.genetica.math.stats.QuantileNormalization;

public final class TriTyperGeneticalGenomicsDataset
implements Comparable<TriTyperGeneticalGenomicsDataset> {
    private TriTyperGenotypeData genotypeData;
    private TriTyperExpressionData expressionData;
    private THashMap<String, String> genotypeToExpressionCouplings;
    private TriTyperGeneticalGenomicsDatasetSettings settings;
    private short[] expressionToGenotypeIdArray;
    private short totalGGSamples;
    private boolean expressionDataLoadedCorrectly = true;
    private short[] genotypeToExpressionIdArray;
    DoubleMatrixDataset<String, String> covariates = null;

    public TriTyperGeneticalGenomicsDataset(TriTyperGeneticalGenomicsDatasetSettings settings, Pair<List<String>, List<List<String>>> pathwayDefinitions) throws IOException, Exception {
        this.settings = settings;
        settings.genotypeLocation = Gpio.formatAsDirectory(settings.genotypeLocation);
        if (settings.expressionLocation == null) {
            settings.expressionLocation = settings.genotypeLocation + "ExpressionData.txt";
        }
        this.genotypeData = new TriTyperGenotypeData();
        this.genotypeData.load(settings.genotypeLocation);
        THashSet includedExpressionIndividuals = new THashSet();
        Boolean[] isIncluded = this.genotypeData.getIsIncluded();
        this.loadCouplings();
        Set entries = this.genotypeToExpressionCouplings.entrySet();
        for (Map.Entry entry : entries) {
            String genotypeIndividual = (String)entry.getKey();
            Integer genotypeIndividualId = this.genotypeData.getIndividualId(genotypeIndividual);
            if (genotypeIndividualId == -9 || isIncluded[genotypeIndividualId] == null || !isIncluded[genotypeIndividualId].booleanValue()) continue;
            includedExpressionIndividuals.add(entry.getValue());
        }
        if (includedExpressionIndividuals.isEmpty()) {
            System.err.println("ERROR: none of the expression samples will be included with your current settings.\nPlease check the links between genotype and gene expression samples and/or your PhenotypeInformation.txt");
            System.exit(-1);
        }
        this.expressionData = new TriTyperExpressionData();
        this.expressionData.confineToProbes(settings.tsProbesConfine);
        this.expressionData.setConfineToProbesThatMapToAnyChromosome(settings.confineProbesToProbesMappingToAnyChromosome);
        this.expressionData.setConfineToProbesThatMapToChromosome(settings.confineProbesToProbesThatMapToChromosome);
        this.expressionData.setIncludeIndividuals((THashSet<String>)includedExpressionIndividuals);
        this.expressionData.setPathwayDefinitions(pathwayDefinitions);
        this.expressionDataLoadedCorrectly = this.expressionData.load(settings.expressionLocation, settings.probeannotation, settings.expressionplatform, settings.cisAnalysis && settings.transAnalysis);
        this.pruneGenotypeToExpressionCouplings();
        if (settings.quantilenormalize) {
            QuantileNormalization.quantilenormalize(this.expressionData.getMatrix());
        }
        if (settings.logtransform) {
            Log2Transform.log2transform(this.expressionData.getMatrix());
        }
        if (settings.covariateFile != null && Gpio.exists(settings.covariateFile)) {
            System.out.println("Loading covariates: " + settings.covariateFile);
            HashSet<String> individualSet = new HashSet<String>();
            individualSet.addAll(Arrays.asList(this.expressionData.getIndividuals()));
            this.covariates = new DoubleMatrixDataset(settings.covariateFile, null, individualSet);
            if (this.covariates.colObjects.isEmpty()) {
                System.out.println("Could not find matching sample identifiers between covariate file and expression file.\nTransposing your covariate file.");
                this.covariates = new DoubleMatrixDataset(settings.covariateFile, individualSet);
                if (this.covariates.rowObjects.isEmpty()) {
                    System.err.println("Could not find matching samples between expression data and covariate data.");
                    System.exit(-1);
                } else {
                    this.covariates.transposeDataset();
                    this.covariates.recalculateHashMaps();
                }
            }
            this.covariates.removeColumnsWithNaNs();
            this.covariates.recalculateHashMaps();
            if (this.covariates.colObjects.isEmpty()) {
                System.err.println("ERROR: after removing samples with NaN values, no covariates remain");
                System.exit(-1);
            }
            System.out.println(this.covariates.rowObjects.size() + " covariates loaded for " + this.covariates.colObjects.size() + " samples");
            this.expressionData.pruneAndReorderSamples(this.covariates.colObjects);
            this.loadCouplings();
            this.pruneGenotypeToExpressionCouplings();
        }
    }

    public TriTyperGeneticalGenomicsDataset(TriTyperGeneticalGenomicsDatasetSettings settings) throws IOException, Exception {
        this(settings, null);
    }

    public TriTyperGenotypeData getGenotypeData() {
        return this.genotypeData;
    }

    public void setGenotypeData(TriTyperGenotypeData genotypeData) {
        this.genotypeData = genotypeData;
    }

    public TriTyperExpressionData getExpressionData() {
        return this.expressionData;
    }

    public void setExpressionData(TriTyperExpressionData expressionData) {
        this.expressionData = expressionData;
    }

    public THashMap<String, String> getGenotypeToExpressionCouplings() {
        return this.genotypeToExpressionCouplings;
    }

    public void setGenotypeToExpressionCouplings(THashMap<String, String> genotypeToExpressionCouplings) {
        this.genotypeToExpressionCouplings = genotypeToExpressionCouplings;
    }

    public TriTyperGeneticalGenomicsDatasetSettings getSettings() {
        return this.settings;
    }

    public void setSettings(TriTyperGeneticalGenomicsDatasetSettings settings) {
        this.settings = settings;
    }

    public int getTotalGGSamples() {
        return this.totalGGSamples;
    }

    private void loadCouplings() throws IOException {
        this.genotypeToExpressionCouplings = new THashMap();
        String genotypeToExpressionCoupling = this.settings.genotypeToExpressionCoupling;
        if (genotypeToExpressionCoupling != null && genotypeToExpressionCoupling.trim().length() > 0) {
            if (!Gpio.exists(genotypeToExpressionCoupling)) {
                throw new IOException("Error: genotype to expression coupling file: " + genotypeToExpressionCoupling + " does not exist.");
            }
            TextFile in = new TextFile(genotypeToExpressionCoupling, false);
            String[] elems = in.readLineElemsReturnReference(TextFile.tab);
            while (elems != null) {
                if (elems.length > 1) {
                    String key = new String(elems[0].getBytes("UTF-8"));
                    String value = new String(elems[1].getBytes("UTF-8"));
                    if (this.genotypeToExpressionCouplings.get((Object)key) != null) {
                        System.out.println("ERROR: your genotype to expression coupling file contains duplicate entries for individual: " + key);
                        System.exit(0);
                    } else {
                        this.genotypeToExpressionCouplings.put((Object)key, (Object)value);
                    }
                }
                elems = in.readLineElemsReturnReference(TextFile.tab);
            }
            in.close();
        } else {
            String[] individuals;
            Boolean[] isIncluded = this.genotypeData.getIsIncluded();
            int i = 0;
            for (String ind : individuals = this.genotypeData.getIndividuals()) {
                if (isIncluded[i] != null && isIncluded[i].booleanValue()) {
                    if (this.genotypeToExpressionCouplings.get((Object)ind) != null) {
                        System.out.println("ERROR: your genotype data contains duplicate individuals: " + ind);
                        System.exit(0);
                    } else {
                        this.genotypeToExpressionCouplings.put((Object)ind, (Object)ind);
                    }
                }
                ++i;
            }
        }
    }

    public int[] getExpressionToGenotypeIdArray() {
        int[] intExpToGArr = new int[this.expressionToGenotypeIdArray.length];
        for (int i = 0; i < intExpToGArr.length; ++i) {
            intExpToGArr[i] = this.expressionToGenotypeIdArray[i];
        }
        return intExpToGArr;
    }

    public short[] getExpressionToGenotypeIdArrayShort() {
        return this.expressionToGenotypeIdArray;
    }

    @Override
    public int compareTo(TriTyperGeneticalGenomicsDataset o) {
        int numIndsOther = o.getGenotypeData().getIndividuals().length;
        return this.genotypeData.getIndividuals().length - numIndsOther;
    }

    public boolean equals(TriTyperGeneticalGenomicsDataset o) {
        int numIndsOther = o.getGenotypeData().getIndividuals().length;
        return this.genotypeData.getIndividuals().length == numIndsOther;
    }

    public void permuteSampleLables(Random r) {
        ArrayList<Short> alIndWGA = new ArrayList<Short>();
        int numSamples = this.expressionToGenotypeIdArray.length;
        for (int i = 0; i < numSamples; ++i) {
            if (this.expressionToGenotypeIdArray[i] == -1) continue;
            alIndWGA.add(this.expressionToGenotypeIdArray[i]);
        }
        short[] indWGANew = new short[numSamples];
        this.genotypeToExpressionIdArray = new short[this.genotypeData.getIndividuals().length];
        for (int i = 0; i < numSamples; ++i) {
            short genotypeId;
            if (this.expressionToGenotypeIdArray[i] == -1) {
                indWGANew[i] = -1;
                continue;
            }
            indWGANew[i] = genotypeId = ((Short)alIndWGA.remove((int)(r.nextDouble() * (double)alIndWGA.size()))).shortValue();
            this.genotypeToExpressionIdArray[genotypeId] = (short)i;
        }
        this.expressionToGenotypeIdArray = indWGANew;
    }

    public void permuteCovariates(Random r) {
        if (this.covariates != null) {
            System.out.println("Randomizing covariates");
            for (int covariate = 0; covariate < this.covariates.nrRows; ++covariate) {
                int sample;
                ArrayList<Double> covariateData = new ArrayList<Double>();
                for (sample = 0; sample < this.covariates.nrRows; ++sample) {
                    covariateData.add(this.covariates.rawData[covariate][sample]);
                }
                Collections.shuffle(covariateData, r);
                for (sample = 0; sample < this.covariates.nrRows; ++sample) {
                    this.covariates.rawData[covariate][sample] = (Double)covariateData.get(sample);
                }
            }
        }
    }

    public void resetGenotypeToExpressionCouplings() throws IOException {
        this.loadCouplings();
    }

    public void pruneGenotypeToExpressionCouplings() {
        String[] individuals = this.genotypeData.getIndividuals();
        Boolean[] isReallyIncluded = new Boolean[individuals.length];
        THashMap realGenotypeToExpressionCouplings = new THashMap();
        this.totalGGSamples = 0;
        for (int i = 0; i < isReallyIncluded.length; ++i) {
            String genotypeInd = individuals[i];
            if (!this.genotypeToExpressionCouplings.containsKey((Object)genotypeInd)) {
                isReallyIncluded[i] = false;
                continue;
            }
            String coupledExpressionSample = (String)this.genotypeToExpressionCouplings.get((Object)genotypeInd);
            if (coupledExpressionSample == null) continue;
            Integer expressionSampleId = this.expressionData.getIndividualId(coupledExpressionSample);
            if (expressionSampleId == -9) {
                isReallyIncluded[i] = false;
                continue;
            }
            isReallyIncluded[i] = true;
            realGenotypeToExpressionCouplings.put((Object)genotypeInd, (Object)coupledExpressionSample);
            this.totalGGSamples = (short)(this.totalGGSamples + 1);
        }
        this.genotypeData.setIsIncluded(isReallyIncluded);
        this.genotypeToExpressionCouplings = realGenotypeToExpressionCouplings;
        Set entries = realGenotypeToExpressionCouplings.entrySet();
        this.expressionToGenotypeIdArray = new short[this.totalGGSamples];
        HashSet<Integer> visitedNumbers = new HashSet<Integer>();
        for (Map.Entry entry : entries) {
            Integer expressionIndId = this.expressionData.getIndividualId((String)entry.getValue());
            Integer genotypeIndId = this.genotypeData.getIndividualId((String)entry.getKey());
            if (expressionIndId == -9 || genotypeIndId == -9) continue;
            if (visitedNumbers.contains(expressionIndId)) {
                System.out.println("ERROR: your dataset contains duplicate samples!");
                continue;
            }
            this.expressionToGenotypeIdArray[expressionIndId.intValue()] = genotypeIndId.shortValue();
            visitedNumbers.add(expressionIndId);
        }
    }

    public HashMap<Integer, Integer> getGenotypeToExpressionIdHash() {
        HashMap<Integer, Integer> gte = new HashMap<Integer, Integer>();
        int expressionIndId = 0;
        for (short genotypeIndId : this.expressionToGenotypeIdArray) {
            gte.put(Integer.valueOf(genotypeIndId), expressionIndId);
            ++expressionIndId;
        }
        return gte;
    }

    public HashMap<Integer, Integer> getExpressionToGenotypeIdHash() {
        HashMap<Integer, Integer> etg = new HashMap<Integer, Integer>();
        int expressionIndId = 0;
        for (short genotypeIndId : this.expressionToGenotypeIdArray) {
            etg.put(expressionIndId, Integer.valueOf(genotypeIndId));
            ++expressionIndId;
        }
        return etg;
    }

    public boolean isExpressionDataLoadedCorrectly() {
        return this.expressionDataLoadedCorrectly;
    }

    public void setExpressionDataLoadedCorrectly(boolean expressionDataLoadedCorrectly) {
        this.expressionDataLoadedCorrectly = expressionDataLoadedCorrectly;
    }

    public DoubleMatrixDataset<String, String> getCovariateData() {
        return this.covariates;
    }
}

