/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.primitives.ArrayIntList;
import umcg.genetica.containers.Pair;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.util.ChrAnnotation;
import umcg.genetica.math.stats.Descriptives;
import umcg.genetica.util.RankArray;

public class TriTyperExpressionData {
    private int[] chrStart;
    private int[] chrStop;
    private byte[] chr;
    private String[] annotation;
    private double[][] matrix;
    private String[] individuals;
    private TObjectIntHashMap<String> individualNameToId;
    private String[] probes;
    private TObjectIntHashMap<String> probeNameToId;
    private THashMap<String, ArrayIntList> annotationToProbeId;
    private THashSet<String> includeIndividuals;
    private boolean confineToProbesThatMapToAnyChromosome;
    private Integer confineToProbesMappingOnChromosome;
    private THashSet<String> probesConfine;
    private double[] probeOriginalMean;
    private double[] probeOriginalVariance;
    private double[] probeMean;
    private double[] probeVariance;
    private String m_platform;
    private Pair<List<String>, List<List<String>>> pathwayDefinitions;

    public TriTyperExpressionData() {
    }

    public TriTyperExpressionData(String loc, String probeAnnotationLoc, String platform, boolean cistrans) throws IOException {
        this.load(loc, probeAnnotationLoc, platform, cistrans);
    }

    public String[] getRowNames() {
        return this.individuals;
    }

    public void setRowNames(String[] rowNames) {
        this.individuals = rowNames;
    }

    public TObjectIntHashMap<String> getRowNameToId() {
        return this.individualNameToId;
    }

    public void setRowNameToId(TObjectIntHashMap<String> rowNameToId) {
        this.individualNameToId = rowNameToId;
    }

    public String[] getColNames() {
        return this.probes;
    }

    public void setColNames(String[] colNames) {
        this.probes = colNames;
    }

    public TObjectIntHashMap<String> getColNameToId() {
        return this.probeNameToId;
    }

    public void setColNameToId(TObjectIntHashMap<String> colNameToId) {
        this.probeNameToId = colNameToId;
    }

    public double[][] getMatrix() {
        return this.matrix;
    }

    public void setMatrix(double[][] matrix) {
        this.matrix = matrix;
    }

    public void setIncludeIndividuals(THashSet<String> includedIndividuals) {
        this.includeIndividuals = includedIndividuals;
    }

    public void setConfineToProbesThatMapToAnyChromosome(boolean chr) {
        this.confineToProbesThatMapToAnyChromosome = chr;
    }

    public void setConfineToProbesThatMapToChromosome(Integer chr) {
        this.confineToProbesMappingOnChromosome = chr;
    }

    public void confineToProbes(THashSet<String> probes) {
        this.probesConfine = probes;
    }

    public final boolean load(String loc, String probeAnnotationLoc, String platform, boolean cistrans) throws IOException {
        int i;
        if (!Gpio.exists(loc)) {
            throw new IOException("! Error loading expression data: " + loc + " does not exist");
        }
        System.out.println("Loading expression data from: " + loc);
        TextFile in = new TextFile(loc, false);
        int numProbes = 0;
        boolean trityperformat = false;
        int offset = 1;
        String[] elems = null;
        numProbes = in.countLines();
        elems = in.readLineElemsReturnReference(TextFile.tab);
        if (elems[0].trim().toLowerCase().equals("probe") && elems[3].trim().toLowerCase().equals("chr") && elems[4].trim().toLowerCase().equals("chrstart")) {
            System.out.println("! Expression data is still in the old, deprecated TriTyper format.");
            trityperformat = true;
            offset = 9;
        } else if (probeAnnotationLoc == null && !cistrans) {
            throw new IOException("ERROR: Probe annotation is not specified. Please specify probe annotation or provide expression data in TriTyper format!");
        }
        HashMap<String, Byte> hashProbeChr = null;
        HashMap<String, Integer> hashProbeChrStart = null;
        HashMap<String, Integer> hashProbeChrStop = null;
        HashMap<String, String> hashAnnot = null;
        if (probeAnnotationLoc != null) {
            if (trityperformat) {
                System.out.println("! WARNING: overriding probe annotation from TriTyper file with probe annotation!");
                trityperformat = false;
                offset = 9;
            }
            System.out.println("Loading probe annotation from: " + probeAnnotationLoc);
            hashProbeChr = new HashMap<String, Byte>();
            hashProbeChrStart = new HashMap<String, Integer>();
            hashProbeChrStop = new HashMap<String, Integer>();
            hashAnnot = new HashMap<String, String>();
            TextFile an = new TextFile(probeAnnotationLoc, false);
            an.readLineElemsReturnReference(TextFile.tab);
            String[] anelems = an.readLineElemsReturnReference(TextFile.tab);
            boolean filterplatform = true;
            if (this.m_platform == null) {
                filterplatform = false;
            }
            int numAnnotLoaded = 0;
            while (anelems != null) {
                if (anelems.length >= 6 && (!filterplatform || filterplatform && anelems[0].equals(this.m_platform))) {
                    String probe = new String(anelems[1]).intern();
                    Byte bchr = ChrAnnotation.parseChr(anelems[3]);
                    Integer ichrStart = -1;
                    Integer ichrStop = -1;
                    try {
                        ichrStart = Integer.parseInt(anelems[4]);
                        ichrStop = Integer.parseInt(anelems[5]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    String annot = new String(anelems[2].getBytes("UTF-8"));
                    hashProbeChr.put(probe, bchr);
                    hashProbeChrStart.put(probe, ichrStart);
                    hashProbeChrStop.put(probe, ichrStop);
                    hashAnnot.put(probe, annot);
                    ++numAnnotLoaded;
                }
                anelems = an.readLineElemsReturnReference(TextFile.tab);
            }
            an.close();
            if (numAnnotLoaded == 0) {
                throw new IOException("Error: no probe annotation available for expression platform: " + platform);
            }
            System.out.println("Loaded annotation for " + numAnnotLoaded + " probes.");
        }
        int numIndsIncluded = 0;
        TObjectIntHashMap indToId = new TObjectIntHashMap(elems.length, 1.0f, -9);
        boolean[] includeCol = new boolean[elems.length];
        for (int pos = offset; pos < elems.length; ++pos) {
            if (this.includeIndividuals == null || this.includeIndividuals.contains((Object)elems[pos])) {
                ++numIndsIncluded;
                includeCol[pos] = true;
                continue;
            }
            includeCol[pos] = false;
        }
        this.individuals = new String[numIndsIncluded];
        int indNo = 0;
        for (int pos = offset; pos < elems.length; ++pos) {
            if (!includeCol[pos]) continue;
            this.individuals[indNo] = new String(elems[pos].getBytes("UTF-8"));
            indToId.put((Object)elems[pos], indNo);
            ++indNo;
        }
        this.individualNameToId = indToId;
        System.out.println("Found gene expression data for " + numIndsIncluded + " individuals");
        ArrayList<Integer> tmpChrStart = new ArrayList<Integer>();
        ArrayList<Integer> tmpChrEnd = new ArrayList<Integer>();
        ArrayList<Byte> tmpChr = new ArrayList<Byte>();
        ArrayList<String> tmpProbe = new ArrayList<String>();
        ArrayList<float[]> tmpRaw = new ArrayList<float[]>();
        ArrayList<String> tmpAnnotation = new ArrayList<String>();
        this.annotationToProbeId = new THashMap();
        int probeNr = 0;
        elems = in.readLineElemsReturnReference(TextFile.tab);
        if (!trityperformat && hashProbeChr == null && !cistrans) {
            System.out.println("WARNING: no probe annotation available.");
        }
        int probesIncluded = 0;
        int probesExcluded = 0;
        HashSet<Integer> probesWithMissingValues = new HashSet<Integer>();
        while (elems != null) {
            boolean printreason = true;
            if (elems.length > 1) {
                String probe = new String(elems[0].getBytes("UTF-8"));
                String annotstr = null;
                Byte probeChr = null;
                Integer probeChrStart = null;
                Integer probeChrEnd = null;
                boolean includeprobe = false;
                String reason = "";
                if (trityperformat && elems.length > 9) {
                    Byte bchr = ChrAnnotation.parseChr(elems[3]);
                    if (this.probesConfine == null || this.probesConfine.contains((Object)probe)) {
                        if (!this.confineToProbesThatMapToAnyChromosome || bchr >= 1) {
                            if (this.confineToProbesMappingOnChromosome == null || this.confineToProbesMappingOnChromosome.equals(bchr)) {
                                probeChr = bchr;
                                probeChrStart = Integer.parseInt(elems[4]);
                                probeChrEnd = Integer.parseInt(elems[5]);
                                annotstr = new String(elems[7].getBytes("UTF-8"));
                                includeprobe = true;
                            } else {
                                ++probesExcluded;
                                reason = reason + "\tprobe does not map to chromosome:" + this.confineToProbesMappingOnChromosome + "\t" + bchr;
                            }
                        } else {
                            ++probesExcluded;
                            reason = reason + "\tprobe does not map to any chromosome:\t" + bchr;
                        }
                    } else {
                        ++probesExcluded;
                        printreason = false;
                    }
                } else if (!trityperformat) {
                    if (hashProbeChr != null && !cistrans) {
                        probeChr = (Byte)hashProbeChr.get(probe);
                        probeChrStart = (Integer)hashProbeChrStart.get(probe);
                        probeChrEnd = (Integer)hashProbeChrStop.get(probe);
                        annotstr = (String)hashAnnot.get(probe);
                        if (probeChr == null) {
                            reason = reason + "Probe annotation not loaded for probe:\t" + probe;
                        } else if (!(this.probesConfine != null && !this.probesConfine.contains((Object)probe) || this.confineToProbesThatMapToAnyChromosome && probeChr < 1 || this.confineToProbesMappingOnChromosome != null && !this.confineToProbesMappingOnChromosome.equals(probeChr))) {
                            includeprobe = true;
                        } else {
                            reason = reason + "Probe not selected during confinement.";
                        }
                    } else {
                        if (!cistrans) {
                            throw new IOException("ERROR: probe annotation not loaded?");
                        }
                        if (hashProbeChr != null && cistrans) {
                            probeChr = (Byte)hashProbeChr.get(probe);
                            probeChrStart = (Integer)hashProbeChrStart.get(probe);
                            probeChrEnd = (Integer)hashProbeChrStop.get(probe);
                            annotstr = (String)hashAnnot.get(probe);
                            includeprobe = true;
                        } else if (this.probesConfine == null || this.probesConfine.contains((Object)probe)) {
                            includeprobe = true;
                            probeChr = -1;
                            probeChrStart = -1;
                            probeChrEnd = -1;
                            annotstr = "-";
                        } else {
                            printreason = false;
                        }
                    }
                } else {
                    System.err.println("Error: data is in TriTyper format, but is probably wrongly formated (because the number of columns <10!)");
                    System.exit(-1);
                }
                if (!cistrans && includeprobe && probeChr == null && probeChrStart == null && probeChrEnd == null && (this.probesConfine == null || this.probesConfine.contains((Object)probe))) {
                    includeprobe = false;
                    reason = reason + "WARNING: probe\t" + probe + "\thas no annotation at all! Will exclude this probe from further use.";
                }
                if (includeprobe) {
                    ++probesIncluded;
                    tmpProbe.add(probe.intern());
                    if (probeChr == null) {
                        probeChr = -1;
                    }
                    tmpChr.add(probeChr);
                    if (probeChrStart == null) {
                        probeChrStart = -1;
                    }
                    tmpChrStart.add(probeChrStart);
                    if (probeChrEnd == null) {
                        probeChrEnd = -1;
                    }
                    tmpChrEnd.add(probeChrEnd);
                    if (annotstr != null && annotstr.length() > 0) {
                        ArrayIntList annotationToProbe = (ArrayIntList)this.annotationToProbeId.get((Object)new String(elems[7].getBytes("UTF-8")));
                        if (annotationToProbe == null) {
                            annotationToProbe = new ArrayIntList();
                        }
                        annotationToProbe.add(probeNr);
                        this.annotationToProbeId.put((Object)probe, (Object)annotationToProbe);
                    }
                    if (annotstr == null) {
                        annotstr = "-";
                    }
                    tmpAnnotation.add(annotstr.intern());
                    int samplePos = 0;
                    float[] tmpDt = new float[numIndsIncluded];
                    for (int pos = offset; pos < elems.length; ++pos) {
                        if (!includeCol[pos]) continue;
                        try {
                            tmpDt[samplePos] = Float.parseFloat(elems[pos]);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("WARNING: missing value for column:\t" + pos + "\tprobe:\t" + probe);
                            tmpDt[samplePos] = Float.NaN;
                            probesWithMissingValues.add(probeNr);
                        }
                        ++samplePos;
                    }
                    tmpRaw.add(tmpDt);
                    if (++probeNr % 10000 == 0) {
                        System.out.println(probeNr + " probes parsed.");
                    }
                } else if (printreason) {
                    ++probesExcluded;
                }
            }
            elems = in.readLineElemsReturnReference(TextFile.tab);
        }
        in.close();
        if (probesWithMissingValues.size() > 0) {
            System.err.println("WARNING: " + probesWithMissingValues.size() + " probes with missing values detected. Will replace missing values with average probe value.");
            ArrayList newRaw = new ArrayList();
            for (int i2 = 0; i2 < tmpRaw.size(); ++i2) {
                if (probesWithMissingValues.contains(i2)) {
                    int j;
                    float[] data = (float[])tmpRaw.get(i2);
                    double sum = 0.0;
                    int nrNotMissing = 0;
                    for (j = 0; j < data.length; ++j) {
                        if (Float.isNaN(data[j])) continue;
                        sum += (double)data[j];
                        ++nrNotMissing;
                    }
                    sum /= (double)nrNotMissing;
                    for (j = 0; j < data.length; ++j) {
                        if (!Float.isNaN(data[j])) continue;
                        data[j] = (float)sum;
                    }
                    continue;
                }
                newRaw.add(tmpRaw.get(i2));
            }
        }
        System.out.println("Probes selected:\t" + probesIncluded);
        System.out.println("Probes not selected:\t" + probesExcluded);
        if (probeNr == 0) {
            System.err.println("ERROR: No gene expression data loaded for (no probes matching criteria): " + loc);
            return false;
        }
        this.chr = new byte[probeNr];
        this.annotation = new String[probeNr];
        this.chrStart = new int[probeNr];
        this.chrStop = new int[probeNr];
        this.probes = new String[probeNr];
        this.matrix = new double[probeNr][numIndsIncluded];
        this.probeNameToId = new TObjectIntHashMap(probeNr, 1.0f, -9);
        for (i = 0; i < probeNr; ++i) {
            this.probes[i] = (String)tmpProbe.get(i);
            this.probeNameToId.put((Object)this.probes[i], i);
            this.annotation[i] = (String)tmpAnnotation.get(i);
            if (this.annotation[i] == null) {
                this.annotation[i] = "-";
            }
            if (tmpChr.get(i) == null) {
                System.err.println("No chromosome annotation loaded for probe " + (String)tmpProbe.get(i));
                this.chr[i] = -1;
                this.chrStart[i] = -1;
                this.chrStop[i] = -1;
                continue;
            }
            this.chr[i] = (Byte)tmpChr.get(i);
            this.chrStart[i] = (Integer)tmpChrStart.get(i);
            this.chrStop[i] = (Integer)tmpChrEnd.get(i);
        }
        for (i = 0; i < numIndsIncluded; ++i) {
            for (int p = 0; p < probeNr; ++p) {
                this.matrix[p][i] = ((float[])tmpRaw.get(p))[i];
            }
        }
        tmpChrStart = null;
        tmpChrEnd = null;
        tmpChr = null;
        tmpProbe = null;
        tmpRaw = null;
        tmpAnnotation = null;
        if (this.pathwayDefinitions != null) {
            System.out.println("Now performing Pathway merger magic. *stars and unicorns*");
            List<String> pathwayNames = this.pathwayDefinitions.getLeft();
            List<List<String>> genesInPathways = this.pathwayDefinitions.getRight();
            double[][] pathwayData = new double[pathwayNames.size()][this.individuals.length];
            boolean[] usePathway = new boolean[pathwayNames.size()];
            int nrPathwaysToUse = 0;
            int len = pathwayNames.size();
            for (int p = 0; p < len; ++p) {
                List<String> ensGenesForPathway = genesInPathways.get(p);
                HashSet<String> hashGenesForPathway = new HashSet<String>(ensGenesForPathway);
                int nrProbesFound = 0;
                for (int probe = 0; probe < this.matrix.length; ++probe) {
                    String annotationForProbe = this.annotation[probe];
                    String[] annStrings = annotationForProbe.split(";");
                    boolean hasRightAnnotation = false;
                    for (String s : annStrings) {
                        if (!hashGenesForPathway.contains(s)) continue;
                        hasRightAnnotation = true;
                    }
                    if (!hasRightAnnotation) continue;
                    for (int i3 = 0; i3 < this.individuals.length; ++i3) {
                        double[] dArray = pathwayData[p];
                        int n = i3;
                        dArray[n] = dArray[n] + this.matrix[probe][i3];
                    }
                    ++nrProbesFound;
                }
                if (nrProbesFound > 1) {
                    int i4 = 0;
                    while (i4 < this.individuals.length) {
                        double[] dArray = pathwayData[p];
                        int n = i4++;
                        dArray[n] = dArray[n] / (double)nrProbesFound;
                    }
                }
                if (nrProbesFound < 10) continue;
                usePathway[p] = true;
                ++nrPathwaysToUse;
            }
            System.out.println("Final number of pathways used in this dataset: " + nrPathwaysToUse);
            this.matrix = new double[nrPathwaysToUse][0];
            this.probes = new String[nrPathwaysToUse];
            this.probeNameToId = new TObjectIntHashMap(nrPathwaysToUse, 1.0f, -9);
            this.probeMean = new double[nrPathwaysToUse];
            this.probeVariance = new double[nrPathwaysToUse];
            this.probeOriginalMean = new double[nrPathwaysToUse];
            this.probeOriginalVariance = new double[nrPathwaysToUse];
            this.chr = new byte[nrPathwaysToUse];
            this.chrStart = new int[nrPathwaysToUse];
            this.chrStop = new int[nrPathwaysToUse];
            int nrPathwaysUsed = 0;
            int len2 = pathwayNames.size();
            for (int p = 0; p < len2; ++p) {
                if (!usePathway[p]) continue;
                this.matrix[nrPathwaysUsed] = pathwayData[p];
                this.probes[nrPathwaysUsed] = pathwayNames.get(p);
                this.probeNameToId.put((Object)this.probes[nrPathwaysUsed], nrPathwaysUsed);
                ++nrPathwaysUsed;
            }
        }
        this.probeMean = new double[this.probes.length];
        this.probeOriginalMean = new double[this.probes.length];
        this.probeVariance = new double[this.probes.length];
        this.probeOriginalVariance = new double[this.probes.length];
        this.setVarianceAndMean();
        System.out.println("Loaded " + this.matrix.length + " probes for " + this.individuals.length + " individuals");
        return true;
    }

    public int[] getChrStart() {
        return this.chrStart;
    }

    public void setChrStart(int[] chrStart) {
        this.chrStart = chrStart;
    }

    public int[] getChrStop() {
        return this.chrStop;
    }

    public void setChrStop(int[] chrStop) {
        this.chrStop = chrStop;
    }

    public String[] getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String[] annotation) {
        this.annotation = annotation;
    }

    public byte[] getChr() {
        return this.chr;
    }

    public void setChr(byte[] chr) {
        this.chr = chr;
    }

    public String[] getIndividuals() {
        return this.individuals;
    }

    public String[] getProbes() {
        return this.probes;
    }

    public TObjectIntHashMap<String> getIndividualToId() {
        return this.individualNameToId;
    }

    public TObjectIntHashMap<String> getProbeToId() {
        return this.probeNameToId;
    }

    public Integer getIndividualId(String key) {
        return this.individualNameToId.get((Object)key);
    }

    public void calcMeanAndVariance() {
        for (int f = 0; f < this.probes.length; ++f) {
            this.probeOriginalMean[f] = Descriptives.mean(this.getProbeData(f));
            this.probeMean[f] = this.probeOriginalMean[f];
            this.probeOriginalVariance[f] = Descriptives.variance(this.getProbeData(f), this.probeMean[f]);
            this.probeVariance[f] = this.probeOriginalVariance[f];
        }
    }

    public void calcAndSubtractMean() {
        for (int p = 0; p < this.probes.length; ++p) {
            this.probeMean[p] = Descriptives.mean(this.getProbeData(p));
            int s = 0;
            while (s < this.matrix[p].length) {
                double[] dArray = this.matrix[p];
                int n = s++;
                dArray[n] = dArray[n] - this.probeMean[p];
            }
        }
    }

    private void setVarianceAndMean() {
        for (int p = 0; p < this.probes.length; ++p) {
            this.probeMean[p] = Descriptives.mean(this.getProbeData(p));
            this.probeVariance[p] = Descriptives.variance(this.getProbeData(p), this.probeMean[p]);
        }
    }

    private double[] getProbeData(int f) {
        double[] probeData = new double[this.individuals.length];
        System.arraycopy(this.matrix[f], 0, probeData, 0, this.individuals.length);
        return probeData;
    }

    public double[] getProbeVariance() {
        return this.probeVariance;
    }

    public double[] getProbeMean() {
        return this.probeMean;
    }

    public double[] getOriginalProbeVariance() {
        return this.probeOriginalVariance;
    }

    public double[] getOriginalProbeMean() {
        return this.probeOriginalMean;
    }

    public void rankAllExpressionData(boolean rankWithTies) {
        RankArray r = new RankArray();
        for (int p = 0; p < this.probes.length; ++p) {
            double[] probeData = this.getProbeData(p);
            if (this.probeVariance[p] == 0.0) {
                System.out.println("Excluding probe that has no variance in expression:\t" + this.probes[p] + "\t" + this.annotation[p]);
                continue;
            }
            if (Double.isNaN(this.probeMean[p]) || Double.isNaN(this.probeVariance[p])) {
                System.out.println("Error ranking expression data: probe mean or variance is NaN!:\t" + p + "\t" + this.probes[p] + "\t" + this.probeMean[p] + "\t" + this.probeVariance[p]);
                System.exit(-1);
                continue;
            }
            probeData = r.rank(probeData, rankWithTies);
            this.setProbeData(p, probeData);
            this.probeMean[p] = Descriptives.mean(probeData);
            this.probeVariance[p] = Descriptives.variance(probeData, this.probeMean[p]);
        }
    }

    private void setProbeData(int f, double[] probeData) {
        for (int i = 0; i < this.individuals.length; ++i) {
            this.matrix[f][i] = (float)probeData[i];
        }
    }

    public void pruneAndReorderSamples(List<String> colObjects) {
        int i;
        double[][] newMatrix = new double[this.matrix.length][colObjects.size()];
        TObjectIntHashMap indToInd = new TObjectIntHashMap(colObjects.size(), 1.0f, -9);
        for (i = 0; i < colObjects.size(); ++i) {
            String ind = colObjects.get(i);
            indToInd.put((Object)ind, i);
        }
        for (i = 0; i < this.individuals.length; ++i) {
            Integer newId = indToInd.get((Object)this.individuals[i]);
            if (newId == -9) continue;
            for (int row = 0; row < this.matrix.length; ++row) {
                newMatrix[row][newId.intValue()] = this.matrix[row][i];
            }
        }
        this.matrix = newMatrix;
        this.individualNameToId = indToInd;
        this.individuals = colObjects.toArray(new String[0]);
    }

    public void setPathwayDefinitions(Pair<List<String>, List<List<String>>> pathwayDefinitions) {
        this.pathwayDefinitions = pathwayDefinitions;
    }
}

