/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import umcg.genetica.collections.ChrPosTreeMap;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.EQTL;
import umcg.genetica.io.trityper.MinimalEQTL;
import umcg.genetica.io.trityper.util.ChrAnnotation;

public class QTLTextFile
extends TextFile {
    public static int PVAL = 0;
    public static int SNP = 1;
    public static int SNPCHR = 2;
    public static int SNPLOC = 3;
    public static int PROBE = 4;
    public static int PROBECHR = 5;
    public static int PROBELOC = 6;
    public static int CISTRANS = 7;
    public static int SNPTYPE = 8;
    public static int ASESSEDALLELE = 9;
    public static int METAZ = 10;
    public static int DATASETNAMES = 11;
    public static int DATASETZSCORE = 12;
    public static int DATASETSIZE = 13;
    public static int HUGO = 16;
    public static int DATASECORR = 17;
    public static int METAB = 18;
    public static int DATASETB = 19;
    private static String sepStr = ";";
    private static String nullStr = "-";
    private static Pattern separator = Pattern.compile(sepStr);
    public static String header = "PValue\tSNPName\tSNPChr\tSNPChrPos\tProbeName\tProbeChr\tProbeCenterChrPos\tCisTrans\tSNPType\tAlleleAssessed\tOverallZScore\tDatasetsWhereSNPProbePairIsAvailableAndPassesQC\tDatasetsZScores\tDatasetsNrSamples\tIncludedDatasetsMeanProbeExpression\tIncludedDatasetsProbeExpressionVariance\tHGNCName\tIncludedDatasetsCorrelationCoefficient\tMeta-Beta (SE)\tBeta (SE)\tFoldChange\tFDR";

    public QTLTextFile(String loc, boolean W) throws IOException {
        super(loc, W);
        if (W) {
            this.write(header + '\n');
        }
    }

    public QTLTextFile(String loc, boolean W, boolean gz) throws IOException {
        super(loc, W);
        if (W) {
            this.write(header + '\n');
        }
    }

    public void write(EQTL[] eqtllist) throws IOException {
        for (EQTL e : eqtllist) {
            this.write(e.toString() + '\n');
        }
    }

    public void write(ArrayList<EQTL> eqtllist) throws IOException {
        for (EQTL e : eqtllist) {
            this.write(e.toString() + '\n');
        }
    }

    public void writeMinimal(ArrayList<MinimalEQTL> eqtllist) throws IOException {
        for (MinimalEQTL e : eqtllist) {
            this.write(e.toString() + '\n');
        }
    }

    public EQTL[] read() throws IOException {
        return this.readExpectedSize(1000);
    }

    public ArrayList<EQTL> readList() throws IOException {
        ArrayList<EQTL> alEQTLS = new ArrayList<EQTL>();
        Iterator<EQTL> it = this.getEQtlIterator();
        while (it.hasNext()) {
            alEQTLS.add(it.next());
        }
        return alEQTLS;
    }

    public EQTL[] readExpectedSize(int expSize) throws IOException {
        ArrayList<EQTL> alEQTLS = new ArrayList<EQTL>(expSize);
        Iterator<EQTL> it = this.getEQtlIterator();
        while (it.hasNext()) {
            alEQTLS.add(it.next());
        }
        EQTL[] eqtls = new EQTL[alEQTLS.size()];
        return alEQTLS.toArray(eqtls);
    }

    public Iterator<EQTL> getEQtlIterator() throws IOException {
        this.open();
        return new EQtlIterator();
    }

    public ChrPosTreeMap<ArrayList<EQTL>> readQtlsAsTreeMap() throws IOException {
        ChrPosTreeMap<ArrayList<EQTL>> qtlTreeMap = new ChrPosTreeMap<ArrayList<EQTL>>();
        Iterator<EQTL> eqtlIterator = this.getEQtlIterator();
        while (eqtlIterator.hasNext()) {
            EQTL qtl = eqtlIterator.next();
            ArrayList<EQTL> thisPosQtls = qtlTreeMap.get(qtl.getRsChr().toString(), qtl.getRsChrPos());
            if (thisPosQtls == null) {
                thisPosQtls = new ArrayList(1);
                qtlTreeMap.put(qtl.getRsChr().toString(), qtl.getRsChrPos(), thisPosQtls);
            }
            thisPosQtls.add(qtl);
        }
        return qtlTreeMap;
    }

    private class EQtlIterator
    implements Iterator<EQTL> {
        private String[] elems;
        private final boolean fdrpresent;

        public EQtlIterator() throws IOException {
            this.elems = QTLTextFile.this.readLineElemsReturnReference(TextFile.tab);
            this.fdrpresent = this.elems.length > 21;
            this.elems = QTLTextFile.this.readLineElemsReturnReference(TextFile.tab);
        }

        @Override
        public boolean hasNext() {
            return this.elems != null;
        }

        @Override
        public EQTL next() {
            int i;
            String[] subelems;
            EQTL e = new EQTL();
            if (!this.elems[0].equals(nullStr)) {
                e.setPvalue(Double.parseDouble(this.elems[0]));
            }
            if (!this.elems[1].equals(nullStr)) {
                e.setRsName(this.elems[1]);
            }
            if (!this.elems[2].equals(nullStr)) {
                e.setRsChr(ChrAnnotation.parseChr(this.elems[2]));
            }
            if (!this.elems[3].equals(nullStr)) {
                e.setRsChrPos(Integer.parseInt(this.elems[3]));
            }
            if (!this.elems[4].equals(nullStr)) {
                e.setProbe(this.elems[4]);
            }
            if (!this.elems[5].equals(nullStr)) {
                e.setProbeChr(ChrAnnotation.parseChr(this.elems[5]));
            }
            if (!this.elems[6].equals(nullStr)) {
                e.setProbeChrPos(Integer.parseInt(this.elems[6]));
            }
            if (!this.elems[7].equals(nullStr)) {
                e.setType(this.elems[7]);
            }
            if (!this.elems[8].equals(nullStr)) {
                e.setAlleles(this.elems[8]);
            }
            if (!this.elems[9].equals(nullStr)) {
                e.setAlleleAssessed(this.elems[9]);
            }
            if (!this.elems[10].equals(nullStr)) {
                e.setZscore(Double.parseDouble(this.elems[10]));
            }
            if (!this.elems[11].equals(nullStr)) {
                e.setDatasets(separator.split(this.elems[11]));
            }
            if (!this.elems[12].equals(nullStr)) {
                subelems = separator.split(this.elems[12]);
                Double[] dsZScores = new Double[subelems.length];
                for (i = 0; i < subelems.length; ++i) {
                    try {
                        dsZScores[i] = Double.parseDouble(subelems[i]);
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        dsZScores[i] = Double.NaN;
                    }
                }
                e.setDatasetZScores(dsZScores);
            }
            if (!this.elems[13].equals(nullStr)) {
                String[] samples = this.elems[13].split(";");
                Integer[] sampleS = new Integer[samples.length];
                for (int i2 = 0; i2 < samples.length; ++i2) {
                    try {
                        sampleS[i2] = Integer.parseInt(samples[i2]);
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        sampleS[i2] = null;
                    }
                }
                e.setDatasetsSamples(sampleS);
            }
            if (!this.elems[14].equals(nullStr)) {
                subelems = separator.split(this.elems[14]);
                Double[] dsPmeans = new Double[subelems.length];
                for (i = 0; i < subelems.length; ++i) {
                    try {
                        dsPmeans[i] = Double.parseDouble(subelems[i]);
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        dsPmeans[i] = Double.NaN;
                    }
                }
                e.setProbeMeans(dsPmeans);
            }
            if (!this.elems[15].equals(nullStr)) {
                subelems = separator.split(this.elems[15]);
                Double[] dsPvars = new Double[subelems.length];
                for (i = 0; i < subelems.length; ++i) {
                    try {
                        dsPvars[i] = Double.parseDouble(subelems[i]);
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        dsPvars[i] = Double.NaN;
                    }
                }
                e.setProbeVariance(dsPvars);
            }
            if (!this.elems[16].equals(nullStr)) {
                e.setProbeHUGO(this.elems[16]);
            }
            if (!this.elems[17].equals(nullStr)) {
                subelems = separator.split(this.elems[17]);
                Double[] dsCorrs = new Double[subelems.length];
                for (i = 0; i < subelems.length; ++i) {
                    try {
                        dsCorrs[i] = Double.parseDouble(subelems[i]);
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        dsCorrs[i] = Double.NaN;
                    }
                }
                e.setCorrelations(dsCorrs);
            }
            if (!this.elems[18].equals(nullStr)) {
                e.setMetaBeta(this.elems[18]);
            }
            if (!this.elems[19].equals(nullStr)) {
                e.setBeta(this.elems[19]);
            }
            if (this.elems.length > 20 && !this.elems[20].equals(nullStr)) {
                e.setFC(this.elems[20]);
            }
            if (this.fdrpresent && this.elems.length > 21 && !this.elems[21].equals(nullStr)) {
                try {
                    e.setFDR(Double.parseDouble(this.elems[21]));
                }
                catch (NumberFormatException dsCorrs) {
                    // empty catch block
                }
            }
            try {
                this.elems = QTLTextFile.this.readLineElemsReturnReference(TextFile.tab);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

