/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper;

import java.util.ArrayList;
import umcg.genetica.io.trityper.EQTL;
import umcg.genetica.io.trityper.util.ChrAnnotation;

public class MinimalEQTL {
    private double pvalue = 1.0;
    private String rsName;
    private byte rsChr;
    private int rsChrPos;
    private String probe;
    private byte probeChr;
    private int probeChrPos;
    private double zScore = -9.0;
    private char assesedAllele = (char)32;

    public MinimalEQTL() {
    }

    public MinimalEQTL(String[] eQTLrowInformation) {
        this.pvalue = Double.parseDouble(eQTLrowInformation[0]);
        this.rsName = eQTLrowInformation[1];
        this.rsChr = ChrAnnotation.parseChr(eQTLrowInformation[2]);
        this.rsChrPos = Integer.parseInt(eQTLrowInformation[3]);
        this.probe = eQTLrowInformation[4];
        this.probeChr = ChrAnnotation.parseChr(eQTLrowInformation[5]);
        this.probeChrPos = Integer.parseInt(eQTLrowInformation[6]);
        this.zScore = Double.parseDouble(eQTLrowInformation[10]);
        this.assesedAllele = eQTLrowInformation[9].charAt(0);
    }

    public MinimalEQTL(double pValue, String rsName, byte rsChr, int rsChrPos, String probe, byte probeChr, int probeChrPos) {
        this.pvalue = pValue;
        this.rsName = rsName;
        this.rsChr = rsChr;
        this.rsChrPos = rsChrPos;
        this.probe = probe;
        this.probeChr = probeChr;
        this.probeChrPos = probeChrPos;
    }

    public MinimalEQTL(EQTL e) {
        this.pvalue = e.getPvalue();
        this.rsName = e.getRsName();
        this.rsChr = e.getRsChr();
        this.rsChrPos = e.getRsChrPos();
        this.probe = e.getProbe();
        this.probeChr = e.getProbeChr();
        this.probeChrPos = e.getProbeChrPos();
    }

    public double getPvalue() {
        return this.pvalue;
    }

    public void setPvalue(double pvalue) {
        this.pvalue = pvalue;
    }

    public String getRsName() {
        return this.rsName;
    }

    public void setRsName(String rsName) {
        this.rsName = rsName;
    }

    public Byte getRsChr() {
        return this.rsChr;
    }

    public void setRsChr(byte rsChr) {
        this.rsChr = rsChr;
    }

    public Integer getRsChrPos() {
        return this.rsChrPos;
    }

    public void setRsChrPos(int rsChrPos) {
        this.rsChrPos = rsChrPos;
    }

    public String getProbe() {
        return this.probe;
    }

    public void setProbe(String probe) {
        this.probe = probe;
    }

    public Byte getProbeChr() {
        return this.probeChr;
    }

    public void setProbeChr(byte probeChr) {
        this.probeChr = probeChr;
    }

    public Integer getProbeChrPos() {
        return this.probeChrPos;
    }

    public void setProbeChrPos(int probeChrPos) {
        this.probeChrPos = probeChrPos;
    }

    public Double getPvalueAbs() {
        return Math.abs(this.pvalue);
    }

    public double getzScore() {
        return this.zScore;
    }

    public void setzScore(double zScore) {
        this.zScore = zScore;
    }

    public char getAssesedAllele() {
        return this.assesedAllele;
    }

    public void setAssesedAllele(char assesedAllele) {
        this.assesedAllele = assesedAllele;
    }

    public static ArrayList<MinimalEQTL> convertArray(ArrayList<EQTL> qtlBuffer) {
        ArrayList<MinimalEQTL> minimalQtlBuffer = new ArrayList<MinimalEQTL>();
        for (EQTL e : qtlBuffer) {
            minimalQtlBuffer.add(new MinimalEQTL(e));
        }
        return minimalQtlBuffer;
    }

    public String toString() {
        char nullstr = '-';
        char tabStr = '\t';
        MinimalEQTL e = this;
        StringBuilder out = new StringBuilder();
        out.append(e.getPvalue());
        out.append(tabStr);
        out.append(e.getRsName());
        out.append(tabStr);
        out.append(e.getRsChr());
        out.append(tabStr);
        out.append(e.getRsChrPos());
        out.append(tabStr);
        out.append(e.getProbe());
        out.append(tabStr);
        out.append(e.getProbeChr());
        out.append(tabStr);
        out.append(e.getProbeChrPos());
        out.append(tabStr);
        out.append(nullstr);
        out.append(tabStr);
        out.append(nullstr);
        out.append(tabStr);
        out.append(nullstr);
        out.append(tabStr);
        out.append(nullstr);
        out.append(tabStr);
        out.append(nullstr);
        out.append(tabStr);
        out.append(nullstr);
        out.append(tabStr);
        out.append(nullstr);
        out.append(tabStr);
        out.append(nullstr);
        out.append(tabStr);
        out.append(nullstr);
        out.append(tabStr);
        out.append(nullstr);
        out.append(tabStr);
        out.append(nullstr);
        out.append(tabStr);
        out.append(nullstr);
        out.append(tabStr);
        out.append(nullstr);
        out.append(tabStr);
        out.append(nullstr);
        out.append(tabStr);
        out.append(nullstr);
        return out.toString();
    }
}

