/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper;

public class EQTL
implements Comparable<EQTL> {
    private Double pvalue = 1.0;
    private Double pvalueAbs = 1.0;
    private String rsName;
    private Byte rsChr;
    private Integer rsChrPos;
    private String probe;
    private Byte probeChr;
    private Integer probeChrPos;
    private String eQTLType;
    private String alleles;
    private String alleleAssessed;
    private String[] datasets;
    private Double zscore;
    private Double zscoreAbs;
    private Double[] datasetZScores;
    private Integer[] datasetsSamples;
    private Double[] probeMeans;
    private Double[] probeVariance;
    private String probeHUGO;
    private Double[] correlations;
    private Double FDR;
    private String metabeta;
    private String beta;
    private String fc;
    private boolean useAbsoluteZScore = false;

    public Double getPvalue() {
        return this.pvalue;
    }

    public void setPvalue(double pvalue) {
        this.pvalue = pvalue;
    }

    public String getRsName() {
        return this.rsName;
    }

    public void setRsName(String rsName) {
        this.rsName = rsName;
    }

    public Byte getRsChr() {
        return this.rsChr;
    }

    public void setRsChr(byte rsChr) {
        this.rsChr = rsChr;
    }

    public Integer getRsChrPos() {
        return this.rsChrPos;
    }

    public void setRsChrPos(int rsChrPos) {
        this.rsChrPos = rsChrPos;
    }

    public String getProbe() {
        return this.probe;
    }

    public void setProbe(String probe) {
        this.probe = probe;
    }

    public Byte getProbeChr() {
        return this.probeChr;
    }

    public void setProbeChr(byte probeChr) {
        this.probeChr = probeChr;
    }

    public Integer getProbeChrPos() {
        return this.probeChrPos;
    }

    public void setProbeChrPos(int probeChrPos) {
        this.probeChrPos = probeChrPos;
    }

    public String getType() {
        return this.eQTLType;
    }

    public void setType(String type) {
        this.eQTLType = type;
    }

    public String getAlleles() {
        return this.alleles;
    }

    public void setAlleles(String alleles) {
        this.alleles = alleles;
    }

    public String getAlleleAssessed() {
        return this.alleleAssessed;
    }

    public void setAlleleAssessed(String alleleAssessed) {
        this.alleleAssessed = alleleAssessed;
    }

    public String[] getDatasets() {
        return this.datasets;
    }

    public void setDatasets(String[] datasets) {
        this.datasets = datasets;
    }

    public double getZscore() {
        return this.zscore;
    }

    public void setZscore(double zscore) {
        this.zscore = zscore;
    }

    public Double[] getDatasetZScores() {
        return this.datasetZScores;
    }

    public void setDatasetZScores(Double[] datasetZScores) {
        this.datasetZScores = datasetZScores;
    }

    public Integer[] getDatasetsSamples() {
        return this.datasetsSamples;
    }

    public void setDatasetsSamples(Integer[] datasetsSamples) {
        this.datasetsSamples = datasetsSamples;
    }

    public Double[] getProbeMeans() {
        return this.probeMeans;
    }

    public void setProbeMeans(Double[] probeMeans) {
        this.probeMeans = probeMeans;
    }

    public Double[] getProbeVariance() {
        return this.probeVariance;
    }

    public void setProbeVariance(Double[] probeVariance) {
        this.probeVariance = probeVariance;
    }

    public String getProbeHUGO() {
        return this.probeHUGO;
    }

    public void setProbeHUGO(String probeHUGO) {
        this.probeHUGO = probeHUGO;
    }

    public Double[] getCorrelations() {
        return this.correlations;
    }

    public void setCorrelations(Double[] correlations) {
        this.correlations = correlations;
    }

    public void setFDR(double d) {
        this.FDR = d;
    }

    public Double getFDR() {
        return this.FDR;
    }

    public String compare(EQTL test) {
        boolean identical = true;
        String reason = "";
        if (!test.getProbe().equals(this.probe)) {
            reason = reason + "Diff probes:\t" + test.getProbe() + "\t" + this.getProbe() + "\t";
            identical = false;
        } else if (this.probeChr == null || this.probeChrPos == null || test.getProbeChr() == null || test.getProbeChrPos() != null) {
            // empty if block
        }
        if (!test.getRsName().equals(this.rsName)) {
            reason = reason + "Diff rsName:\t" + test.getRsName() + "\t" + this.getRsName() + "\t";
            identical = false;
        } else if (this.rsChr == null || this.rsChrPos == null || test.getRsChrPos() == null || test.getRsChr() != null) {
            // empty if block
        }
        if (test.getPvalue() != this.pvalue) {
            reason = reason + "Diff pval:\t" + test.getPvalue() + "\t" + this.getPvalue() + "\t";
            identical = false;
        } else {
            reason = reason + "";
        }
        if (test.getZscore() != this.zscore.doubleValue() && Math.abs(test.getZscore()) - Math.abs(this.zscore) > 1.0E-4 && test.getAlleleAssessed().equals(this.alleleAssessed)) {
            reason = reason + "Diff zscore:\t" + test.getZscore() + "\t" + this.getZscore() + "\t";
            identical = false;
        }
        if (!identical) {
            return reason;
        }
        return null;
    }

    public int hashCode() {
        int hash = 1;
        hash += this.probe.hashCode();
        return hash += this.rsName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EQTL other = (EQTL)obj;
        if (this.rsName == null ? other.rsName != null : !this.rsName.equals(other.rsName)) {
            return false;
        }
        return !(this.probe == null ? other.probe != null : !this.probe.equals(other.probe));
    }

    public String toString() {
        String sepStr = ";";
        String nullstr = "-";
        char tabStr = '\t';
        EQTL e = this;
        StringBuilder out = new StringBuilder();
        if (this.useAbsoluteZScore) {
            if (this.pvalueAbs == null) {
                out.append(nullstr);
                out.append(tabStr);
            } else {
                out.append(e.getPvalueAbs());
                out.append(tabStr);
            }
        } else if (this.pvalue == null) {
            out.append(nullstr);
            out.append(tabStr);
        } else {
            out.append(e.getPvalue());
            out.append(tabStr);
        }
        if (this.rsName == null) {
            out.append(nullstr);
            out.append(tabStr);
        } else {
            out.append(e.getRsName());
            out.append(tabStr);
        }
        if (this.rsChr == null) {
            out.append(nullstr);
            out.append(tabStr);
        } else {
            out.append(e.getRsChr());
            out.append(tabStr);
        }
        if (this.rsChrPos == null) {
            out.append(nullstr);
            out.append(tabStr);
        } else {
            out.append(e.getRsChrPos());
            out.append(tabStr);
        }
        if (this.probe == null) {
            out.append(nullstr);
            out.append(tabStr);
        } else {
            out.append(e.getProbe());
            out.append(tabStr);
        }
        if (this.probeChr == null) {
            out.append(nullstr);
            out.append(tabStr);
        } else {
            out.append(e.getProbeChr());
            out.append(tabStr);
        }
        if (this.probeChrPos == null) {
            out.append(nullstr);
            out.append(tabStr);
        } else {
            out.append(e.getProbeChrPos());
            out.append(tabStr);
        }
        if (this.eQTLType == null) {
            out.append(nullstr);
            out.append(tabStr);
        } else {
            out.append(e.getType());
            out.append(tabStr);
        }
        if (this.alleles == null) {
            out.append(nullstr);
            out.append(tabStr);
        } else {
            out.append(e.getAlleles());
            out.append(tabStr);
        }
        if (this.alleleAssessed == null) {
            out.append(nullstr);
            out.append(tabStr);
        } else {
            out.append(e.getAlleleAssessed());
            out.append(tabStr);
        }
        if (this.useAbsoluteZScore) {
            if (this.zscoreAbs == null) {
                out.append(nullstr);
                out.append(tabStr);
            } else {
                out.append(e.getZscoreAbs());
                out.append(tabStr);
            }
        } else if (this.zscore == null) {
            out.append(nullstr);
            out.append(tabStr);
        } else {
            out.append(e.getZscore());
            out.append(tabStr);
        }
        String[] ds = e.getDatasets();
        Double[] probemeans = e.getProbeMeans();
        StringBuilder outcorrs = new StringBuilder();
        StringBuilder outzscores = new StringBuilder();
        StringBuilder outsamples = new StringBuilder();
        StringBuilder outmeans = new StringBuilder();
        StringBuilder outvars = new StringBuilder();
        if (ds == null) {
            out.append(nullstr);
            out.append(tabStr);
            out.append(nullstr);
            out.append(tabStr);
            out.append(nullstr);
            out.append(tabStr);
            out.append(nullstr);
            out.append(tabStr);
            out.append(nullstr);
            out.append(tabStr);
            out.append(nullstr);
            out.append(tabStr);
            out.append(nullstr);
        } else {
            for (int d = 0; d < ds.length; ++d) {
                if (d == 0) {
                    if (this.datasets[d] == null) {
                        out.append(nullstr);
                    } else {
                        out.append(ds[d]);
                    }
                    if (this.correlations == null || this.correlations[d] == null || this.correlations[d].isNaN()) {
                        outcorrs.append(nullstr);
                    } else {
                        outcorrs.append(this.correlations[d]);
                    }
                    if (this.datasetZScores == null || this.datasetZScores[d] == null || this.datasetZScores[d].isNaN()) {
                        outzscores.append(nullstr);
                    } else {
                        outzscores.append(this.datasetZScores[d]);
                    }
                    if (this.datasetsSamples == null || this.datasetsSamples[d] == null) {
                        outsamples.append(nullstr);
                    } else {
                        outsamples.append(this.datasetsSamples[d]);
                    }
                    if (this.probeMeans == null || this.probeMeans[d] == null || this.probeMeans[d].isNaN()) {
                        outmeans.append(nullstr);
                    } else {
                        outmeans.append(probemeans[d]);
                    }
                    if (this.probeVariance == null || this.probeVariance[d] == null || this.probeVariance[d].isNaN()) {
                        outvars.append(nullstr);
                        continue;
                    }
                    outvars.append(this.probeVariance[d]);
                    continue;
                }
                if (this.datasets[d] == null) {
                    out.append(sepStr).append(nullstr);
                } else {
                    out.append(sepStr).append(ds[d]);
                }
                if (this.correlations == null || this.correlations[d] == null || this.correlations[d].isNaN()) {
                    outcorrs.append(sepStr).append(nullstr);
                } else {
                    outcorrs.append(sepStr).append(this.correlations[d]);
                }
                if (this.datasetZScores == null || this.datasetZScores[d] == null || this.datasetZScores[d].isNaN()) {
                    outzscores.append(sepStr).append(nullstr);
                } else {
                    outzscores.append(sepStr).append(this.datasetZScores[d]);
                }
                if (this.datasetsSamples == null || this.datasetsSamples[d] == null) {
                    outsamples.append(sepStr).append(nullstr);
                } else {
                    outsamples.append(sepStr).append(this.datasetsSamples[d]);
                }
                if (this.probeMeans == null || this.probeMeans[d] == null || this.probeMeans[d].isNaN()) {
                    outmeans.append(sepStr).append(nullstr);
                } else {
                    outmeans.append(sepStr).append(probemeans[d]);
                }
                if (this.probeVariance == null || this.probeVariance[d] == null || this.probeVariance[d].isNaN()) {
                    outvars.append(sepStr).append(nullstr);
                    continue;
                }
                outvars.append(sepStr).append(this.probeVariance[d]);
            }
            out.append(tabStr);
            out.append(outzscores.toString());
            out.append(tabStr);
            out.append(outsamples.toString());
            out.append(tabStr);
            out.append(outmeans.toString());
            out.append(tabStr);
            out.append(outvars.toString());
            out.append(tabStr);
            out.append(e.getProbeHUGO());
            out.append(tabStr);
            out.append(outcorrs.toString());
            out.append(tabStr);
            if (this.metabeta == null) {
                out.append(nullstr);
            } else {
                out.append(e.getMetaBeta());
            }
            out.append(tabStr);
            if (this.beta == null) {
                out.append(nullstr);
            } else {
                out.append(e.getBeta());
            }
            out.append(tabStr);
            if (this.fc == null) {
                out.append(nullstr);
            } else {
                out.append(e.getFC());
            }
            out.append(tabStr);
            if (this.FDR == null) {
                out.append(nullstr);
            } else {
                out.append(e.getFDR());
            }
        }
        return out.toString();
    }

    @Override
    public int compareTo(EQTL o) {
        if (this.useAbsoluteZScore) {
            if (this.pvalueAbs.doubleValue() == o.pvalueAbs.doubleValue()) {
                if (this.zscoreAbs.doubleValue() == o.zscoreAbs.doubleValue()) {
                    if (this.rsName.compareTo(o.rsName) == 0) {
                        return this.probe.compareTo(o.probe);
                    }
                    return this.rsName.compareTo(o.rsName);
                }
                if (this.zscoreAbs < o.zscoreAbs) {
                    return 1;
                }
                return -1;
            }
            if (this.pvalueAbs > o.pvalueAbs) {
                return 1;
            }
            return -1;
        }
        if (this.pvalue.doubleValue() == o.pvalue.doubleValue()) {
            if (Math.abs(this.zscore) == Math.abs(o.zscore)) {
                if (this.rsName.compareTo(o.rsName) == 0) {
                    return this.probe.compareTo(o.probe);
                }
                return this.rsName.compareTo(o.rsName);
            }
            if (Math.abs(this.zscore) < Math.abs(o.zscore)) {
                return 1;
            }
            return -1;
        }
        if (this.pvalue > o.pvalue) {
            return 1;
        }
        return -1;
    }

    public int compareToVerbose(EQTL o) {
        if (this.useAbsoluteZScore) {
            if (this.pvalueAbs.doubleValue() == o.pvalueAbs.doubleValue()) {
                if (this.zscoreAbs.doubleValue() == o.zscoreAbs.doubleValue()) {
                    if (this.rsName.compareTo(o.rsName) == 0) {
                        return this.probe.compareTo(o.probe);
                    }
                    return this.rsName.compareTo(o.rsName);
                }
                if (this.zscoreAbs < o.zscoreAbs) {
                    return 1;
                }
                return -1;
            }
            if (this.pvalueAbs > o.pvalueAbs) {
                return 1;
            }
            return -1;
        }
        if (this.pvalue.doubleValue() == o.pvalue.doubleValue()) {
            System.out.println("p value identical: " + this.pvalue + "\t" + o.pvalue);
            if (Math.abs(this.zscore) == Math.abs(o.zscore)) {
                System.out.println("Z value identical: " + this.zscore + "\t" + o.zscore);
                if (this.rsName.compareTo(o.rsName) == 0) {
                    System.out.println("rs value identical: " + this.rsName + "\t" + o.rsName);
                    System.out.println("probe: " + this.probe + "\t" + o.probe + "\t" + this.probe.compareTo(o.probe));
                    return this.probe.compareTo(o.probe);
                }
                System.out.println("probe: " + this.rsName + "\t" + o.rsName + "\t" + this.rsName.compareTo(o.rsName));
                return this.rsName.compareTo(o.rsName);
            }
            if (Math.abs(this.zscore) < Math.abs(o.zscore)) {
                return 1;
            }
            return -1;
        }
        if (this.pvalue > o.pvalue) {
            return 1;
        }
        return -1;
    }

    public boolean equals(EQTL o) {
        if (this.useAbsoluteZScore) {
            if (this.pvalueAbs.doubleValue() == o.pvalueAbs.doubleValue()) {
                if (this.zscoreAbs.doubleValue() == o.zscoreAbs.doubleValue()) {
                    if (this.probe.equals(o.probe)) {
                        return this.rsName.equals(o.rsName);
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
        if (this.pvalue.doubleValue() == o.pvalue.doubleValue()) {
            if (Math.abs(this.zscore) == Math.abs(o.zscore)) {
                if (this.probe.equals(o.probe)) {
                    return this.rsName.equals(o.rsName);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public boolean sameQTL(EQTL o) {
        return this.zscore.equals(o.zscore) && this.probe.equals(o.probe) && this.rsName.equals(o.rsName) && this.beta.equals(o.beta) && this.FDR.equals(o.FDR);
    }

    public void setMetaBeta(String string) {
        this.metabeta = string;
    }

    public void setBeta(String string) {
        this.beta = string;
    }

    public void setFC(String string) {
        this.fc = string;
    }

    public String getMetaBeta() {
        return this.metabeta;
    }

    public String getBeta() {
        return this.beta;
    }

    public String getFC() {
        return this.fc;
    }

    public void clearData() {
        this.rsName = null;
        this.rsChr = null;
        this.rsChrPos = null;
        this.probe = null;
        this.probeChr = null;
        this.probeChrPos = null;
        this.eQTLType = null;
        this.alleles = null;
        this.alleleAssessed = null;
        this.datasets = null;
        this.zscore = null;
        this.datasetZScores = null;
        this.datasetsSamples = null;
        this.probeMeans = null;
        this.probeVariance = null;
        this.probeHUGO = null;
        this.correlations = null;
        this.FDR = null;
        this.metabeta = null;
        this.beta = null;
        this.fc = null;
    }

    public void setZscoreAbs(double zScoreAbs) {
        this.zscoreAbs = zScoreAbs;
    }

    public void setPvalueAbs(double pValueOverallAbs) {
        this.pvalueAbs = pValueOverallAbs;
    }

    public Double getZscoreAbs() {
        return this.zscoreAbs;
    }

    public Double getPvalueAbs() {
        return this.pvalueAbs;
    }

    public void setUseAbsoluteZScore() {
        this.useAbsoluteZScore = true;
    }

    public boolean getUseAbsoluteZScore() {
        return this.useAbsoluteZScore;
    }

    public String getDiff(EQTL o) {
        return "z: " + this.zscore + " - " + o.zscore + "\t" + "probe: " + this.probe + " - " + o.probe + "\t" + "rsName: " + this.rsName + " - " + o.rsName + "\t" + "FDR: " + this.FDR + " - " + o.FDR + "\t" + "Beta: " + this.beta + " - " + o.beta + "\t";
    }
}

