/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.trityper.WGAFileMatrixGenotype;
import umcg.genetica.io.trityper.WGAFileMatrixImputedDosage;
import umcg.genetica.math.matrix2.DoubleMatrixDataset;
import umcg.genetica.util.RankArray;

public class ConvertDoubleMatrixDataToTriTyper {
    private static final Pattern SPLIT_ON_TAB = Pattern.compile("\t");

    public static void main(String[] args) throws IOException {
        GnuParser parser = new GnuParser();
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Location of the input file. Needs to be a tab seperated file with samples on the columns and traits on the rows.");
        OptionBuilder.withLongOpt((String)"dataMatrix");
        Option datMatrix = OptionBuilder.create((String)"d");
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Location of the mapping file describing the chromosomal locations of the traits.");
        OptionBuilder.withLongOpt((String)"mappingFile");
        Option mapFile = OptionBuilder.create((String)"m");
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Location and name of the output TriTyper folder.");
        OptionBuilder.withLongOpt((String)"OutputFile");
        Option folderOut = OptionBuilder.create((String)"o");
        OptionBuilder.withArgName((String)"boolean");
        OptionBuilder.withDescription((String)"If set first rank the input data, before scaling.");
        Option ranking = OptionBuilder.create((String)"r");
        OptionBuilder.withArgName((String)"boolean");
        OptionBuilder.withDescription((String)"If set first remove full non-numeric rows.");
        Option removeNan = OptionBuilder.create((String)"R");
        options.addOption(folderOut).addOption(datMatrix).addOption(mapFile).addOption(ranking).addOption(removeNan);
        String dataMatrix = null;
        String outputFolder = null;
        String mappingFile = null;
        boolean rank = false;
        boolean removeNanRow = false;
        try {
            CommandLine cmd = parser.parse(options, args);
            HelpFormatter formatter = new HelpFormatter();
            if (cmd.hasOption("OutputFile") || cmd.hasOption("o")) {
                outputFolder = cmd.getOptionValue("OutputFile");
            } else {
                System.out.println("Missing necesarray information");
                formatter.printHelp("ant", options);
                System.exit(0);
            }
            if (cmd.hasOption("dataMatrix") || cmd.hasOption("d")) {
                dataMatrix = cmd.getOptionValue("dataMatrix");
            } else {
                System.out.println("Missing necesarray information");
                formatter.printHelp("ant", options);
                System.exit(0);
            }
            if (cmd.hasOption("mappingFile") || cmd.hasOption("m")) {
                mappingFile = cmd.getOptionValue("mappingFile");
            }
            rank = cmd.hasOption("r");
            removeNanRow = cmd.hasOption("R");
        }
        catch (ParseException ex) {
            Logger.getLogger(ConvertDoubleMatrixDataToTriTyper.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (!new File(outputFolder).exists()) {
            Gpio.createDir(outputFolder);
        } else if (!new File(outputFolder).isDirectory()) {
            System.out.println("Error file is already there but not a directory!");
            System.exit(0);
        }
        HashSet<String> hashCpGSites = new HashSet<String>();
        try {
            String string;
            System.out.println("Writing SNPMappings.txt to file:");
            int nrSites = 0;
            BufferedReader in = new BufferedReader(new FileReader(new File(mappingFile)));
            BufferedWriter outSNPMappings = new BufferedWriter(new FileWriter(new File(outputFolder + "/SNPMappings.txt")));
            in.readLine();
            while ((string = in.readLine()) != null) {
                String[] data = SPLIT_ON_TAB.split(string);
                hashCpGSites.add(data[1]);
                outSNPMappings.write(data[3] + '\t' + data[4] + '\t' + data[1] + '\n');
                ++nrSites;
            }
            System.out.println("Number of sites in mapping file:\t" + nrSites);
            outSNPMappings.close();
        }
        catch (Exception e) {
            System.out.println("Error:\t" + e.getMessage());
            e.printStackTrace();
            System.exit(0);
        }
        DoubleMatrixDataset<String, String> dataset = null;
        try {
            dataset = DoubleMatrixDataset.loadSubsetOfTextDoubleData(dataMatrix, "\t", hashCpGSites, null);
        }
        catch (IOException ex) {
            Logger.getLogger(ConvertDoubleMatrixDataToTriTyper.class.getName()).log(Level.SEVERE, null, ex);
            System.exit(0);
        }
        if (dataset != null && !dataset.getHashCols().isEmpty() && !dataset.getHashRows().isEmpty()) {
            if (rank) {
                dataset.setMatrix(ConvertDoubleMatrixDataToTriTyper.rankRows(dataset.getMatrix()));
            }
            dataset.setMatrix(ConvertDoubleMatrixDataToTriTyper.rescaleValue(dataset.getMatrix(), 200.0));
            try {
                System.out.println("\nWriting SNPs.txt to file:");
                BufferedWriter out = new BufferedWriter(new FileWriter(outputFolder + "/SNPs.txt"));
                for (String string : dataset.getRowObjects()) {
                    out.write(string + "\n");
                }
                out.close();
            }
            catch (Exception e) {
                System.out.println("Error:\t" + e.getMessage());
                e.printStackTrace();
                System.exit(0);
            }
            try {
                System.out.println("\nWriting Individuals.txt and Phenotype.txt to file:");
                BufferedWriter outIndNew = new BufferedWriter(new FileWriter(outputFolder + "/Individuals.txt"));
                BufferedWriter outPhenoNew = new BufferedWriter(new FileWriter(outputFolder + "/PhenotypeInformation.txt"));
                for (String ind : dataset.getColObjects()) {
                    outIndNew.write(ind + '\n');
                    outPhenoNew.write(ind + "\tcontrol\tinclude\tmale\n");
                }
                outIndNew.close();
                outPhenoNew.close();
            }
            catch (Exception e) {
                System.out.println("Error:\t" + e.getMessage());
                e.printStackTrace();
                System.exit(0);
            }
            int nrSNPs = dataset.rows();
            int nrSamples = dataset.columns();
            WGAFileMatrixGenotype wGAFileMatrixGenotype = new WGAFileMatrixGenotype(nrSNPs, nrSamples, new File(outputFolder + "/GenotypeMatrix.dat"), false);
            WGAFileMatrixImputedDosage fileMatrixDosage = new WGAFileMatrixImputedDosage(nrSNPs, nrSamples, new File(outputFolder + "/ImputedDosageMatrix.dat"), false);
            byte[] alleles = new byte[]{84, 67};
            for (int snp = 0; snp < nrSNPs; ++snp) {
                DoubleMatrix1D snpRow = dataset.getMatrix().viewRow(snp);
                byte[] allele1 = new byte[nrSamples];
                byte[] allele2 = new byte[nrSamples];
                byte[] dosageValues = new byte[nrSamples];
                for (int ind = 0; ind < nrSamples; ++ind) {
                    byte value;
                    if (snpRow.get(ind) > 100.0) {
                        allele1[ind] = alleles[1];
                        allele2[ind] = alleles[1];
                    } else {
                        allele1[ind] = alleles[0];
                        allele2[ind] = alleles[0];
                    }
                    int dosageInt = (int)Math.round(snpRow.get(ind));
                    dosageValues[ind] = value = (byte)(-128 + dosageInt);
                }
                wGAFileMatrixGenotype.setAllele1(snp, 0, allele1);
                wGAFileMatrixGenotype.setAllele2(snp, 0, allele2);
                fileMatrixDosage.setDosage(snp, 0, dosageValues);
            }
            wGAFileMatrixGenotype.close();
            fileMatrixDosage.close();
        }
        System.out.println("Finished.");
    }

    public static DoubleMatrix2D rescaleValue(DoubleMatrix2D matrix, Double multiplier) {
        if (multiplier != null) {
            for (int p = 0; p < matrix.rows(); ++p) {
                double min = matrix.viewRow(p).getMinLocation()[0];
                double denominator = (matrix.viewRow(p).getMaxLocation()[0] - min) * (1.0 / multiplier);
                for (int s = 0; s < matrix.columns(); ++s) {
                    matrix.setQuick(p, s, (matrix.getQuick(p, s) - min) / denominator);
                }
            }
        } else {
            for (int p = 0; p < matrix.rows(); ++p) {
                double min = matrix.viewRow(p).getMinLocation()[0];
                double denominator = matrix.viewRow(p).getMaxLocation()[0] - min;
                for (int s = 0; s < matrix.columns(); ++s) {
                    matrix.setQuick(p, s, (matrix.getQuick(p, s) - min) / denominator);
                }
            }
        }
        return matrix;
    }

    public static DoubleMatrix2D rankRows(DoubleMatrix2D matrix) {
        RankArray rda = new RankArray();
        for (int p = 0; p < matrix.rows(); ++p) {
            double[] rankedValues = rda.rank(matrix.viewRow(p).toArray(), true);
            for (int s = 0; s < matrix.columns(); ++s) {
                matrix.setQuick(p, s, rankedValues[s]);
            }
        }
        return matrix;
    }
}

