/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.pileup;

import gnu.trove.map.hash.TObjectDoubleHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import org.molgenis.genotype.Allele;
import umcg.genetica.io.pileup.PileupParseException;

public class PileupEntry {
    private final String chr;
    private final int pos;
    private final Allele refAllele;
    private final int readDepth;
    private final TObjectIntHashMap<Allele> alleleCounts;
    private final TObjectDoubleHashMap<Allele> alleleAverageQualities;
    private final int minimumBaseQuality;

    public PileupEntry(String chr, int pos, Allele refAllele, int readDepth, String basesString, int minimumBaseQuality) throws PileupParseException {
        this(chr, pos, refAllele, readDepth, basesString, null, minimumBaseQuality);
    }

    public PileupEntry(String chr, int pos, Allele refAllele, int readDepth, String basesString, String basesQualityString, int minimumBaseQuality) throws PileupParseException {
        this.chr = chr;
        this.pos = pos;
        this.refAllele = refAllele;
        this.readDepth = readDepth;
        this.alleleCounts = new TObjectIntHashMap();
        this.alleleAverageQualities = new TObjectDoubleHashMap();
        this.minimumBaseQuality = minimumBaseQuality;
        this.alleleCounts.put((Object)Allele.A, 0);
        this.alleleCounts.put((Object)Allele.C, 0);
        this.alleleCounts.put((Object)Allele.G, 0);
        this.alleleCounts.put((Object)Allele.T, 0);
        this.alleleAverageQualities.put((Object)Allele.A, 0.0);
        this.alleleAverageQualities.put((Object)Allele.C, 0.0);
        this.alleleAverageQualities.put((Object)Allele.G, 0.0);
        this.alleleAverageQualities.put((Object)Allele.T, 0.0);
        if (!this.alleleCounts.containsKey((Object)refAllele)) {
            throw new PileupParseException("Error parsing pipeup entry");
        }
        int[] basesQuality = basesQualityString == null ? null : this.parseBasesQualityString(basesQualityString);
        this.parseBasesString(basesString, basesQuality);
    }

    private void parseBasesString(String basesString, int[] basesQualities) throws PileupParseException {
        char[] basesChars = basesString.toCharArray();
        int basesQualityI = 0;
        block8: for (int i = 0; i < basesChars.length; ++i) {
            switch (basesChars[i]) {
                case ',': 
                case '.': {
                    if (basesQualities == null || basesQualities[basesQualityI] >= this.minimumBaseQuality) {
                        this.alleleCounts.increment((Object)this.refAllele);
                        if (basesQualities != null) {
                            this.alleleAverageQualities.adjustValue((Object)this.refAllele, (double)basesQualities[basesQualityI]);
                        }
                    }
                    ++basesQualityI;
                    continue block8;
                }
                case '+': 
                case '-': {
                    StringBuilder indelSizeString = new StringBuilder();
                    ++i;
                    while (Character.isDigit(basesChars[i])) {
                        indelSizeString.append(basesChars[i]);
                        ++i;
                    }
                    i += Integer.valueOf(indelSizeString.toString()) - 1;
                    continue block8;
                }
                case '^': {
                    ++i;
                    continue block8;
                }
                case '$': 
                case '*': 
                case '<': 
                case '>': 
                case 'N': 
                case 'n': {
                    continue block8;
                }
                case 'a': 
                case 'c': 
                case 'g': 
                case 't': {
                    basesChars[i] = Character.toUpperCase(basesChars[i]);
                }
                case 'A': 
                case 'C': 
                case 'G': 
                case 'T': {
                    if (basesQualities == null || basesQualities[basesQualityI] >= this.minimumBaseQuality) {
                        Allele allele = Allele.create((char)basesChars[i]);
                        this.alleleCounts.increment((Object)allele);
                        if (basesQualities != null) {
                            this.alleleAverageQualities.adjustValue((Object)allele, (double)basesQualities[basesQualityI]);
                        }
                    }
                    ++basesQualityI;
                    continue block8;
                }
                default: {
                    throw new PileupParseException("Unexpected char in pileup bases string: " + basesChars[i] + " from : " + basesString);
                }
            }
        }
        for (Allele allele : this.alleleAverageQualities.keySet()) {
            if (basesQualities == null) {
                this.alleleAverageQualities.put((Object)allele, Double.NaN);
                continue;
            }
            this.alleleAverageQualities.put((Object)allele, this.alleleAverageQualities.get((Object)allele) / (double)this.alleleCounts.get((Object)allele));
        }
    }

    public String getChr() {
        return this.chr;
    }

    public int getPos() {
        return this.pos;
    }

    public Allele getRefAllele() {
        return this.refAllele;
    }

    public int getReadDepth() {
        return this.readDepth;
    }

    public TObjectIntHashMap<Allele> getAlleleCounts() {
        return this.alleleCounts;
    }

    public int getAlleleCount(Allele allele) {
        return this.alleleCounts.get((Object)allele);
    }

    public TObjectDoubleHashMap<Allele> getAlleleAverageQualities() {
        return this.alleleAverageQualities;
    }

    public double getAlleleAverageQuality(Allele allele) {
        return this.alleleAverageQualities.get((Object)allele);
    }

    public int getMinimumBaseQuality() {
        return this.minimumBaseQuality;
    }

    private int[] parseBasesQualityString(String basesQualityString) {
        char[] basesQualityChars = basesQualityString.toCharArray();
        int[] basesQuality = new int[basesQualityChars.length];
        for (int i = 0; i < basesQualityChars.length; ++i) {
            basesQuality[i] = basesQualityChars[i] - 33;
        }
        return basesQuality;
    }
}

