/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.gwascatalog;

import java.util.ArrayList;
import java.util.HashSet;
import umcg.genetica.io.gwascatalog.GWASLocus;
import umcg.genetica.io.gwascatalog.GWASPublication;
import umcg.genetica.io.gwascatalog.GWASSNP;

public class GWASTrait {
    int id;
    String name;
    String cleanName;
    HashSet<GWASLocus> loci = new HashSet();
    HashSet<GWASPublication> publishedIn = new HashSet();
    HashSet<GWASSNP> snps = new HashSet();
    HashSet<GWASSNP> strongestSNPAssociation = new HashSet();
    GWASSNP[] snpArray = null;
    HashSet<String> reportedGenes = new HashSet();
    HashSet<String> mappedGenes = new HashSet();

    public String getName() {
        return this.name;
    }

    public String getCleanName() {
        return this.cleanName;
    }

    public GWASSNP[] getSNPs() {
        if (this.snpArray == null) {
            this.snpArray = this.snps.toArray(new GWASSNP[0]);
        }
        return this.snpArray;
    }

    public GWASSNP[] getSNPs(double pThreshold) {
        if (this.snpArray == null) {
            this.snpArray = this.snps.toArray(new GWASSNP[0]);
        }
        ArrayList<GWASSNP> limited = new ArrayList<GWASSNP>();
        for (GWASSNP snp : this.snpArray) {
            Double p = snp.getPValueAssociatedWithTrait(this);
            if (p == null || !(p <= pThreshold)) continue;
            limited.add(snp);
        }
        return limited.toArray(new GWASSNP[0]);
    }

    public HashSet<String> getReportedGenes() {
        return this.reportedGenes;
    }

    public void setReportedGenes(HashSet<String> reportedGenes) {
        this.reportedGenes = reportedGenes;
    }

    public void appendReportedGenes(HashSet<String> reportedGenes) {
        this.reportedGenes.addAll(reportedGenes);
    }

    public HashSet<String> getMappedGenes() {
        return this.mappedGenes;
    }

    public void setMappedGenes(HashSet<String> mappedGenes) {
        this.mappedGenes = mappedGenes;
    }

    public void appendMappedGenes(HashSet<String> mappedGenes) {
        this.mappedGenes.addAll(this.reportedGenes);
    }

    public String toString() {
        return this.name;
    }

    public void addTopSNP(GWASSNP gwasTopSNPObj) {
        this.strongestSNPAssociation.add(gwasTopSNPObj);
        this.snps.add(gwasTopSNPObj);
    }

    public GWASSNP[] getTopAssociations() {
        return this.strongestSNPAssociation.toArray(new GWASSNP[0]);
    }

    public boolean isTopAssociation(GWASSNP snp) {
        return this.strongestSNPAssociation.contains(snp);
    }
}

