/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.gtf;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import umcg.genetica.io.gtf.GffElement;
import umcg.genetica.io.gtf.GffReaderInterface;

public class GffElementIterator
implements Iterator<GffElement> {
    private final GffReaderInterface gffReader;
    private boolean atNext = false;
    private boolean atEnd = false;
    private GffElement next;

    public GffElementIterator(GffReaderInterface gffReader) {
        this.gffReader = gffReader;
    }

    @Override
    public boolean hasNext() {
        if (this.atEnd) {
            return false;
        }
        if (this.atNext) {
            return true;
        }
        try {
            this.next = this.gffReader.nextElement();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (this.next == null) {
            this.atEnd = true;
            try {
                this.gffReader.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return false;
        }
        this.atNext = true;
        return true;
    }

    @Override
    public GffElement next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.atNext = false;
        return this.next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported ever.");
    }
}

