/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.gtf;

import java.util.Collections;
import java.util.Map;
import umcg.genetica.variantAnnotator.GenomicRange;

public class GffElement
implements GenomicRange {
    private final String seqname;
    private final String source;
    private final String feature;
    private final int start;
    private final int end;
    private final float score;
    private final char strand;
    private final int frame;
    private final Map<String, String> attributes;

    public GffElement(String seqname, String source, String feature, int start, int end, float score, char strand, int frame, Map<String, String> attributes) {
        this.seqname = seqname;
        this.source = source;
        this.feature = feature;
        this.start = start;
        this.end = end;
        this.score = score;
        this.strand = strand;
        this.frame = frame;
        this.attributes = Collections.unmodifiableMap(attributes);
    }

    @Override
    public String getSeqname() {
        return this.seqname;
    }

    public String getSource() {
        return this.source;
    }

    public String getFeature() {
        return this.feature;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    public float getScore() {
        return this.score;
    }

    public char getStrand() {
        return this.strand;
    }

    public int getFrame() {
        return this.frame;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean hasAttribute(String attributeName) {
        return this.attributes.containsKey(attributeName);
    }

    public String getAttributeValue(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Seq: ");
        builder.append(this.getSeqname());
        builder.append("\nPos: ");
        builder.append(this.getStart());
        builder.append(" to ");
        builder.append(this.getEnd());
        builder.append("\nsource: ");
        builder.append(this.getSource());
        builder.append("\nfeature: ");
        builder.append(this.getFeature());
        builder.append("\nscore: ");
        builder.append(this.getScore());
        builder.append("\nstrand: ");
        builder.append(this.getStrand());
        builder.append("\nframe: ");
        builder.append(this.getFrame());
        builder.append("\nattributes: ");
        builder.append(this.attributes.toString());
        return builder.toString();
    }
}

