/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.fasta;

public class LargeByteArray {
    private final byte[][] data;
    private long size;
    private int blockSize;
    private static final int MAX_BLOCK_SIZE = 0x7FFFFFF7;

    public LargeByteArray(long size) {
        this.size = size;
        long blocks = size / 0x7FFFFFF7L;
        if (size % 0x7FFFFFF7L > 0L) {
            ++blocks;
        }
        if (blocks >= 0x7FFFFFF7L) {
            throw new IllegalArgumentException("Array to large");
        }
        this.blockSize = (int)(size / blocks);
        if (size % blocks > 0L) {
            ++this.blockSize;
        }
        this.data = new byte[(int)blocks][this.blockSize];
    }

    public void setQuick(long index, byte value) {
        int block = (int)(index / (long)this.blockSize);
        int blockIndex = (int)(index % (long)this.blockSize);
        this.data[block][blockIndex] = value;
    }

    public byte getQuick(long index) {
        int block = (int)(index / (long)this.blockSize);
        int blockIndex = (int)(index % (long)this.blockSize);
        return this.data[block][blockIndex];
    }

    public long getSize() {
        return this.size;
    }
}

