/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.chrContacts;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import umcg.genetica.io.chrContacts.ChrContact;
import umcg.genetica.io.text.TextFile;

public class SortIntraChrContacts {
    public static void readNonSortedWriteSorted(String fileToReads, String fileToWrite) {
        ArrayList<ChrContact> contacts = null;
        try {
            contacts = SortIntraChrContacts.readRawIntraContactInformation(fileToReads);
        }
        catch (IOException ex) {
            Logger.getLogger(SortIntraChrContacts.class.getName()).log(Level.SEVERE, null, ex);
        }
        Collections.sort(contacts);
        try {
            SortIntraChrContacts.writeRawIntraContactInformation(contacts, fileToWrite);
        }
        catch (IOException ex) {
            Logger.getLogger(SortIntraChrContacts.class.getName()).log(Level.SEVERE, null, ex);
        }
        contacts = null;
    }

    private static ArrayList<ChrContact> readRawIntraContactInformation(String fileToReads) throws IOException {
        String row;
        ArrayList<ChrContact> chrContactInfo = new ArrayList<ChrContact>();
        BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileToReads), "UTF-8"));
        while ((row = input.readLine()) != null) {
            int posChr2;
            int posChr1;
            int posChrY;
            String[] parts = StringUtils.split((String)row, (char)'\t');
            int posChrX = Integer.parseInt(parts[0]);
            if (posChrX < (posChrY = Integer.parseInt(parts[1]))) {
                posChr1 = posChrX;
                posChr2 = posChrY;
            } else {
                posChr1 = posChrY;
                posChr2 = posChrX;
            }
            double contact = Double.parseDouble(parts[2]);
            chrContactInfo.add(new ChrContact(posChr1, posChr2, contact));
        }
        input.close();
        return chrContactInfo;
    }

    public static void writeRawIntraContactInformation(ArrayList<ChrContact> contacts, String fileToWrite) throws IOException {
        TextFile outWriter = new TextFile(fileToWrite, true);
        int previousSmaller = -1;
        int previousLarger = -1;
        for (ChrContact contact : contacts) {
            if (previousSmaller != contact.getChrLocationSmaller() && previousLarger != contact.getChrLocationLarger()) {
                outWriter.writeln(contact.getChrLocationSmaller() + "\t" + contact.getChrLocationLarger() + "\t" + contact.getContactValue());
            }
            previousSmaller = contact.getChrLocationSmaller();
            previousLarger = contact.getChrLocationLarger();
        }
        outWriter.close();
    }
}

