/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.chrContacts;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import umcg.genetica.io.chrContacts.ChrContact;
import umcg.genetica.io.text.TextFile;

public class SortInterChrContacts {
    public static void readNonSortedWriteSorted(String fileToReads, String fileToWrite) {
        ArrayList<ChrContact> contacts = null;
        try {
            contacts = SortInterChrContacts.readRawInterContactInformation(fileToReads);
        }
        catch (IOException ex) {
            Logger.getLogger(SortInterChrContacts.class.getName()).log(Level.SEVERE, null, ex);
        }
        Collections.sort(contacts);
        try {
            SortInterChrContacts.writeRawInterContactInformation(contacts, fileToWrite);
        }
        catch (IOException ex) {
            Logger.getLogger(SortInterChrContacts.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static ArrayList<ChrContact> readRawInterContactInformation(String fileToReads) throws IOException {
        String row;
        ArrayList<ChrContact> chrContactInfo = new ArrayList<ChrContact>();
        BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileToReads), "UTF-8"));
        while ((row = input.readLine()) != null) {
            String[] parts = StringUtils.split((String)row, (char)'\t');
            int posChr1 = Integer.parseInt(parts[0]);
            int posChr2 = Integer.parseInt(parts[1]);
            double contact = Double.parseDouble(parts[2]);
            chrContactInfo.add(new ChrContact(posChr1, posChr2, contact));
        }
        input.close();
        return chrContactInfo;
    }

    public static void writeRawInterContactInformation(ArrayList<ChrContact> contacts, String fileToWrite) throws IOException {
        TextFile outWriter = new TextFile(fileToWrite, true);
        for (ChrContact contact : contacts) {
            outWriter.writeln(contact.getChrLocationSmaller() + "\t" + contact.getChrLocationLarger() + "\t" + contact.getContactValue());
        }
        outWriter.close();
    }
}

