/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.binInteraction;

import umcg.genetica.io.binInteraction.BinaryInteractionFileException;

public class BinaryInteractionQtlZscores {
    private final double[] zscores;
    private final int[] sampleCounts;
    private final double metaZscore;
    private static final double[] emptyDoubleArray = new double[0];
    private static final int[] emptyIntArray = new int[0];

    public BinaryInteractionQtlZscores(double[] zscores, int[] sampleCounts, double metaZscore) throws BinaryInteractionFileException {
        this.zscores = zscores;
        this.sampleCounts = sampleCounts;
        this.metaZscore = metaZscore;
        this.checkArrays();
    }

    public BinaryInteractionQtlZscores(double[] zscores, int[] sampleCounts) throws BinaryInteractionFileException {
        this.zscores = zscores;
        this.sampleCounts = sampleCounts;
        this.metaZscore = Double.NaN;
        this.checkArrays();
    }

    public BinaryInteractionQtlZscores(double zscore, int sampleCounts) throws BinaryInteractionFileException {
        this.zscores = new double[]{zscore};
        this.sampleCounts = new int[]{sampleCounts};
        this.metaZscore = Double.NaN;
        this.checkArrays();
    }

    public BinaryInteractionQtlZscores(double metaZscore) {
        this.zscores = emptyDoubleArray;
        this.sampleCounts = emptyIntArray;
        this.metaZscore = metaZscore;
    }

    private void checkArrays() throws BinaryInteractionFileException {
        if (this.zscores.length != this.sampleCounts.length) {
            throw new BinaryInteractionFileException("All arrays for qtl z-scores must be equal length");
        }
    }

    public double[] getZscores() {
        return this.zscores;
    }

    public int[] getSampleCounts() {
        return this.sampleCounts;
    }

    public double getMetaZscore() {
        return this.metaZscore;
    }

    public int getCohortCount() {
        return this.zscores.length;
    }
}

