/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.binInteraction;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.HashSet;
import org.molgenis.genotype.Allele;
import umcg.genetica.io.binInteraction.BinaryInteractionCohort;
import umcg.genetica.io.binInteraction.BinaryInteractionFile;
import umcg.genetica.io.binInteraction.BinaryInteractionFileConstructorBuilder;
import umcg.genetica.io.binInteraction.BinaryInteractionFileException;
import umcg.genetica.io.binInteraction.gene.BinaryInteractionGene;
import umcg.genetica.io.binInteraction.gene.BinaryInteractionGeneCreator;
import umcg.genetica.io.binInteraction.variant.BinaryInteractionVariantCreator;

public class BinaryInteractionFileCreator {
    private static final int NO_ENTRY_INT_MAP = -1;
    private final BinaryInteractionVariantCreator[] variants;
    private final BinaryInteractionGeneCreator[] genes;
    private final BinaryInteractionCohort[] cohorts;
    private final String[] covariates;
    private final boolean allCovariants;
    private final boolean metaAnalysis;
    private final boolean normalQtlStored;
    private final boolean flippedZscoreStored;
    private String description = "";
    private int[][] covariatesTested;
    private long interactions = 0L;
    private boolean startedAddingCovariates = false;
    private int countVariantGeneCombinations = 0;
    private final TObjectIntHashMap<String> variantMap;
    private final TObjectIntHashMap<String> genesMap;
    private final TObjectIntHashMap<String> covariatesMap;
    private int[] variantCummulativeGeneCounts;
    private boolean sortedIndices = false;
    private final File file;
    private boolean created = false;

    public BinaryInteractionFileCreator(File file, BinaryInteractionVariantCreator[] variants, BinaryInteractionGeneCreator[] genes, BinaryInteractionCohort[] cohorts, String[] covariates, boolean allCovariants, boolean metaAnalysis, boolean normalQtlStored, boolean flippedZscoreStored) throws BinaryInteractionFileException, IOException {
        int i;
        this.file = file;
        this.variants = variants;
        this.genes = genes;
        this.cohorts = cohorts;
        this.covariates = covariates;
        this.allCovariants = allCovariants;
        this.metaAnalysis = metaAnalysis;
        this.normalQtlStored = normalQtlStored;
        this.flippedZscoreStored = flippedZscoreStored;
        this.variantMap = new TObjectIntHashMap(variants.length, 0.75f, -1);
        this.genesMap = new TObjectIntHashMap(genes.length, 0.75f, -1);
        this.covariatesMap = new TObjectIntHashMap(covariates.length, 0.75f, -1);
        if (file.getParentFile() != null && !file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new IOException("Cannot create parent folder for: " + file.getAbsolutePath());
        }
        if (file.exists() && !file.canWrite()) {
            throw new IOException("File exists and cannot overwrite at: " + file.getAbsolutePath());
        }
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Cannot create: " + file.getAbsolutePath());
        }
        for (i = 0; i < variants.length; ++i) {
            if (variants[i] == null) {
                throw new BinaryInteractionFileException("Variant not set at index: " + i);
            }
            if (this.variantMap.put((Object)variants[i].getName(), i) == -1) continue;
            throw new BinaryInteractionFileException("Cannot store the same variant twice (" + variants[i].getName() + ")");
        }
        for (i = 0; i < genes.length; ++i) {
            if (genes[i] == null) {
                throw new BinaryInteractionFileException("Gene not set at index: " + i);
            }
            if (this.genesMap.put((Object)genes[i].getName(), i) == -1) continue;
            throw new BinaryInteractionFileException("Cannot store the same gene twice (" + genes[i].getName() + ")");
        }
        for (i = 0; i < covariates.length; ++i) {
            if (covariates[i] == null) {
                throw new BinaryInteractionFileException("Covariate not set at index: " + i);
            }
            if (this.covariatesMap.put((Object)covariates[i], i) == -1) continue;
            throw new BinaryInteractionFileException("Cannot store the same covariate twice (" + covariates[i] + ")");
        }
        HashSet<String> tmp = new HashSet<String>(cohorts.length);
        for (int i2 = 0; i2 < cohorts.length; ++i2) {
            if (cohorts[i2] == null) {
                throw new BinaryInteractionFileException("Cohort not set at index: " + i2);
            }
            if (tmp.add(cohorts[i2].getName())) continue;
            throw new BinaryInteractionFileException("Cannot store the same cohort twice (" + cohorts[i2] + ")");
        }
    }

    public synchronized void addTestedVariantGene(String variantName, String geneName) throws BinaryInteractionFileException {
        this.sortedIndices = false;
        if (this.created) {
            throw new BinaryInteractionFileException("You already created this file. Adding variant-gene combinations no longer possible");
        }
        if (this.startedAddingCovariates) {
            throw new BinaryInteractionFileException("All variant-gene combinations must be added before setting covariates. (sorry)");
        }
        int variantIndex = this.variantMap.get((Object)variantName);
        int geneIndex = this.genesMap.get((Object)geneName);
        if (variantIndex == -1) {
            throw new BinaryInteractionFileException("Unable to add variant-gene combination. Variant " + variantName + " not found");
        }
        if (geneIndex == -1) {
            throw new BinaryInteractionFileException("Unable to add variant-gene combination. Gene " + geneName + " not found");
        }
        BinaryInteractionVariantCreator variant = this.variants[variantIndex];
        BinaryInteractionGeneCreator gene = this.genes[geneIndex];
        for (int existinVariantGenePointer : variant.getGenePointers()) {
            if (existinVariantGenePointer != geneIndex) continue;
            throw new BinaryInteractionFileException("Cannot add a variant-gene combination twice: " + variantName + "-" + geneName);
        }
        ++this.countVariantGeneCombinations;
        variant.addGene(geneIndex);
        gene.addVariant(variantIndex);
    }

    public synchronized void addTestedInteraction(String variantName, String geneName, String[] covariateNames) throws BinaryInteractionFileException {
        if (this.created) {
            throw new BinaryInteractionFileException("You already created this file. Adding covariates no longer possible");
        }
        if (this.allCovariants) {
            throw new BinaryInteractionFileException("Cannot set specific covariates for a file with all covariates tested");
        }
        if (!this.sortedIndices) {
            this.sortIndices();
        }
        if (!this.startedAddingCovariates) {
            this.startedAddingCovariates = true;
            this.covariatesTested = new int[this.countVariantGeneCombinations][];
            this.variantCummulativeGeneCounts = new int[this.variants.length + 1];
            for (int i = 0; i < this.variants.length; ++i) {
                this.variantCummulativeGeneCounts[i + 1] = this.variantCummulativeGeneCounts[i] + this.variants[i].getGeneCount();
            }
        }
        int variantIndex = this.variantMap.get((Object)variantName);
        int geneIndex = this.genesMap.get((Object)geneName);
        if (variantIndex == -1) {
            throw new BinaryInteractionFileException("Unable to add interaction. Variant " + variantName + " not found");
        }
        if (geneIndex == -1) {
            throw new BinaryInteractionFileException("Unable to add interaction. Gene " + geneName + " not found");
        }
        BinaryInteractionVariantCreator variant = this.variants[variantIndex];
        int variantGenePointerIndex = variant.getIndexOfGenePointer(geneIndex);
        if (variantGenePointerIndex < 0) {
            throw new BinaryInteractionFileException("Cannot add a interaction variant-gene combination does not exist: " + variantName + "-" + geneName);
        }
        int[] variantGeneCovariateArray = new int[covariateNames.length];
        for (int i = 0; i < covariateNames.length; ++i) {
            int covariteIndex = this.covariatesMap.get((Object)covariateNames[i]);
            if (covariteIndex == -1) {
                throw new BinaryInteractionFileException("Unable to add interaction combination. Covariate " + covariateNames[i] + " not found");
            }
            variantGeneCovariateArray[i] = covariteIndex;
            ++this.interactions;
        }
        Arrays.sort(variantGeneCovariateArray);
        int indexInCovariatesTested = this.variantCummulativeGeneCounts[variantIndex] + variantGenePointerIndex;
        if (this.covariatesTested[indexInCovariatesTested] != null) {
            throw new BinaryInteractionFileException("Already added interactions for: " + variantName + "-" + geneName);
        }
        if (indexInCovariatesTested >= this.covariatesTested.length) {
            throw new BinaryInteractionFileException("Something has gone wrong :(");
        }
        this.covariatesTested[indexInCovariatesTested] = variantGeneCovariateArray;
    }

    public BinaryInteractionFile create() throws FileNotFoundException, IOException, BinaryInteractionFileException {
        long sizeNormalQtlSection;
        long startNormalQtlSection;
        if (this.created) {
            throw new BinaryInteractionFileException("You already created this file.");
        }
        this.created = true;
        if (!this.sortedIndices) {
            this.sortIndices();
        }
        if (this.allCovariants) {
            this.interactions = (long)this.countVariantGeneCombinations * (long)this.covariates.length;
        }
        HashSet<Allele> alleles = BinaryInteractionFileCreator.createAlleleDictionary(this.variants);
        HashSet<String> chrs = BinaryInteractionFileCreator.createChrDictionary(this.variants, this.genes);
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.file)));
        dataOutputStream.writeByte(81);
        dataOutputStream.writeByte(73);
        dataOutputStream.writeByte(1);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeBoolean(this.allCovariants);
        dataOutputStream.writeBoolean(this.metaAnalysis);
        dataOutputStream.writeBoolean(this.normalQtlStored);
        dataOutputStream.writeBoolean(this.flippedZscoreStored);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(0);
        long timeStamp = System.currentTimeMillis() / 1000L;
        dataOutputStream.writeLong(timeStamp);
        BinaryInteractionFileCreator.writeString(dataOutputStream, this.description);
        dataOutputStream.writeInt(this.cohorts.length);
        dataOutputStream.writeInt(chrs.size());
        dataOutputStream.writeInt(alleles.size());
        dataOutputStream.writeInt(this.genes.length);
        dataOutputStream.writeInt(this.variants.length);
        dataOutputStream.writeInt(this.covariates.length);
        dataOutputStream.writeLong(this.interactions);
        for (BinaryInteractionCohort cohort : this.cohorts) {
            BinaryInteractionFileCreator.writeString(dataOutputStream, cohort.getName());
            dataOutputStream.writeInt(cohort.getSampleCount());
        }
        TObjectIntHashMap chrDictionary = new TObjectIntHashMap(chrs.size(), 0.75f, -1);
        for (String chr : chrs) {
            chrDictionary.put((Object)chr, chrDictionary.size());
            BinaryInteractionFileCreator.writeString(dataOutputStream, chr);
        }
        TObjectIntHashMap alleleDictionary = new TObjectIntHashMap(alleles.size(), 0.75f, -1);
        for (Allele alelle : alleles) {
            alleleDictionary.put((Object)alelle, alleleDictionary.size());
            BinaryInteractionFileCreator.writeString(dataOutputStream, alelle.getAlleleAsString());
        }
        for (BinaryInteractionVariantCreator variant : this.variants) {
            BinaryInteractionFileCreator.writeString(dataOutputStream, variant.getName());
            dataOutputStream.writeInt(chrDictionary.get((Object)variant.getChr()));
            dataOutputStream.writeInt(variant.getPos());
            dataOutputStream.writeInt(alleleDictionary.get((Object)variant.getRefAllele()));
            dataOutputStream.writeInt(alleleDictionary.get((Object)variant.getAltAllele()));
            dataOutputStream.writeInt(variant.getGeneCount());
            BinaryInteractionFileCreator.writeIntArray(dataOutputStream, variant.getGenePointers());
        }
        for (BinaryInteractionGeneCreator gene : this.genes) {
            BinaryInteractionFileCreator.writeString(dataOutputStream, gene.getName());
            dataOutputStream.writeInt(chrDictionary.get((Object)gene.getChr()));
            dataOutputStream.writeInt(gene.getStart());
            dataOutputStream.writeInt(gene.getEnd());
            dataOutputStream.writeInt(gene.getVariantCount());
            BinaryInteractionFileCreator.writeIntArray(dataOutputStream, gene.getVariantPointers());
        }
        for (String covariate : this.covariates) {
            BinaryInteractionFileCreator.writeString(dataOutputStream, covariate);
        }
        if (!this.allCovariants) {
            for (int i = 0; i < this.covariatesTested.length; ++i) {
                if (this.covariatesTested[i] == null) {
                    dataOutputStream.writeInt(0);
                    continue;
                }
                dataOutputStream.writeInt(this.covariatesTested[i].length);
                BinaryInteractionFileCreator.writeIntArray(dataOutputStream, this.covariatesTested[i]);
            }
        }
        long startData = dataOutputStream.size();
        dataOutputStream.close();
        if (this.normalQtlStored) {
            startNormalQtlSection = startData;
            long sizeQtlBlock = BinaryInteractionFile.calculateSizeNormalQtlBlock(this.cohorts.length, this.metaAnalysis);
            sizeNormalQtlSection = sizeQtlBlock * (long)this.countVariantGeneCombinations;
        } else {
            sizeNormalQtlSection = 0L;
            startNormalQtlSection = -1L;
        }
        long startInteractionSection = startData + sizeNormalQtlSection;
        long sizeInteractionBlock = BinaryInteractionFile.calculateSizeInteractionResultBlock(this.cohorts.length, this.flippedZscoreStored, this.metaAnalysis) * this.interactions;
        RandomAccessFile fileRandomAccess = new RandomAccessFile(this.file, "rw");
        fileRandomAccess.setLength(startData + sizeNormalQtlSection + sizeInteractionBlock);
        BinaryInteractionFileConstructorBuilder constructorBuilder = new BinaryInteractionFileConstructorBuilder();
        constructorBuilder.setAllCovariants(this.allCovariants);
        constructorBuilder.setCohorts(this.cohorts);
        constructorBuilder.setCovariatesTested(this.covariatesTested);
        constructorBuilder.setCovariates(this.covariates);
        constructorBuilder.setFileDescription(this.description);
        constructorBuilder.setFlippedZscoreStored(this.flippedZscoreStored);
        constructorBuilder.setGenes(this.genes);
        constructorBuilder.setInteractionFile(this.file);
        constructorBuilder.setMetaAnalysis(this.metaAnalysis);
        constructorBuilder.setNormalQtlStored(this.normalQtlStored);
        constructorBuilder.setReadOnly(false);
        constructorBuilder.setStartInteractionBlock(startInteractionSection);
        constructorBuilder.setStartQtlBlock(startNormalQtlSection);
        constructorBuilder.setTimeStamp(timeStamp);
        constructorBuilder.setVariants(this.variants);
        constructorBuilder.setInteractions(this.interactions);
        return constructorBuilder.createBinaryInteractionFile();
    }

    private void sortIndices() {
        for (BinaryInteractionGeneCreator gene : this.genes) {
            gene.sortGenePointers();
        }
        for (BinaryInteractionVariantCreator variant : this.variants) {
            variant.sortGenePointers();
        }
        this.sortedIndices = true;
    }

    public void setDescription(String description) throws BinaryInteractionFileException {
        if (this.created) {
            throw new BinaryInteractionFileException("You already created this file.");
        }
        this.description = description;
    }

    private static void writeString(DataOutputStream dataOutputStream, String string) throws IOException {
        char[] chars = string.toCharArray();
        dataOutputStream.writeInt(chars.length);
        for (char c : chars) {
            dataOutputStream.writeChar(c);
        }
    }

    private static void writeIntArray(DataOutputStream dataOutputStream, int[] array) throws IOException {
        for (int e : array) {
            dataOutputStream.writeInt(e);
        }
    }

    private static HashSet<Allele> createAlleleDictionary(BinaryInteractionVariantCreator[] variants) {
        HashSet<Allele> alleles = new HashSet<Allele>();
        for (BinaryInteractionVariantCreator variant : variants) {
            alleles.add(variant.getRefAllele());
            alleles.add(variant.getAltAllele());
        }
        return alleles;
    }

    private static HashSet<String> createChrDictionary(BinaryInteractionVariantCreator[] variants, BinaryInteractionGene[] genes) {
        HashSet<String> chrs = new HashSet<String>();
        for (BinaryInteractionVariantCreator variant : variants) {
            chrs.add(variant.getChr());
        }
        for (BinaryInteractionGene gene : genes) {
            chrs.add(gene.getChr());
        }
        return chrs;
    }
}

