/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.binInteraction;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import umcg.genetica.io.binInteraction.BinaryInteractionFile;
import umcg.genetica.io.binInteraction.BinaryInteractionFileException;
import umcg.genetica.io.binInteraction.BinaryInteractionQtlZscores;
import umcg.genetica.io.binInteraction.BinaryInteractionQueryResult;
import umcg.genetica.io.binInteraction.BinaryInteractionZscores;

public class BinaryInteractionCovariateIterator
implements Iterator<BinaryInteractionQueryResult> {
    private final String variantName;
    private final String geneName;
    private final int[] covariatsTested;
    private final BinaryInteractionFile file;
    private final long startVariantGeneBlock;
    private final BinaryInteractionQtlZscores qtlZscores;
    private int variantGeneCovariateIndex;

    public BinaryInteractionCovariateIterator(String variantName, String geneName, int[] covariatsTested, BinaryInteractionFile file, long startVariantGeneBlock, BinaryInteractionQtlZscores qtlZscores) {
        this.variantName = variantName;
        this.geneName = geneName;
        this.covariatsTested = covariatsTested;
        this.file = file;
        this.startVariantGeneBlock = startVariantGeneBlock;
        this.qtlZscores = qtlZscores;
        this.variantGeneCovariateIndex = -1;
    }

    @Override
    public boolean hasNext() {
        if (this.covariatsTested == null) {
            return this.variantGeneCovariateIndex + 1 < this.file.getCovariateCount();
        }
        return this.variantGeneCovariateIndex + 1 < this.covariatsTested.length;
    }

    @Override
    public BinaryInteractionQueryResult next() {
        BinaryInteractionZscores interactionRestuls;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.variantGeneCovariateIndex;
        try {
            interactionRestuls = this.file.readInteractionResults(this.startVariantGeneBlock + (long)this.variantGeneCovariateIndex * this.file.sizeInteractionBlock);
        }
        catch (IOException | BinaryInteractionFileException ex) {
            throw new RuntimeException(ex);
        }
        String covariateName = this.covariatsTested == null ? this.file.covariates[this.variantGeneCovariateIndex] : this.file.covariates[this.covariatsTested[this.variantGeneCovariateIndex]];
        return new BinaryInteractionQueryResult(this.variantName, this.geneName, covariateName, this.qtlZscores, interactionRestuls);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported ever.");
    }
}

