/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.bedgraph;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import umcg.genetica.collections.intervaltree.PerChrIntervalTree;
import umcg.genetica.io.bedgraph.BedGraphEntry;

public class BedGraphFile
implements Iterable<BedGraphEntry> {
    private final File bedGraphFile;
    private final boolean omitChr;
    private final boolean makeOneBased;
    private static final Pattern CHR_PATTERN = Pattern.compile("^chr(.*)$", 2);

    public BedGraphFile(String bedGraphFilePath) throws FileNotFoundException, IOException {
        this(new File(bedGraphFilePath), false, false);
    }

    public BedGraphFile(String bedGraphFilePath, boolean omitChr, boolean makeOneBased) throws FileNotFoundException, IOException {
        this(new File(bedGraphFilePath), omitChr, makeOneBased);
    }

    public BedGraphFile(File bedGraphFile) throws FileNotFoundException, IOException {
        this(bedGraphFile, false, false);
    }

    public BedGraphFile(File bedGraphFile, boolean omitChr, boolean makeOneBased) throws FileNotFoundException, IOException {
        this.bedGraphFile = bedGraphFile;
        this.omitChr = omitChr;
        this.makeOneBased = makeOneBased;
        if (!this.bedGraphFile.exists()) {
            throw new FileNotFoundException("BedGraph file not found at: " + bedGraphFile.getAbsolutePath());
        }
        if (!this.bedGraphFile.isFile()) {
            throw new IOException("Error reading BedGraph file at: " + bedGraphFile.getAbsolutePath());
        }
        if (!this.bedGraphFile.canRead()) {
            throw new IOException("Error reading BedGraph file at: " + bedGraphFile.getAbsolutePath());
        }
    }

    private static BedGraphEntry parseLine(String line, boolean omitChr, boolean makeOneBased) throws IOException {
        double value;
        int stop;
        int start;
        String[] lineElements = StringUtils.split((String)line);
        if (lineElements.length != 4) {
            throw new IOException("Error parsing BedGraph, did not find 4 fields on line: " + line);
        }
        String chr = omitChr ? BedGraphFile.removeChr(lineElements[0]).intern() : lineElements[0].intern();
        try {
            start = Integer.parseInt(lineElements[1]);
        }
        catch (NumberFormatException ex) {
            throw new IOException("Error parsing BedGraph, Start is not an int on line: " + line);
        }
        try {
            stop = Integer.parseInt(lineElements[2]);
        }
        catch (NumberFormatException ex) {
            throw new IOException("Error parsing BedGraph, Stop is not an int on line: " + line);
        }
        try {
            value = Double.parseDouble(lineElements[3]);
        }
        catch (NumberFormatException ex) {
            throw new IOException("Error parsing BedGraph, Value is not a double on line: " + line);
        }
        if (makeOneBased) {
            ++start;
            ++stop;
        }
        return new BedGraphEntry(chr, start, stop, value);
    }

    private static String removeChr(String chromosome) {
        Matcher chrMatcher = CHR_PATTERN.matcher(chromosome);
        if (chrMatcher.find()) {
            return chrMatcher.group(1);
        }
        return chromosome;
    }

    @Override
    public Iterator<BedGraphEntry> iterator() {
        try {
            return new Iterator<BedGraphEntry>(){
                private final BufferedReader reader;
                private BedGraphEntry next;
                private boolean atNext;
                private boolean atEnd;
                {
                    this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(BedGraphFile.this.bedGraphFile), "UTF-8"));
                    this.atEnd = false;
                }

                @Override
                public boolean hasNext() {
                    if (this.atEnd) {
                        return false;
                    }
                    if (this.atNext) {
                        return true;
                    }
                    try {
                        String line;
                        while ((line = this.reader.readLine()) != null && (line.startsWith("browser") || line.startsWith("track") || line.charAt(0) == '#')) {
                        }
                        if (line == null) {
                            this.atEnd = true;
                            try {
                                this.reader.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            return false;
                        }
                        this.next = BedGraphFile.parseLine(line, BedGraphFile.this.omitChr, BedGraphFile.this.makeOneBased);
                        this.atNext = true;
                        return true;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }

                @Override
                public BedGraphEntry next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.atNext = false;
                    return this.next;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public PerChrIntervalTree<BedGraphEntry> createIntervalTree() throws Exception {
        return PerChrIntervalTree.createFromChrGroupedIterable(this, BedGraphEntry.class);
    }
}

