/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.bed;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import umcg.genetica.collections.intervaltree.PerChrIntervalTree;
import umcg.genetica.io.bed.BedEntry;

public class BedFile
implements Iterable<BedEntry> {
    private final File bedFile;
    private final boolean omitChr;
    private final boolean makeOneBased;
    private final Map<String, String> trackInfo;
    private static final Pattern CHR_PATTERN = Pattern.compile("^chr(.*)$", 2);
    private static final Pattern TRACK_INFO_PATTERN = Pattern.compile("(\\w+)=([^\"]\\S+|\".+?\")\\s*");

    public BedFile(String bedFilePath) throws FileNotFoundException, IOException {
        this(new File(bedFilePath), false, false);
    }

    public BedFile(String bedFilePath, boolean omitChr, boolean makeOneBased) throws FileNotFoundException, IOException {
        this(new File(bedFilePath), omitChr, makeOneBased);
    }

    public BedFile(File bedFile) throws FileNotFoundException, IOException {
        this(bedFile, false, false);
    }

    public BedFile(File bedFile, boolean omitChr, boolean makeOneBased) throws FileNotFoundException, IOException {
        String line;
        this.bedFile = bedFile;
        this.omitChr = omitChr;
        this.makeOneBased = makeOneBased;
        if (!this.bedFile.exists()) {
            throw new FileNotFoundException("Bed file not found at: " + bedFile.getAbsolutePath());
        }
        if (!this.bedFile.isFile()) {
            throw new IOException("Error reading bed file at: " + bedFile.getAbsolutePath());
        }
        if (!this.bedFile.canRead()) {
            throw new IOException("Error reading bed file at: " + bedFile.getAbsolutePath());
        }
        Map<String, String> trackInfo = Collections.EMPTY_MAP;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(bedFile), "UTF-8"));
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("track")) {
                trackInfo = BedFile.parseTrackLine(line);
                break;
            }
            if (StringUtils.split((String)line, (char)'\t').length <= 3) continue;
        }
        reader.close();
        this.trackInfo = trackInfo;
    }

    private static BedEntry parseLine(String line, boolean omitChr, boolean makeOneBased) throws IOException {
        double score;
        int stop;
        int start;
        String[] lineElements = StringUtils.split((String)line, (char)'\t');
        if (lineElements.length < 3) {
            throw new IOException("Error parsing bed, did not find 3 fields on line: " + line);
        }
        String chr = omitChr ? BedFile.removeChr(lineElements[0]).intern() : lineElements[0].intern();
        try {
            start = Integer.parseInt(lineElements[1]);
        }
        catch (NumberFormatException ex) {
            throw new IOException("Error parsing bed file, Start is not an int on line: " + line);
        }
        try {
            stop = Integer.parseInt(lineElements[2]);
        }
        catch (NumberFormatException ex) {
            throw new IOException("Error parsing bed file, Stop is not an int on line: " + line);
        }
        if (makeOneBased) {
            ++start;
            ++stop;
        }
        String name = lineElements.length >= 4 ? lineElements[3] : null;
        if (lineElements.length >= 5) {
            try {
                score = Double.parseDouble(lineElements[4]);
            }
            catch (NumberFormatException ex) {
                throw new IOException("Error parsing bed file, score is not a double: " + line);
            }
        } else {
            score = Double.NaN;
        }
        return new BedEntry(chr, start, stop, name, score);
    }

    private static String removeChr(String chromosome) {
        Matcher chrMatcher = CHR_PATTERN.matcher(chromosome);
        if (chrMatcher.find()) {
            return chrMatcher.group(1);
        }
        return chromosome;
    }

    @Override
    public Iterator<BedEntry> iterator() {
        try {
            return new Iterator<BedEntry>(){
                private final BufferedReader reader;
                private BedEntry next;
                private boolean atNext;
                private boolean atEnd;
                {
                    this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(BedFile.this.bedFile), "UTF-8"));
                    this.atEnd = false;
                }

                @Override
                public boolean hasNext() {
                    if (this.atEnd) {
                        return false;
                    }
                    if (this.atNext) {
                        return true;
                    }
                    try {
                        String line;
                        while ((line = this.reader.readLine()) != null && (line.startsWith("browser") || line.startsWith("track") || line.charAt(0) == '#')) {
                        }
                        if (line == null) {
                            this.atEnd = true;
                            try {
                                this.reader.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            return false;
                        }
                        this.next = BedFile.parseLine(line, BedFile.this.omitChr, BedFile.this.makeOneBased);
                        this.atNext = true;
                        return true;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }

                @Override
                public BedEntry next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.atNext = false;
                    return this.next;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public PerChrIntervalTree<BedEntry> createIntervalTree() throws Exception {
        return PerChrIntervalTree.createFromChrGroupedIterable(this, BedEntry.class);
    }

    public Map<String, String> getTrackInfo() {
        return this.trackInfo;
    }

    private static Map<String, String> parseTrackLine(String line) {
        HashMap<String, String> infoMap = new HashMap<String, String>();
        Matcher m = TRACK_INFO_PATTERN.matcher(line);
        while (m.find()) {
            String infoName = m.group(1);
            String info = m.group(2).replace("\"", "");
            infoMap.put(infoName, info);
        }
        return Collections.unmodifiableMap(infoMap);
    }
}

