/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.containers;

import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import umcg.genetica.containers.Chromosome;
import umcg.genetica.containers.Exon;
import umcg.genetica.containers.Gene;
import umcg.genetica.containers.StringIntegerObject;
import umcg.genetica.util.StringIntegerObjectSorterSortOnInteger;

public class Transcript {
    private Gene parentGene;
    private HashMap<String, Exon> exons;
    private HashMap<Exon, Integer> exonRanks;
    private Chromosome parentChromosome;
    private int start;
    private int end;
    private int strand;
    private String name;
    private String protein;

    public Gene getParentGene() {
        return this.parentGene;
    }

    public void setParentGene(Gene parentGene) {
        this.parentGene = parentGene;
    }

    public HashMap<String, Exon> getExons() {
        return this.exons;
    }

    public void setExons(HashMap<String, Exon> exons) {
        this.exons = exons;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public int getStrand() {
        return this.strand;
    }

    public void setStrand(int strand) {
        this.strand = strand;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addExon(Exon currExo) {
        if (this.exons == null) {
            this.exons = new HashMap();
        }
        if (currExo == null) {
            System.out.println("ERROR!");
            System.exit(0);
        }
        this.exons.put(currExo.getName(), currExo);
    }

    public void setProtein(String protein) {
        this.protein = protein;
    }

    public String getProtein() {
        return this.protein;
    }

    public Exon[] getExonsRanked() {
        Exon[] sortedexons = new Exon[this.exons.size()];
        Vector<StringIntegerObject> exonnames = new Vector<StringIntegerObject>();
        Set<String> keys = this.exons.keySet();
        for (String key : keys) {
            Integer exonrank = this.exonRanks.get(this.exons.get(key));
            exonnames.add(new StringIntegerObject(key, exonrank));
        }
        StringIntegerObjectSorterSortOnInteger sorter = new StringIntegerObjectSorterSortOnInteger();
        sorter.sort(exonnames);
        for (int i = 0; i < exonnames.size(); ++i) {
            sortedexons[i] = this.exons.get(((StringIntegerObject)exonnames.get((int)i)).stringValue);
        }
        return sortedexons;
    }

    public int getLength() {
        return this.end - this.start;
    }

    public void setParentChromosome(Chromosome currChr) {
        if (this.parentChromosome != null && this.parentChromosome != currChr) {
            System.err.println("WARNING: transcipt maps to multiple chromosomes: " + currChr.getName());
        }
        this.parentChromosome = currChr;
    }

    public void setExonRank(Exon currExo, Integer exonrankintranscript) {
        if (this.exonRanks == null) {
            this.exonRanks = new HashMap();
        }
        this.exonRanks.put(currExo, exonrankintranscript);
    }
}

