/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.collections.intervaltree;

import java.util.ArrayList;
import java.util.Arrays;
import umcg.genetica.collections.intervaltree.Range;
import umcg.genetica.collections.intervaltree.RangeEndReverseComparator;
import umcg.genetica.collections.intervaltree.RangeStartComparator;

class IntervalTreeNode<E extends Range> {
    private final int centerPoint;
    private final IntervalTreeNode left;
    private final IntervalTreeNode right;
    private final E[] startSorted;
    private final E[] endSorted;
    private static final RangeStartComparator startComparator = new RangeStartComparator();
    private static final RangeEndReverseComparator endReverseComparator = new RangeEndReverseComparator();

    protected IntervalTreeNode(int centerPoint, IntervalTreeNode left, IntervalTreeNode right, E[] elements) {
        this.centerPoint = centerPoint;
        this.left = left;
        this.right = right;
        this.startSorted = elements;
        this.endSorted = (Range[])Arrays.copyOf(elements, elements.length);
        Arrays.sort(this.startSorted, startComparator);
        Arrays.sort(this.endSorted, endReverseComparator);
    }

    protected void queryNode(ArrayList<E> results, int query) {
        if (query == this.centerPoint) {
            results.ensureCapacity(results.size() + this.startSorted.length);
            for (E e : this.startSorted) {
                results.add(e);
            }
        } else if (query < this.centerPoint) {
            for (E e : this.startSorted) {
                if (e.getStart() > query) break;
                results.add(e);
            }
            if (this.left != null) {
                this.left.queryNode(results, query);
            }
        } else {
            for (E e : this.endSorted) {
                if (e.getEnd() < query) break;
                results.add(e);
            }
            if (this.right != null) {
                this.right.queryNode(results, query);
            }
        }
    }
}

