/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.collections.intervaltree;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import umcg.genetica.collections.intervaltree.IntervalTreeNode;
import umcg.genetica.collections.intervaltree.Range;

public class IntervalTree<E extends Range> {
    private final IntervalTreeNode<E> rootNode;
    private final int size;
    private final Class<E> classE;

    public IntervalTree(E[] elements, Class<E> classE) {
        this(Arrays.asList(elements), classE);
    }

    public IntervalTree(List<E> elements, Class<E> classE) {
        for (Range e : elements) {
            if (e.getStart() <= e.getEnd()) continue;
            throw new IllegalArgumentException("Start is greater than end. This is not allowed in the interval tree.");
        }
        this.classE = classE;
        this.rootNode = this.createNode(elements);
        this.size = elements.size();
    }

    public ArrayList<E> getElementsOverlappingQuery(int query) {
        ArrayList results = new ArrayList();
        this.rootNode.queryNode(results, query);
        return results;
    }

    private IntervalTreeNode<E> createNode(List<E> elements) {
        ArrayList<Range> left = new ArrayList<Range>();
        ArrayList<Range> right = new ArrayList<Range>();
        ArrayList<Range> center = new ArrayList<Range>();
        Range centerElement = (Range)elements.get(elements.size() / 2);
        int centerPoint = centerElement.getStart();
        for (Range element : elements) {
            if (element.getEnd() < centerPoint) {
                left.add(element);
                continue;
            }
            if (element.getStart() > centerPoint) {
                right.add(element);
                continue;
            }
            center.add(element);
        }
        IntervalTreeNode leftNode = left.isEmpty() ? null : this.createNode(left);
        IntervalTreeNode rightNode = right.isEmpty() ? null : this.createNode(right);
        Range[] centerArray = (Range[])Array.newInstance(this.classE, center.size());
        return new IntervalTreeNode(centerPoint, leftNode, rightNode, center.toArray(centerArray));
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }
}

