/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.collections;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.molgenis.genotype.util.ChrPos;

public class ChrPosTreeMap<E>
implements Iterable<E> {
    private final HashMap<String, TreeMap<Integer, E>> data = new HashMap();

    public void put(String chr, Integer pos, E element) {
        TreeMap<Integer, Object> chrElements = this.data.get(chr);
        if (chrElements == null) {
            chrElements = new TreeMap();
            this.data.put(chr, chrElements);
        }
        chrElements.put(pos, element);
    }

    public E get(String chr, Integer pos) {
        TreeMap<Integer, E> chrElements = this.data.get(chr);
        if (chrElements == null) {
            return null;
        }
        return chrElements.get(pos);
    }

    public E remove(String chr, Integer pos) {
        TreeMap<Integer, E> chrElements = this.data.get(chr);
        if (chrElements == null) {
            return null;
        }
        return chrElements.remove(pos);
    }

    public Iterator<E> chrIterator(String chr) {
        TreeMap<Integer, E> chrElements = this.data.get(chr);
        if (chrElements == null) {
            return null;
        }
        return chrElements.values().iterator();
    }

    public Iterable<String> getChrs() {
        return this.data.keySet();
    }

    public Iterable<Integer> getChrPositions(String chr) {
        TreeMap<Integer, E> chrElements = this.data.get(chr);
        if (chrElements == null) {
            return null;
        }
        return chrElements.keySet();
    }

    public NavigableMap<Integer, E> getChrRange(String chr, Integer fromKey, boolean fromInclusive, Integer toKey, boolean toInclusive) {
        TreeMap<Integer, E> chrElements = this.data.get(chr);
        if (chrElements == null) {
            return Collections.emptyNavigableMap();
        }
        return chrElements.subMap(fromKey, fromInclusive, toKey, toInclusive);
    }

    public Iterator<ChrPos> getChrPosIterator() {
        Iterator[] chrIterators = new Iterator[this.data.size()];
        int i = 0;
        for (String chr : this.data.keySet()) {
            chrIterators[i] = Iterators.transform(this.data.get(chr).keySet().iterator(), (Function)new CreateChrPos(chr));
            ++i;
        }
        return Iterators.concat((Iterator[])chrIterators);
    }

    @Override
    public Iterator<E> iterator() {
        Iterator[] chrIterators = new Iterator[this.data.size()];
        int i = 0;
        for (TreeMap<Integer, E> chrData : this.data.values()) {
            chrIterators[i] = chrData.values().iterator();
            ++i;
        }
        return Iterators.concat((Iterator[])chrIterators);
    }

    public int size() {
        int count = 0;
        for (TreeMap<Integer, E> chrResults : this.data.values()) {
            count += chrResults.size();
        }
        return count;
    }

    private class CreateChrPos
    implements Function<Integer, ChrPos> {
        private final String chr;

        public CreateChrPos(String chr) {
            this.chr = chr;
        }

        public ChrPos apply(Integer input) {
            return new ChrPos(this.chr, input.intValue());
        }
    }
}

