/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.streams;

import com.mastfrog.util.streams.HashingInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class HashingOutputStream
extends FilterOutputStream {
    private final MessageDigest digest;
    private volatile boolean closed;

    public HashingOutputStream(String algorithm, OutputStream out) throws NoSuchAlgorithmException {
        super(out);
        this.digest = HashingInputStream.createDigest(algorithm);
    }

    public static HashingOutputStream sha1(OutputStream out) throws NoSuchAlgorithmException {
        return new HashingOutputStream("SHA-1", out);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        super.close();
    }

    public byte[] getDigest() {
        if (!this.closed) {
            throw new IllegalStateException("Stream not closed");
        }
        return this.digest.digest();
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        super.write(b);
        this.digest.update((byte)b);
    }

    public String getHashAsString() throws IOException {
        if (!this.closed) {
            this.close();
        }
        byte[] bytes = this.getDigest();
        return HashingOutputStream.hashString(bytes);
    }

    public static String hashString(byte[] bytes) {
        IntBuffer ib = ByteBuffer.wrap(bytes).asIntBuffer();
        StringBuilder sb = new StringBuilder();
        while (ib.position() < ib.capacity()) {
            long val = ib.get();
            if (val < 0L) {
                val = -val + Integer.MAX_VALUE;
            }
            sb.append(Long.toString(val, 36));
        }
        return sb.toString();
    }
}

