/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import no.uib.cipr.matrix.AbstractVector;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.io.MatrixVectorReader;
import no.uib.cipr.matrix.io.VectorInfo;
import no.uib.cipr.matrix.io.VectorSize;

public class DenseVector
extends AbstractVector
implements Serializable {
    private static final long serialVersionUID = 5358813524094629362L;
    private final double[] data;

    public DenseVector(MatrixVectorReader r) throws IOException {
        super(0);
        VectorInfo info = null;
        info = r.hasInfo() ? r.readVectorInfo() : new VectorInfo(true, VectorInfo.VectorField.Real);
        VectorSize size = r.readVectorSize(info);
        this.size = size.size();
        this.data = new double[size.size()];
        if (info.isPattern()) {
            throw new UnsupportedOperationException("Pattern vectors are not supported");
        }
        if (info.isComplex()) {
            throw new UnsupportedOperationException("Complex vectors are not supported");
        }
        if (info.isCoordinate()) {
            int nz = size.numEntries();
            int[] index = new int[nz];
            double[] entry = new double[nz];
            r.readCoordinate(index, entry);
            r.add(-1, index);
            for (int i = 0; i < nz; ++i) {
                this.set(index[i], entry[i]);
            }
        } else {
            r.readArray(this.data);
        }
    }

    public DenseVector(int size) {
        super(size);
        this.data = new double[size];
    }

    public DenseVector(Vector x) {
        this(x, true);
    }

    public DenseVector(Vector x, boolean deep) {
        super(x);
        if (deep) {
            this.data = new double[this.size];
            this.set(x);
        } else {
            this.data = ((DenseVector)x).getData();
        }
    }

    public DenseVector(double[] x, boolean deep) {
        super(x.length);
        this.data = deep ? (double[])x.clone() : x;
    }

    public DenseVector(double[] x) {
        this(x, true);
    }

    @Override
    public void set(int index, double value) {
        this.check(index);
        this.data[index] = value;
    }

    @Override
    public void add(int index, double value) {
        this.check(index);
        int n = index;
        this.data[n] = this.data[n] + value;
    }

    @Override
    public double get(int index) {
        this.check(index);
        return this.data[index];
    }

    @Override
    public DenseVector copy() {
        return new DenseVector(this);
    }

    @Override
    public DenseVector zero() {
        Arrays.fill(this.data, 0.0);
        return this;
    }

    @Override
    public DenseVector scale(double alpha) {
        int i = 0;
        while (i < this.size) {
            int n = i++;
            this.data[n] = this.data[n] * alpha;
        }
        return this;
    }

    @Override
    public Vector set(Vector y) {
        if (!(y instanceof DenseVector)) {
            return super.set(y);
        }
        this.checkSize(y);
        double[] yd = ((DenseVector)y).getData();
        System.arraycopy(yd, 0, this.data, 0, this.size);
        return this;
    }

    @Override
    public Vector set(double alpha, Vector y) {
        if (!(y instanceof DenseVector)) {
            return super.set(alpha, y);
        }
        this.checkSize(y);
        if (alpha == 0.0) {
            return this.zero();
        }
        double[] yd = ((DenseVector)y).getData();
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = alpha * yd[i];
        }
        return this;
    }

    @Override
    public Vector add(Vector y) {
        if (!(y instanceof DenseVector)) {
            return super.add(y);
        }
        this.checkSize(y);
        double[] yd = ((DenseVector)y).getData();
        for (int i = 0; i < this.size; ++i) {
            int n = i;
            this.data[n] = this.data[n] + yd[i];
        }
        return this;
    }

    @Override
    public Vector add(double alpha, Vector y) {
        if (!(y instanceof DenseVector)) {
            return super.add(alpha, y);
        }
        this.checkSize(y);
        if (alpha == 0.0) {
            return this;
        }
        double[] yd = ((DenseVector)y).getData();
        for (int i = 0; i < this.size; ++i) {
            int n = i;
            this.data[n] = this.data[n] + alpha * yd[i];
        }
        return this;
    }

    @Override
    public double dot(Vector y) {
        if (!(y instanceof DenseVector)) {
            return super.dot(y);
        }
        this.checkSize(y);
        double[] yd = ((DenseVector)y).getData();
        double dot = 0.0;
        for (int i = 0; i < this.size; ++i) {
            dot += this.data[i] * yd[i];
        }
        return dot;
    }

    @Override
    protected double norm1() {
        double sum = 0.0;
        for (int i = 0; i < this.size; ++i) {
            sum += Math.abs(this.data[i]);
        }
        return sum;
    }

    @Override
    protected double norm2() {
        double norm = 0.0;
        for (int i = 0; i < this.size; ++i) {
            norm += this.data[i] * this.data[i];
        }
        return Math.sqrt(norm);
    }

    @Override
    protected double norm2_robust() {
        double scale = 0.0;
        double ssq = 1.0;
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] == 0.0) continue;
            double absxi = Math.abs(this.data[i]);
            if (scale < absxi) {
                ssq = 1.0 + ssq * (scale / absxi) * (scale / absxi);
                scale = absxi;
                continue;
            }
            ssq += absxi / scale * (absxi / scale);
        }
        return scale * Math.sqrt(ssq);
    }

    @Override
    protected double normInf() {
        double max = 0.0;
        for (int i = 0; i < this.size; ++i) {
            max = Math.max(Math.abs(this.data[i]), max);
        }
        return max;
    }

    public double[] getData() {
        return this.data;
    }
}

