/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.fields.IntegerRing;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;

public final class MathInteger
extends Number
implements Comparable,
Ring.Member {
    private static final long serialVersionUID = 6893485894391864141L;
    private final int x;

    public MathInteger(int n) {
        this.x = n;
    }

    public MathInteger(String string) throws NumberFormatException {
        this.x = Integer.parseInt(string);
    }

    public boolean equals(Object object) {
        if (object instanceof MathInteger) {
            return this.x == ((MathInteger)object).value();
        }
        return false;
    }

    public int hashCode() {
        return this.x;
    }

    public int compareTo(Object object) throws IllegalArgumentException {
        if (object != null && object instanceof MathInteger) {
            int n = ((MathInteger)object).x;
            if (this.x == n) {
                return 0;
            }
            return this.x - n;
        }
        throw new IllegalArgumentException("Invalid object: " + object.getClass());
    }

    public String toString() {
        return Integer.toString(this.x);
    }

    public int value() {
        return this.x;
    }

    public int intValue() {
        return this.x;
    }

    public long longValue() {
        return this.x;
    }

    public float floatValue() {
        return this.x;
    }

    public double doubleValue() {
        return this.x;
    }

    public boolean isEven() {
        return (this.x & 1) == 0;
    }

    public boolean isOdd() {
        return (this.x & 1) == 1;
    }

    public Object getSet() {
        return IntegerRing.getInstance();
    }

    public AbelianGroup.Member negate() {
        return new MathInteger(-this.x);
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof MathInteger) {
            return this.add((MathInteger)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method: " + member.getClass());
    }

    public MathInteger add(MathInteger mathInteger) {
        return this.add(mathInteger.x);
    }

    public MathInteger add(int n) {
        return new MathInteger(this.x + n);
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof MathInteger) {
            return this.subtract((MathInteger)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method: " + member.getClass());
    }

    public MathInteger subtract(MathInteger mathInteger) {
        return this.subtract(mathInteger.x);
    }

    public MathInteger subtract(int n) {
        return new MathInteger(this.x - n);
    }

    public Ring.Member multiply(Ring.Member member) {
        if (member instanceof MathInteger) {
            return this.multiply((MathInteger)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method: " + member.getClass());
    }

    public MathInteger multiply(MathInteger mathInteger) {
        return this.multiply(mathInteger.x);
    }

    public MathInteger multiply(int n) {
        return new MathInteger(this.x * n);
    }

    public MathInteger pow(MathInteger mathInteger) {
        if (mathInteger.x == 0) {
            return IntegerRing.ONE;
        }
        int n = this.x;
        for (int i = 1; i < mathInteger.x; ++i) {
            n *= this.x;
        }
        return new MathInteger(n);
    }
}

