/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.variant;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.variant.GeneticVariantMeta;

public class GeneticVariantMetaMap
implements GeneticVariantMeta {
    private final Map<String, GeneticVariantMeta.Type> metaMap;
    private static final Map<String, GeneticVariantMeta.Type> RESEVERED_IDS;
    private static final GeneticVariantMetaMap GT_META_MAP;
    private static final GeneticVariantMetaMap GP_META_MAP;

    private GeneticVariantMetaMap(Map<String, GeneticVariantMeta.Type> metaMap) {
        this.metaMap = metaMap;
    }

    public static GeneticVariantMeta getGeneticVariantMetaGt() {
        return GT_META_MAP;
    }

    public static GeneticVariantMeta getGeneticVariantMetaGp() {
        return GP_META_MAP;
    }

    public static GeneticVariantMeta createGeneticVariantMeta(Map<String, GeneticVariantMeta.Type> metaMap) {
        for (Map.Entry<String, GeneticVariantMeta.Type> entry : metaMap.entrySet()) {
            if (!GeneticVariantMetaMap.checkNotOverwriteReserved(entry.getKey(), entry.getValue())) continue;
            throw new GenotypeDataException("Using illegal genotype field: " + entry.getKey() + " is reserved for: " + (Object)((Object)RESEVERED_IDS.get(entry.getKey())));
        }
        return new GeneticVariantMetaMap(Collections.unmodifiableMap(metaMap));
    }

    private static boolean checkNotOverwriteReserved(String id, GeneticVariantMeta.Type type) {
        if (RESEVERED_IDS.containsKey(id)) {
            return !RESEVERED_IDS.get(id).equals((Object)type);
        }
        return false;
    }

    @Override
    public Iterable<String> getRecordIds() {
        return this.metaMap.keySet();
    }

    @Override
    public GeneticVariantMeta.Type getRecordType(String recordId) {
        return this.metaMap.get(recordId);
    }

    static {
        GT_META_MAP = new GeneticVariantMetaMap(Collections.singletonMap("GT", GeneticVariantMeta.Type.ALLELES));
        GP_META_MAP = new GeneticVariantMetaMap(Collections.singletonMap("GP", GeneticVariantMeta.Type.FLOAT_LIST));
        HashMap<String, GeneticVariantMeta.Type> reservedIdsTmp = new HashMap<String, GeneticVariantMeta.Type>();
        reservedIdsTmp.put("GT", GeneticVariantMeta.Type.ALLELES);
        reservedIdsTmp.put("GP", GeneticVariantMeta.Type.FLOAT_LIST);
        reservedIdsTmp.put("DS", GeneticVariantMeta.Type.FLOAT);
        RESEVERED_IDS = Collections.unmodifiableMap(reservedIdsTmp);
    }
}

