/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.trityper;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.molgenis.genotype.AbstractRandomAccessGenotypeData;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.Sequence;
import org.molgenis.genotype.SimpleSequence;
import org.molgenis.genotype.annotation.Annotation;
import org.molgenis.genotype.annotation.CaseControlAnnotation;
import org.molgenis.genotype.annotation.SampleAnnotation;
import org.molgenis.genotype.annotation.SexAnnotation;
import org.molgenis.genotype.sampleFilter.SampleFilter;
import org.molgenis.genotype.sampleFilter.SampleIncludedFilter;
import org.molgenis.genotype.trityper.TriTyperAlleleAnnotation;
import org.molgenis.genotype.util.CalledDosageConvertor;
import org.molgenis.genotype.util.FixedSizeIterable;
import org.molgenis.genotype.util.ProbabilitiesConvertor;
import org.molgenis.genotype.util.RecordIteratorCreators;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variant.GeneticVariantMeta;
import org.molgenis.genotype.variant.GeneticVariantMetaMap;
import org.molgenis.genotype.variant.GenotypeRecord;
import org.molgenis.genotype.variant.ReadOnlyGeneticVariantTriTyper;
import org.molgenis.genotype.variant.range.GeneticVariantRange;
import org.molgenis.genotype.variant.sampleProvider.CachedSampleVariantProvider;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantUniqueIdProvider;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantsProvider;
import org.molgenis.genotype.variantFilter.VariantFilter;

public class TriTyperGenotypeData
extends AbstractRandomAccessGenotypeData
implements SampleVariantsProvider {
    private final List<Boolean> samplePhasing;
    private final GeneticVariantRange snps;
    private final SampleVariantsProvider variantProvider;
    private final File genotypeDataFile;
    private final File imputedDosageDataFile;
    private final File snpFile;
    private final File snpMapFile;
    private final File individualFile;
    private final File phenotypeAnnotationFile;
    private static final Logger LOG = Logger.getLogger(TriTyperGenotypeData.class);
    private final int cacheSize;
    private final RandomAccessFile dosageHandle;
    private final RandomAccessFile genotypeHandle;
    private final FileChannel dosageChannel;
    private final int sampleVariantProviderUniqueId;
    private HashMap<String, SampleAnnotation> sampleAnnotationMap;
    private HashMap<String, Sequence> sequences;
    private final VariantFilter variantFilter;
    private final SampleFilter sampleFilter;
    private int unfilteredSnpCount;
    private final GeneticVariantMeta geneticVariantMeta;
    private final File alleleRecodeFile;
    private final HashMap<String, Allele[]> allelRecodingInfo;
    private List<Sample> includedSamples;
    private ArrayList<Sample> samples;

    public TriTyperGenotypeData(String location) throws IOException {
        this(new File(location), 1024, null, null);
    }

    public TriTyperGenotypeData(String location, int cacheSize) throws IOException {
        this(new File(location), cacheSize, null, null);
    }

    public TriTyperGenotypeData(String location, int cacheSize, VariantFilter variantFilter) throws IOException {
        this(new File(location), cacheSize, variantFilter, null);
    }

    public TriTyperGenotypeData(String location, int cacheSize, VariantFilter variantFilter, boolean readOnlyIncludedIndividuals) throws IOException {
        this(new File(location), cacheSize, variantFilter, readOnlyIncludedIndividuals ? new SampleIncludedFilter() : null);
    }

    public TriTyperGenotypeData(File location) throws IOException {
        this(location, 1024, null, null);
    }

    public TriTyperGenotypeData(File location, int cacheSize, VariantFilter variantFilter, boolean readOnlyIncludedIndividuals) throws IOException {
        this(location, cacheSize, variantFilter, readOnlyIncludedIndividuals ? new SampleIncludedFilter() : null);
    }

    public TriTyperGenotypeData(File location, int cacheSize, VariantFilter variantFilter, SampleFilter sampleFilter) throws IOException {
        this(new File(location, "GenotypeMatrix.dat"), new File(location, "ImputedDosageMatrix.dat").exists() ? new File(location, "ImputedDosageMatrix.dat") : null, new File(location, "SNPs.txt.gz").exists() ? new File(location, "SNPs.txt.gz") : new File(location, "SNPs.txt"), new File(location, "SNPMappings.txt.gz").exists() ? new File(location, "SNPMappings.txt.gz") : new File(location, "SNPMappings.txt"), new File(location, "Individuals.txt.gz").exists() ? new File(location, "Individuals.txt.gz") : new File(location, "Individuals.txt"), new File(location, "PhenotypeInformation.txt.gz").exists() ? new File(location, "PhenotypeInformation.txt.gz") : new File(location, "PhenotypeInformation.txt"), cacheSize, variantFilter, sampleFilter, new File(location, "AlleleRecodingInformation.txt").exists() ? new File(location, "AlleleRecodingInformation.txt") : null);
    }

    public TriTyperGenotypeData(File genotypeDataFile, File imputedDosageDataFile, File snpFile, File snpMapFile, File individualFile, File phenotypeAnnotationFile, int cacheSize, VariantFilter variantFilter, SampleFilter sampleFilter, File allelRecoding) throws IOException {
        this.variantFilter = variantFilter;
        this.sampleFilter = sampleFilter;
        this.sampleVariantProviderUniqueId = SampleVariantUniqueIdProvider.getNextUniqueId();
        this.variantProvider = cacheSize <= 0 ? this : new CachedSampleVariantProvider(this, cacheSize);
        this.cacheSize = cacheSize;
        this.genotypeDataFile = genotypeDataFile;
        if (!genotypeDataFile.exists()) {
            throw new GenotypeDataException("GenotypeMatrix.dat not found at: " + genotypeDataFile.getAbsolutePath());
        }
        this.imputedDosageDataFile = imputedDosageDataFile;
        if (this.imputedDosageDataFile != null && !this.imputedDosageDataFile.exists()) {
            throw new GenotypeDataException("ImputedDosageMatrix.dat not found at:" + this.imputedDosageDataFile.getAbsolutePath());
        }
        this.snpFile = snpFile;
        if (!this.snpFile.exists()) {
            throw new GenotypeDataException("SNPs.txt or SNPs.txt.gz at:" + this.snpFile.getAbsolutePath());
        }
        this.snpMapFile = snpMapFile;
        if (!this.snpMapFile.exists()) {
            throw new GenotypeDataException("SNPMappings.txt or SNPMappings.txt.gz at:" + this.snpMapFile.getAbsolutePath());
        }
        this.individualFile = individualFile;
        if (!this.individualFile.exists()) {
            throw new GenotypeDataException("Individuals.txt or Individuals.txt.gz at:" + this.individualFile.getAbsolutePath());
        }
        this.phenotypeAnnotationFile = phenotypeAnnotationFile;
        if (!this.phenotypeAnnotationFile.exists()) {
            throw new GenotypeDataException("PhenotypeInformation.txt or PhenotypeInformation.txt.gz at:" + this.phenotypeAnnotationFile.getAbsolutePath());
        }
        this.alleleRecodeFile = allelRecoding;
        if (this.alleleRecodeFile != null && this.alleleRecodeFile.exists()) {
            BufferedReader recodeReader = new BufferedReader(new FileReader(this.alleleRecodeFile));
            String line = recodeReader.readLine();
            this.allelRecodingInfo = new HashMap();
            while ((line = recodeReader.readLine()) != null) {
                String[] lineParts = StringUtils.split((String)line, (char)'\t');
                Allele[] recode = new Allele[]{Allele.create(lineParts[3]), Allele.create(lineParts[4])};
                this.allelRecodingInfo.put(lineParts[0], recode);
            }
            recodeReader.close();
        } else {
            this.allelRecodingInfo = null;
        }
        if (imputedDosageDataFile != null) {
            this.dosageHandle = new RandomAccessFile(imputedDosageDataFile, "r");
            this.dosageChannel = this.dosageHandle.getChannel();
            HashMap<String, GeneticVariantMeta.Type> variantMeta = new HashMap<String, GeneticVariantMeta.Type>(2);
            variantMeta.put("GT", GeneticVariantMeta.Type.ALLELES);
            variantMeta.put("DS", GeneticVariantMeta.Type.FLOAT);
            this.geneticVariantMeta = GeneticVariantMetaMap.createGeneticVariantMeta(variantMeta);
        } else {
            this.dosageHandle = null;
            this.dosageChannel = null;
            this.geneticVariantMeta = GeneticVariantMetaMap.getGeneticVariantMetaGt();
        }
        this.genotypeHandle = new RandomAccessFile(genotypeDataFile, "r");
        this.loadSamples();
        this.samplePhasing = Collections.nCopies(this.includedSamples.size(), false);
        GeneticVariantRange.GeneticVariantRangeCreate snpsFactory = GeneticVariantRange.createRangeFactory();
        this.loadSNPAnnotation(snpsFactory);
        this.snps = snpsFactory.createRange();
        this.checkFileSize();
    }

    @Override
    public GeneticVariant getSnpVariantByPos(String seqName, int startPos) {
        Iterable<GeneticVariant> variants = this.getVariantsByPos(seqName, startPos);
        Iterator<GeneticVariant> iterator = variants.iterator();
        if (iterator.hasNext()) {
            GeneticVariant variant = iterator.next();
            return variant;
        }
        return null;
    }

    private void loadSamples() throws IOException {
        String[] elements;
        String line;
        int i = 0;
        HashMap<String, Sample> sampleNameToSampleObj = new HashMap<String, Sample>();
        this.samples = new ArrayList();
        BufferedReader individualReader = new BufferedReader(new FileReader(this.individualFile));
        while ((line = individualReader.readLine()) != null) {
            elements = StringUtils.split((String)line, (char)'\t');
            String individual = elements[0];
            Sample sample = new Sample(individual, null, null);
            sampleNameToSampleObj.put(individual, sample);
            this.samples.add(sample);
            ++i;
        }
        individualReader.close();
        BufferedReader phenotypeReader = new BufferedReader(new FileReader(this.phenotypeAnnotationFile));
        int numIncluded = 0;
        int numFemale = 0;
        int numMale = 0;
        int numUnknownSex = 0;
        int numCase = 0;
        int numControl = 0;
        int numUnknown = 0;
        boolean numAnnotated = false;
        HashSet<Sample> visitedSamples = new HashSet<Sample>();
        while ((line = phenotypeReader.readLine()) != null) {
            CaseControlAnnotation caseControlStatus;
            elements = StringUtils.split((String)line, (char)'\t');
            String individual = elements[0];
            Sample sampleObj = (Sample)sampleNameToSampleObj.get(individual);
            if (sampleObj == null) continue;
            if (elements.length < 4) {
                throw new GenotypeDataException("Error parsing phenotype for sample: " + individual + " expected 4 columns but found: " + elements.length);
            }
            if (visitedSamples.contains(sampleObj)) {
                LOG.warn((Object)("Sample " + sampleObj.getId() + " may have duplicate annotation in PhenotypeInformation.txt."));
                continue;
            }
            Boolean includeSample = this.parseIncludeExcludeStatus(elements[2]);
            if (!includeSample.booleanValue()) {
                ++numIncluded;
            }
            if ((caseControlStatus = CaseControlAnnotation.getCaseAnnotationForTriTyper(elements[1])) == CaseControlAnnotation.CASE) {
                ++numCase;
            } else if (caseControlStatus == CaseControlAnnotation.CONTROL) {
                ++numControl;
            } else {
                ++numUnknown;
            }
            SexAnnotation sex = SexAnnotation.getSexAnnotationForTriTyper(elements[3]);
            if (sex == SexAnnotation.FEMALE) {
                ++numFemale;
            } else if (sex == SexAnnotation.MALE) {
                ++numMale;
            } else {
                ++numUnknownSex;
            }
            sampleObj.putAnnotationValues("sampleInclude", includeSample);
            sampleObj.putAnnotationValues("caseControl", (Object)caseControlStatus);
            sampleObj.putAnnotationValues("sex_generic", (Object)sex);
            visitedSamples.add(sampleObj);
        }
        phenotypeReader.close();
        if (this.sampleFilter != null) {
            this.includedSamples = new ArrayList<Sample>(numIncluded);
            for (Sample sample : this.samples) {
                if (!this.sampleFilter.doesSamplePassFilter(sample)) continue;
                this.includedSamples.add(sample);
            }
        } else {
            this.includedSamples = this.samples;
        }
        this.includedSamples = Collections.unmodifiableList(this.includedSamples);
        LOG.info((Object)("Loaded " + this.includedSamples.size() + " out of " + this.samples.size() + " samples."));
        this.sampleAnnotationMap = new HashMap(3);
        this.sampleAnnotationMap.put("sampleInclude", new SampleAnnotation("sampleInclude", "sampleInclude", null, Annotation.Type.BOOLEAN, SampleAnnotation.SampleAnnotationType.OTHER, false));
        this.sampleAnnotationMap.put("caseControl", new SampleAnnotation("caseControl", "caseControl", null, Annotation.Type.CASECONTROL, SampleAnnotation.SampleAnnotationType.PHENOTYPE, false));
        this.sampleAnnotationMap.put("sex_generic", new SampleAnnotation("sex_generic", "sex_generic", null, Annotation.Type.SEX, SampleAnnotation.SampleAnnotationType.COVARIATE, false));
    }

    private Boolean parseIncludeExcludeStatus(String status) {
        if (status == null) {
            return false;
        }
        if (status.toLowerCase().equals("exclude")) {
            return false;
        }
        if (status.toLowerCase().equals("include")) {
            return true;
        }
        return false;
    }

    private void loadSNPAnnotation(GeneticVariantRange.GeneticVariantRangeCreate snpsFactory) throws IOException {
        String line;
        this.unfilteredSnpCount = 0;
        TObjectIntHashMap allSNPHash = new TObjectIntHashMap();
        BufferedReader snpFileReader = new BufferedReader(new FileReader(this.snpFile));
        while ((line = snpFileReader.readLine()) != null) {
            if (allSNPHash.contains((Object)line)) {
                throw new GenotypeDataException("SNP found twice: " + line + ". All SNP ID's must be unique");
            }
            if (this.variantFilter == null || this.variantFilter.doesIdPassFilter(line)) {
                allSNPHash.put((Object)line, this.unfilteredSnpCount);
            }
            ++this.unfilteredSnpCount;
        }
        snpFileReader.close();
        int numberOfIncludedSNPsWithAnnotation = 0;
        this.sequences = new HashMap();
        int lineCount = 0;
        BufferedReader snpMapFileReader = new BufferedReader(new FileReader(this.snpMapFile));
        while ((line = snpMapFileReader.readLine()) != null) {
            String[] chrPosId = StringUtils.split((String)line, (char)'\t');
            ++lineCount;
            if (chrPosId.length != 3) {
                throw new GenotypeDataException("Error in Trityper SNPMappings.txt. Line number " + lineCount + " does not contain 3 elements: ");
            }
            if (!allSNPHash.containsKey((Object)chrPosId[2])) continue;
            String snp = new String(chrPosId[2]);
            int pos = 0;
            String chr = chrPosId[0].intern();
            if (!this.sequences.containsKey(chr) && !chr.equals("0")) {
                this.sequences.put(chr, new SimpleSequence(chr, 0, this));
            }
            try {
                pos = Integer.parseInt(chrPosId[1]);
            }
            catch (NumberFormatException e) {
                throw new GenotypeDataException("Position defined for " + snp + " on chromosome " + chr + " is not an integer: " + chrPosId[1]);
            }
            ReadOnlyGeneticVariantTriTyper variant = new ReadOnlyGeneticVariantTriTyper(snp, pos, chr, this.variantProvider, allSNPHash.remove((Object)snp), this.geneticVariantMeta);
            if (this.variantFilter != null && !this.variantFilter.doesVariantPassFilter(variant)) continue;
            snpsFactory.addVariant(variant);
            ++numberOfIncludedSNPsWithAnnotation;
        }
        snpMapFileReader.close();
        for (String variantId : allSNPHash.keySet()) {
            ReadOnlyGeneticVariantTriTyper variant = new ReadOnlyGeneticVariantTriTyper(variantId, 0, "0", this.variantProvider, allSNPHash.get((Object)variantId), this.geneticVariantMeta);
            if (this.variantFilter != null && !this.variantFilter.doesVariantPassFilter(variant)) continue;
            snpsFactory.addVariant(variant);
        }
        LOG.info((Object)("Loaded " + snpsFactory.size() + " out of " + this.unfilteredSnpCount + " SNPs, " + numberOfIncludedSNPsWithAnnotation + " of loaded SNPs have annotation."));
    }

    private void checkFileSize() {
        long detectedsize;
        long expectedfilesize = (long)(this.unfilteredSnpCount * 2) * (long)this.samples.size();
        if (expectedfilesize != (detectedsize = this.genotypeDataFile.length())) {
            throw new GenotypeDataException("Size of GenotypeMatrix.dat does not match size defined by Indivuals.txt and SNPs.txt. Expected size: " + expectedfilesize + " (" + TriTyperGenotypeData.humanizeFileSize(expectedfilesize) + ")\tDetected size: " + detectedsize + " (" + TriTyperGenotypeData.humanizeFileSize(detectedsize) + ")\tDiff: " + Math.abs(expectedfilesize - detectedsize));
        }
        if (this.imputedDosageDataFile != null && (expectedfilesize = (long)this.unfilteredSnpCount * (long)this.samples.size()) != (detectedsize = this.imputedDosageDataFile.length())) {
            throw new GenotypeDataException("Size of ImputedDosageMatrix.dat does not match size defined by Indivuals.txt and SNPs.txt. Expected size: " + expectedfilesize + " (" + TriTyperGenotypeData.humanizeFileSize(expectedfilesize) + ")\tDetected size: " + detectedsize + " (" + TriTyperGenotypeData.humanizeFileSize(detectedsize) + ")\tDiff: " + Math.abs(expectedfilesize - detectedsize));
        }
    }

    @Override
    public boolean isOnlyContaingSaveProbabilityGenotypes() {
        return this.imputedDosageDataFile == null;
    }

    @Override
    public float[][] getSampleProbilities(GeneticVariant variant) {
        return ProbabilitiesConvertor.convertDosageToProbabilityHeuristic(variant.getSampleDosages());
    }

    @Override
    public List<Alleles> getSampleVariants(GeneticVariant variant) {
        long index = ((ReadOnlyGeneticVariantTriTyper)variant).getIndexOfVariantInTriTyperData();
        int numIndividuals = this.samples.size();
        long indexLong = index * (long)(numIndividuals * 2);
        byte[] buffer = new byte[2 * numIndividuals];
        try {
            this.genotypeHandle.seek(indexLong);
            if (this.genotypeHandle.read(buffer) != buffer.length) {
                LOG.fatal((Object)("ERROR loading trityper SNP: " + variant.getPrimaryVariantId() + " at: " + variant.getSequenceName() + ":" + variant.getStartPos() + " variant index: " + index));
                throw new GenotypeDataException("Could not read bytes from: " + indexLong + " in genotype file " + this.genotypeDataFile.getAbsolutePath() + " (size: " + this.genotypeDataFile.length() + ")");
            }
        }
        catch (IOException e) {
            LOG.fatal((Object)("ERROR loading trityper SNP: " + variant.getPrimaryVariantId() + " at: " + variant.getSequenceName() + ":" + variant.getStartPos() + " variant index: " + index));
            throw new GenotypeDataException("Could not read bytes from: " + indexLong + " in genotype file " + this.genotypeDataFile.getAbsolutePath() + " (size: " + this.genotypeDataFile.length() + ")", e);
        }
        ArrayList<Alleles> alleles = new ArrayList<Alleles>(this.includedSamples.size());
        for (int i = 0; i < numIndividuals; ++i) {
            if (this.sampleFilter != null && !this.sampleFilter.doesSamplePassFilter(this.samples.get(i))) continue;
            int allele2Pos = numIndividuals + i;
            Alleles a = Alleles.createAlleles(TriTyperAlleleAnnotation.convertByteToAllele(buffer[i]), TriTyperAlleleAnnotation.convertByteToAllele(buffer[allele2Pos]));
            alleles.add(a);
        }
        if (this.alleleRecodeFile != null && this.allelRecodingInfo != null && this.allelRecodingInfo.containsKey(variant.getPrimaryVariantId())) {
            Allele[] recodingInfo = this.allelRecodingInfo.get(variant.getPrimaryVariantId());
            for (int i = 0; i < alleles.size(); ++i) {
                Allele[] originalAllels = new Allele[2];
                for (int j = 0; j < ((Alleles)alleles.get(i)).getAlleleCount(); ++j) {
                    originalAllels[j] = ((Alleles)alleles.get(i)).getAlleles().get(j) == Allele.A ? recodingInfo[0] : recodingInfo[1];
                }
                alleles.set(i, Alleles.createAlleles(originalAllels[0], originalAllels[1]));
            }
        }
        return alleles;
    }

    @Override
    public float[] getSampleDosage(GeneticVariant variant) {
        if (variant.getVariantAlleles().getAlleles().isEmpty()) {
            float[] dosageValuesFloat = new float[this.includedSamples.size()];
            for (int i = 0; i < dosageValuesFloat.length; ++i) {
                dosageValuesFloat[i] = -1.0f;
            }
            return dosageValuesFloat;
        }
        float[] genotypes = CalledDosageConvertor.convertCalledAllelesToDosage(variant.getSampleVariants(), variant.getVariantAlleles(), variant.getRefAllele());
        if (this.imputedDosageDataFile != null) {
            int ind;
            byte[] dosageValues;
            int index = ((ReadOnlyGeneticVariantTriTyper)variant).getIndexOfVariantInTriTyperData();
            int numIndividuals = this.samples.size();
            long indexLong = (long)index * (long)numIndividuals;
            ByteBuffer buffer = ByteBuffer.allocate(numIndividuals);
            try {
                this.dosageChannel.read(buffer, indexLong);
            }
            catch (IOException e) {
                throw new GenotypeDataException("Could not read bytes from: " + indexLong + " in genotype file " + this.genotypeDataFile.getAbsolutePath() + " (size: " + this.genotypeDataFile.length() + ")");
            }
            byte[] dosageValuesAll = buffer.array();
            if (this.sampleFilter == null) {
                dosageValues = dosageValuesAll;
            } else {
                dosageValues = new byte[this.includedSamples.size()];
                int j = 0;
                for (int i = 0; i < dosageValuesAll.length; ++i) {
                    if (!this.sampleFilter.doesSamplePassFilter(this.samples.get(i))) continue;
                    dosageValues[j] = dosageValuesAll[i];
                    ++j;
                }
            }
            boolean takeComplement = false;
            for (ind = 0; ind < dosageValues.length; ++ind) {
                if (dosageValues[ind] == 127) continue;
                double dosagevalue = (double)(128 + dosageValues[ind]) / 100.0;
                if (genotypes[ind] == 0.0f && dosagevalue > 1.0) {
                    takeComplement = true;
                    break;
                }
                if (genotypes[ind] != 2.0f || !(dosagevalue < 1.0)) continue;
                takeComplement = true;
                break;
            }
            if (takeComplement) {
                for (ind = 0; ind < dosageValues.length; ++ind) {
                    byte dosageValue;
                    if (dosageValues[ind] == 127) continue;
                    dosageValues[ind] = dosageValue = (byte)(200 - (128 + dosageValues[ind]) + -128);
                }
            }
            float[] dosageValuesFloat = new float[this.includedSamples.size()];
            for (int i = 0; i < dosageValues.length; ++i) {
                dosageValuesFloat[i] = dosageValues[i] == 127 ? -1.0f : (float)(128 + dosageValues[i]) / 100.0f;
            }
            return dosageValuesFloat;
        }
        return genotypes;
    }

    @Override
    public byte[] getSampleCalledDosage(GeneticVariant variant) {
        byte[] genotypes = CalledDosageConvertor.convertCalledAllelesToCalledDosage(this.variantProvider.getSampleVariants(variant), variant.getVariantAlleles(), variant.getRefAllele());
        return genotypes;
    }

    @Override
    public List<Sample> getSamples() {
        return this.includedSamples;
    }

    @Override
    public List<Boolean> getSamplePhasing(GeneticVariant variant) {
        return this.samplePhasing;
    }

    @Override
    public int cacheSize() {
        return this.cacheSize;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.imputedDosageDataFile != null) {
                this.dosageChannel.close();
                this.dosageHandle.close();
            }
            this.genotypeHandle.close();
        }
        catch (IOException e) {
            throw new GenotypeDataException("Could not close file handle to TriTyper file: " + this.genotypeDataFile);
        }
    }

    @Override
    public int getSampleVariantProviderUniqueId() {
        return this.sampleVariantProviderUniqueId;
    }

    @Override
    public Map<String, SampleAnnotation> getSampleAnnotationsMap() {
        return this.sampleAnnotationMap;
    }

    @Override
    public Map<String, Annotation> getVariantAnnotationsMap() {
        return Collections.emptyMap();
    }

    @Override
    public List<String> getSeqNames() {
        return new ArrayList<String>(this.sequences.keySet());
    }

    @Override
    public Iterable<Sequence> getSequences() {
        return this.sequences.values();
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByPos(String seqName, int startPos) {
        return this.snps.getVariantAtPos(seqName, startPos);
    }

    @Override
    public Iterable<GeneticVariant> getSequenceGeneticVariants(String seqName) {
        return this.snps.getVariantsBySequence(seqName);
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByRange(String seqName, int rangeStart, int rangeEnd) {
        return this.snps.getVariantsByRange(seqName, rangeStart, rangeEnd);
    }

    @Override
    public Iterator<GeneticVariant> iterator() {
        return this.snps.iterator();
    }

    private static String humanizeFileSize(long s) {
        String output = "";
        DecimalFormat df = new DecimalFormat("##.##");
        if (s == 0L) {
            output = "0b";
        } else if (s > 0x10000000000L) {
            double nrtb = (double)s / 1.099511627776E12;
            output = df.format(nrtb) + " TB";
        } else if (s > 0x40000000L) {
            double nrtb = (double)s / 1.073741824E9;
            output = df.format(nrtb) + " GB";
        } else if (s > 0x100000L) {
            double nrtb = (double)s / 1048576.0;
            output = df.format(nrtb) + " MB";
        } else if (s > 1024L) {
            double nrtb = (double)s / 1024.0;
            output = df.format(nrtb) + " KB";
        }
        return output;
    }

    @Override
    public FixedSizeIterable<GenotypeRecord> getSampleGenotypeRecords(GeneticVariant variant) {
        if (this.imputedDosageDataFile != null) {
            return new FixedSizeIterableTriTyper(variant);
        }
        return RecordIteratorCreators.createIteratorFromAlleles(variant.getSampleVariants());
    }

    private class FixedSizeIterableTriTyper
    implements FixedSizeIterable<GenotypeRecord> {
        private final List<Alleles> alleles;
        private final float[] dosages;

        public FixedSizeIterableTriTyper(GeneticVariant variant) {
            this.alleles = variant.getSampleVariants();
            this.dosages = variant.getSampleDosages();
        }

        @Override
        public int size() {
            return this.alleles.size();
        }

        @Override
        public Iterator<GenotypeRecord> iterator() {
            return new Iterator<GenotypeRecord>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i + 1 < FixedSizeIterableTriTyper.this.alleles.size();
                }

                @Override
                public GenotypeRecord next() {
                    ++this.i;
                    return new TriTyperGenotypeRecord(this.i);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported ever yet.");
                }
            };
        }

        private class TriTyperGenotypeRecord
        implements GenotypeRecord {
            private final int i;

            public TriTyperGenotypeRecord(int i) {
                this.i = i;
            }

            @Override
            public Object getGenotypeRecordData(String recordId) {
                if (recordId.equals("GT")) {
                    return FixedSizeIterableTriTyper.this.alleles.get(this.i);
                }
                if (recordId.equals("DS")) {
                    return Float.valueOf(FixedSizeIterableTriTyper.this.dosages[this.i]);
                }
                return null;
            }

            @Override
            public Alleles getSampleAlleles() {
                return (Alleles)FixedSizeIterableTriTyper.this.alleles.get(this.i);
            }

            @Override
            public float[] getSampleProbs() {
                return null;
            }

            @Override
            public float getSampleDosage() {
                return FixedSizeIterableTriTyper.this.dosages[this.i];
            }

            @Override
            public boolean containsGenotypeRecord(String recordId) {
                return recordId.equals("GT") | recordId.equals("DS");
            }
        }
    }
}

