/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.plink.readers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.annotation.SexAnnotation;

public class FamFileReader {
    private static final Charset FILE_ENCODING = Charset.forName("UTF-8");
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile("[ \\t]+");
    private static final Logger LOGGER = Logger.getLogger(FamFileReader.class);

    public static ArrayList<Sample> readFamFile(String famFilePath) throws FileNotFoundException, IOException {
        return FamFileReader.readFamFile(new File(famFilePath));
    }

    public static ArrayList<Sample> readFamFile(File famFile) throws FileNotFoundException, IOException {
        String line;
        ArrayList<Sample> samples = new ArrayList<Sample>();
        BufferedReader famFileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(famFile), FILE_ENCODING));
        while ((line = famFileReader.readLine()) != null) {
            String[] elements = SEPARATOR_PATTERN.split(line);
            LinkedHashMap<String, Object> annotationValues = new LinkedHashMap<String, Object>();
            annotationValues.put("fatherId", elements[2]);
            annotationValues.put("motherId", elements[3]);
            annotationValues.put("sex_generic", (Object)SexAnnotation.getSexAnnotationForPlink(Byte.parseByte(elements[4])));
            annotationValues.put("phenotype", Double.parseDouble(elements[5]));
            samples.add(new Sample(elements[1], elements[0], annotationValues));
        }
        LOGGER.info((Object)("Read " + samples.size() + " samples from " + famFile.getAbsolutePath()));
        famFileReader.close();
        return samples;
    }
}

