/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.oxford;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.log4j.Logger;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.variant.range.GeneticVariantRange;

public class BgenGenotypeData {
    private static final double DEFAULT_MINIMUM_POSTERIOR_PROBABILITY_TO_CALL = (double)0.4f;
    private final RandomAccessFile bgenFile;
    private final byte[] byteArray4 = new byte[4];
    private static final Logger LOGGER = Logger.getLogger(BgenGenotypeData.class);
    private final boolean compressedGenotypes;
    private final boolean v1_1;
    private final Inflater inflater = new Inflater();
    private static final Charset charset = Charset.forName("UTF-8");

    public BgenGenotypeData(File bgenFile, File sampleFile) throws IOException {
        this(bgenFile, sampleFile, 1000);
    }

    public BgenGenotypeData(File bgenFile, File sampleFile, int cacheSize) throws IOException {
        this(bgenFile, sampleFile, cacheSize, 0.4f);
    }

    public BgenGenotypeData(File bgenFile, File sampleFile, int cacheSize, double minimumPosteriorProbabilityToCall) throws IOException {
        this.bgenFile = new RandomAccessFile(bgenFile, "r");
        if (this.bgenFile.read(this.byteArray4, 0, 4) != 4) {
            throw new GenotypeDataException("Error reading bgen file header. File is corrupt");
        }
        long snpOffset = this.getUInt32(this.byteArray4, 0);
        LOGGER.debug((Object)("SNP offset: " + snpOffset));
        if (this.bgenFile.read(this.byteArray4, 0, 4) != 4) {
            throw new GenotypeDataException("Error reading bgen file header. File is corrupt");
        }
        long headerSize = this.getUInt32(this.byteArray4, 0);
        LOGGER.debug((Object)("Header size: " + headerSize));
        if (this.bgenFile.read(this.byteArray4, 0, 4) != 4) {
            throw new GenotypeDataException("Error reading bgen file header. File is corrupt");
        }
        long snpCount = this.getUInt32(this.byteArray4, 0);
        LOGGER.debug((Object)("Number of SNPs: " + snpCount));
        if (snpCount > Integer.MAX_VALUE) {
            throw new GenotypeDataException("Found more than (2^31)-1 SNPs in bgen file. This is not supported");
        }
        if (this.bgenFile.read(this.byteArray4, 0, 4) != 4) {
            throw new GenotypeDataException("Error reading bgen file header. File is corrupt");
        }
        long sampleCount = this.getUInt32(this.byteArray4, 0);
        LOGGER.debug((Object)("Number of samples: " + sampleCount));
        this.bgenFile.seek(headerSize);
        if (this.bgenFile.read(this.byteArray4, 0, 4) != 4) {
            throw new GenotypeDataException("Error reading bgen file header. File is corrupt");
        }
        if ((this.byteArray4[0] & 1) == 1) {
            LOGGER.debug((Object)"Genotype data is compressed");
            this.compressedGenotypes = true;
        } else {
            LOGGER.debug((Object)"Genotype data is not compressed");
            this.compressedGenotypes = false;
        }
        if ((this.byteArray4[0] & 3) != 1) {
            LOGGER.debug((Object)"v1.0 gen file");
            this.v1_1 = false;
            throw new GenotypeDataException("bgen version v1.0 is not supported at the moment. Feel free to contact the developers of Genotype IO");
        }
        LOGGER.debug((Object)"v1.1 gen file");
        this.v1_1 = true;
        GeneticVariantRange.createRangeFactory((int)snpCount);
        byte[] snpInfoBuffer = new byte[8096];
        this.bgenFile.seek(snpOffset + 4L);
        long lastSnpStart = snpOffset + 4L;
        int snpI = 0;
        while ((long)snpI < snpCount) {
            int snpInfoBufferSize = this.bgenFile.read(snpInfoBuffer, 0, snpInfoBuffer.length);
            int snpInfoBufferPos = 0;
            if (snpInfoBufferSize < 20) {
                throw new GenotypeDataException("Error reading bgen snp data. File is corrupt");
            }
            long sampleCountSnp = this.getUInt32(snpInfoBuffer, snpInfoBufferPos);
            System.out.println("test " + sampleCountSnp);
            snpInfoBufferPos += 4;
            if (sampleCountSnp != sampleCount) {
                throw new GenotypeDataException("Error reading bgen variant data. General sample count is not the same as current variant sample count");
            }
            int fieldLength = this.getUInt16(snpInfoBuffer, snpInfoBufferPos);
            LOGGER.debug((Object)("Snp ID length " + fieldLength));
            this.bgenFile.skipBytes(fieldLength);
            snpInfoBufferPos += 2 + fieldLength;
            fieldLength = this.getUInt16(snpInfoBuffer, snpInfoBufferPos);
            LOGGER.debug((Object)("Snp RS length " + fieldLength));
            String snpId = new String(snpInfoBuffer, snpInfoBufferPos += 2, fieldLength, charset);
            System.out.println(snpId);
            snpInfoBufferPos += fieldLength;
            fieldLength = this.getUInt16(snpInfoBuffer, snpInfoBufferPos);
            String seqName = new String(snpInfoBuffer, snpInfoBufferPos += 2, fieldLength, charset);
            System.out.println(seqName);
            long snpPosLong = this.getUInt32(snpInfoBuffer, snpInfoBufferPos += fieldLength);
            snpInfoBufferPos += 4;
            if (snpPosLong > Integer.MAX_VALUE) {
                throw new GenotypeDataException("SNP pos larger than (2^31)-1 not supported");
            }
            int snpPos = (int)snpPosLong;
            System.out.println("SNP pos " + snpPos);
            long fieldLengthLong = this.getUInt32(snpInfoBuffer, snpInfoBufferPos);
            snpInfoBufferPos += 4;
            if (fieldLengthLong > Integer.MAX_VALUE) {
                throw new GenotypeDataException("SNP with allele longer than (2^31)-1 characters not supported");
            }
            String a1 = new String(snpInfoBuffer, snpInfoBufferPos, (int)fieldLengthLong, charset);
            snpInfoBufferPos += (int)fieldLengthLong;
            fieldLengthLong = this.getUInt32(snpInfoBuffer, snpInfoBufferPos);
            snpInfoBufferPos += 4;
            if (fieldLengthLong > Integer.MAX_VALUE) {
                throw new GenotypeDataException("SNP with allele longer than (2^31)-1 characters not supported");
            }
            String a2 = new String(snpInfoBuffer, snpInfoBufferPos, (int)fieldLengthLong, charset);
            System.out.println(a1 + "/" + a2);
            long snpBlockSize = this.compressedGenotypes ? this.getUInt32(snpInfoBuffer, snpInfoBufferPos += (int)fieldLengthLong) + 4L : 6L * sampleCount;
            byte[] snpBlockData = new byte[6 * (int)sampleCount];
            this.inflater.setInput(snpInfoBuffer, snpInfoBufferPos + 4, (int)snpBlockSize - 4);
            try {
                this.inflater.inflate(snpBlockData);
            }
            catch (DataFormatException ex) {
                throw new GenotypeDataException("Error decompressing bgen data", ex);
            }
            this.inflater.reset();
            System.out.println((float)this.getUInt16(snpBlockData, 0) / 32768.0f + " " + (float)this.getUInt16(snpBlockData, 2) / 32768.0f + " " + (float)this.getUInt16(snpBlockData, 4) / 32768.0f);
            lastSnpStart = lastSnpStart + (long)snpInfoBufferPos + snpBlockSize;
            this.bgenFile.seek(lastSnpStart);
            ++snpI;
        }
    }

    private long getUInt32(byte[] bytes, int startIndex) {
        long value = bytes[0 + startIndex] & 0xFF;
        value |= (long)(bytes[1 + startIndex] << 8 & 0xFFFF);
        value |= (long)(bytes[2 + startIndex] << 16 & 0xFFFFFF);
        return value |= (long)(bytes[3 + startIndex] << 24 & 0xFFFFFFFF);
    }

    private int getUInt16(byte[] bytes, int startIndex) {
        int value = bytes[0 + startIndex] & 0xFF;
        return value |= bytes[1 + startIndex] << 8 & 0xFFFF;
    }
}

