/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import net.sf.samtools.util.StringUtil;

public class SAMTagUtil {
    public final short RG = this.makeBinaryTag("RG");
    public final short LB = this.makeBinaryTag("LB");
    public final short PU = this.makeBinaryTag("PU");
    public final short PG = this.makeBinaryTag("PG");
    public final short AS = this.makeBinaryTag("AS");
    public final short SQ = this.makeBinaryTag("SQ");
    public final short MQ = this.makeBinaryTag("MQ");
    public final short NM = this.makeBinaryTag("NM");
    public final short H0 = this.makeBinaryTag("H0");
    public final short H1 = this.makeBinaryTag("H1");
    public final short H2 = this.makeBinaryTag("H2");
    public final short UQ = this.makeBinaryTag("UQ");
    public final short PQ = this.makeBinaryTag("PQ");
    public final short NH = this.makeBinaryTag("NH");
    public final short IH = this.makeBinaryTag("IH");
    public final short HI = this.makeBinaryTag("HI");
    public final short MD = this.makeBinaryTag("MD");
    public final short CS = this.makeBinaryTag("CS");
    public final short CQ = this.makeBinaryTag("CQ");
    public final short CM = this.makeBinaryTag("CM");
    public final short R2 = this.makeBinaryTag("R2");
    public final short Q2 = this.makeBinaryTag("Q2");
    public final short S2 = this.makeBinaryTag("S2");
    public final short CC = this.makeBinaryTag("CC");
    public final short CP = this.makeBinaryTag("CP");
    public final short SM = this.makeBinaryTag("SM");
    public final short AM = this.makeBinaryTag("AM");
    public final short MF = this.makeBinaryTag("MF");
    public final short E2 = this.makeBinaryTag("E2");
    public final short U2 = this.makeBinaryTag("U2");
    public final short OQ = this.makeBinaryTag("OQ");
    public final short FZ = this.makeBinaryTag("FZ");
    private static SAMTagUtil singleton;
    private final String[] stringTags = new String[Short.MAX_VALUE];

    public static SAMTagUtil getSingleton() {
        if (singleton == null) {
            singleton = new SAMTagUtil();
        }
        return singleton;
    }

    public short makeBinaryTag(String string) {
        if (string.length() != 2) {
            throw new IllegalArgumentException("String tag does not have length() == 2: " + string);
        }
        return (short)(string.charAt(1) << 8 | string.charAt(0));
    }

    public String makeStringTag(short s) {
        String string = this.stringTags[s];
        if (string == null) {
            byte[] byArray = new byte[]{(byte)(s & 0xFF), (byte)(s >> 8 & 0xFF)};
            this.stringTags[s] = string = StringUtil.bytesToString(byArray);
        }
        return string;
    }
}

