/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.util.BasicInputParser;
import net.sf.samtools.util.CloseableIterator;

public class DelimitedTextFileWithHeaderIterator
implements CloseableIterator<Row> {
    private final Map<String, Integer> columnLabelIndices = new HashMap<String, Integer>();
    private final BasicInputParser parser;

    public DelimitedTextFileWithHeaderIterator(BasicInputParser basicInputParser) {
        this.parser = basicInputParser;
        if (!basicInputParser.hasNext()) {
            throw new PicardException("No header line found in file " + basicInputParser.getFileName());
        }
        String[] stringArray = (String[])basicInputParser.next();
        for (int i = 0; i < stringArray.length; ++i) {
            this.columnLabelIndices.put(stringArray[i], i);
        }
    }

    public boolean hasColumn(String string) {
        return this.columnLabelIndices.containsKey(string);
    }

    public Set<String> columnLabels() {
        return this.columnLabelIndices.keySet();
    }

    public int getCurrentLineNumber() {
        return this.parser.getCurrentLineNumber();
    }

    public Set<String> getColumnNames() {
        return Collections.unmodifiableSet(this.columnLabelIndices.keySet());
    }

    @Override
    public boolean hasNext() {
        return this.parser.hasNext();
    }

    @Override
    public Row next() {
        String[] stringArray = (String[])this.parser.next();
        String string = this.parser.getCurrentLine();
        return new Row(stringArray, string);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.parser.close();
    }

    public class Row {
        private final String[] fields;
        private final String currentLine;

        Row(String[] stringArray, String string) {
            this.fields = stringArray;
            this.currentLine = string;
        }

        public String[] getFields() {
            return this.fields;
        }

        public String getField(String string) {
            Integer n = (Integer)DelimitedTextFileWithHeaderIterator.this.columnLabelIndices.get(string);
            if (n == null) {
                throw new NoSuchElementException(String.format("column %s in %s", string, DelimitedTextFileWithHeaderIterator.this.parser.getFileName()));
            }
            return this.fields[n];
        }

        public Integer getIntegerField(String string) {
            if (this.fields[(Integer)DelimitedTextFileWithHeaderIterator.this.columnLabelIndices.get(string)] == null) {
                return null;
            }
            return Integer.parseInt(this.fields[(Integer)DelimitedTextFileWithHeaderIterator.this.columnLabelIndices.get(string)]);
        }

        public String getCurrentLine() {
            return this.currentLine;
        }
    }
}

