/*
 * Decompiled with CFR 0.152.
 */
package nl.systemsgenetics.comparegenotypecalls;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.RandomAccessGenotypeData;
import org.molgenis.genotype.RandomAccessGenotypeDataReaderFormats;
import org.molgenis.genotype.sampleFilter.SampleFilter;
import org.molgenis.genotype.sampleFilter.SampleIdIncludeFilter;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variantFilter.VariantFilter;
import org.molgenis.genotype.variantFilter.VariantFilterSeqPos;
import org.molgenis.genotype.variantFilter.VariantFilterableGenotypeDataDecorator;
import org.molgenis.genotype.variantFilter.VariantIdIncludeFilter;
import org.molgenis.genotype.variantFilter.VariantQcChecker;

public class App_1 {
    static final Pattern TAB_PATTERN = Pattern.compile("\\t");
    static final String DEFAULT_CALL_P = "0.7";
    private static final Options OPTIONS = new Options();
    private static final String HEADER = "  /---------------------------------------\\\n  |         Compare genotype calls        |\n  |                                       |\n  |             Patrick Deelen            |\n  |        patrickdeelen@gmail.com        |\n  |                                       |\n  |     Genomics Coordication Center      |\n  |        Department of Genetics         |\n  |  University Medical Center Groningen  |\n  \\---------------------------------------/";

    public static void main(String[] args) throws Exception {
        String line;
        boolean alleleComp;
        String data2ForceChr;
        String data1ForceChr;
        String data2ProbCall;
        String data1ProbCall;
        String snpIdFilterData1;
        String mafFilterData2;
        String outputFilePath;
        String idMapPath;
        String data2Path;
        String data2Type;
        String data1Path;
        String data1Type;
        System.out.println(HEADER);
        System.out.println();
        System.out.flush();
        try {
            Thread.sleep(25L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            CommandLine commandLine = new PosixParser().parse(OPTIONS, args, false);
            data1Type = commandLine.getOptionValue("D1");
            data1Path = commandLine.getOptionValue("d1");
            data2Type = commandLine.getOptionValue("D2");
            data2Path = commandLine.getOptionValue("d2");
            idMapPath = commandLine.getOptionValue("s");
            outputFilePath = commandLine.getOptionValue("o");
            mafFilterData2 = commandLine.getOptionValue("m2", "0");
            snpIdFilterData1 = commandLine.getOptionValue("v", null);
            data1ProbCall = commandLine.getOptionValue("p1", DEFAULT_CALL_P);
            data2ProbCall = commandLine.getOptionValue("p2", DEFAULT_CALL_P);
            data1ForceChr = commandLine.getOptionValue("c1", null);
            data2ForceChr = commandLine.getOptionValue("c2", null);
            alleleComp = commandLine.hasOption("ac");
        }
        catch (ParseException ex) {
            System.err.println("Invalid command line arguments: ");
            System.err.println(ex.getMessage());
            System.err.println();
            new HelpFormatter().printHelp(" ", OPTIONS);
            System.exit(1);
            return;
        }
        System.out.println("Data1 " + data1Type + " at " + data1Path);
        System.out.println("Data2 " + data2Type + " at " + data2Path);
        System.out.println("SampleIdMap (data1Id\tdata2Id): " + idMapPath);
        System.out.println("output file: " + outputFilePath);
        System.out.println("Maf filter data 2: " + mafFilterData2);
        if (snpIdFilterData1 != null) {
            System.out.println("SNP ID filter data 1: " + snpIdFilterData1);
        }
        System.out.println("Data 1 prob call: " + data1ProbCall);
        System.out.println("Data 2 prob call: " + data2ProbCall);
        if (data1ForceChr != null) {
            System.out.println("Force Chr: " + data1ForceChr);
        }
        System.out.println("Allele Complement Check: " + alleleComp);
        HashMap<String, String> sampleIdMap = new HashMap<String, String>();
        BufferedReader sampleMapReader = new BufferedReader(new FileReader(idMapPath));
        while ((line = sampleMapReader.readLine()) != null) {
            String[] elements = TAB_PATTERN.split(line);
            sampleIdMap.put(elements[0], elements[1]);
        }
        SampleIdIncludeFilter data1SampleFilter = new SampleIdIncludeFilter(sampleIdMap.keySet());
        SampleIdIncludeFilter data2SampleFilter = new SampleIdIncludeFilter(sampleIdMap.values());
        VariantIdIncludeFilter snpIdFilter = null;
        if (snpIdFilterData1 != null) {
            HashSet<String> snps = new HashSet<String>();
            BufferedReader snpIdFilterReader = new BufferedReader(new FileReader(snpIdFilterData1));
            while ((line = snpIdFilterReader.readLine()) != null) {
                snps.add(line);
            }
            snpIdFilter = new VariantIdIncludeFilter(snps);
        }
        RandomAccessGenotypeData data1 = RandomAccessGenotypeDataReaderFormats.valueOfSmart(data1Type.toUpperCase()).createFilteredGenotypeData(data1Path, 1024, snpIdFilter, (SampleFilter)data1SampleFilter, data1ForceChr, Double.parseDouble(data1ProbCall));
        VariantFilterSeqPos seqPosFilter = new VariantFilterSeqPos();
        for (GeneticVariant data1Var : data1) {
            seqPosFilter.addSeqPos(data1Var);
        }
        RandomAccessGenotypeData data2 = RandomAccessGenotypeDataReaderFormats.valueOfSmart(data2Type.toUpperCase()).createFilteredGenotypeData(data2Path, 1024, (VariantFilter)seqPosFilter, (SampleFilter)data2SampleFilter, data2ForceChr, Double.parseDouble(data2ProbCall));
        data2 = new VariantFilterableGenotypeDataDecorator(data2, new VariantQcChecker(Float.valueOf(mafFilterData2).floatValue(), 0.0f, 0.0));
        System.out.println("Reading data 2 samples, total: " + data2.getSampleNames().length);
        String[] data2SamplesNames = data2.getSampleNames();
        TObjectIntHashMap<String> data2SampleIndex = new TObjectIntHashMap<String>();
        for (int i = 0; i < data2SamplesNames.length; ++i) {
            data2SampleIndex.put(data2SamplesNames[i], i);
        }
        System.out.println("Reading data 1 samples, total: " + data1.getSampleNames().length);
        String[] data1SamplesNames = data1.getSampleNames();
        TObjectIntHashMap<String> data1SampleIndex = new TObjectIntHashMap<String>();
        TObjectIntHashMap<String> sharedSamplesIndex = new TObjectIntHashMap<String>();
        ArrayList<String> sharedSamples = new ArrayList<String>();
        for (int i = 0; i < data1SamplesNames.length; ++i) {
            data1SampleIndex.put(data1SamplesNames[i], i);
            if (!sampleIdMap.containsKey(data1SamplesNames[i]) || !data2SampleIndex.containsKey(sampleIdMap.get(data1SamplesNames[i]))) continue;
            sharedSamplesIndex.put(data1SamplesNames[i], sharedSamples.size());
            sharedSamples.add(data1SamplesNames[i]);
        }
        if (sharedSamples.size() != sampleIdMap.size()) {
            System.out.println("Expected " + sampleIdMap.size() + " found in mapping but only " + sharedSamples.size() + " are found te be shared");
            System.out.println("");
        }
        int i = 0;
        int skippedVar = 0;
        int comparedVar = 0;
        BufferedWriter outSnp = new BufferedWriter(new FileWriter(outputFilePath + ".variants"));
        outSnp.append("snp\tchr\tpos\talleles\tr2\tidenticalCall\tsampleCount\tmaData1\tmafData1\tmaData2\tmafData2\tcallData1\tcallData2\n");
        HashMap<String, SimpleRegression> sampleCor = new HashMap<String, SimpleRegression>(sharedSamples.size());
        HashMap<String, AtomicInteger> sampleVarCount = new HashMap<String, AtomicInteger>(sharedSamples.size());
        HashMap<String, AtomicInteger> sampleData1CallCount = new HashMap<String, AtomicInteger>(sharedSamples.size());
        HashMap<String, AtomicInteger> sampleData2CallCount = new HashMap<String, AtomicInteger>(sharedSamples.size());
        HashMap<String, AtomicInteger> sampleIndenticalCallCount = new HashMap<String, AtomicInteger>(sharedSamples.size());
        for (String sample : sharedSamples) {
            sampleCor.put(sample, new SimpleRegression());
            sampleVarCount.put(sample, new AtomicInteger());
            sampleData1CallCount.put(sample, new AtomicInteger());
            sampleData2CallCount.put(sample, new AtomicInteger());
            sampleIndenticalCallCount.put(sample, new AtomicInteger());
        }
        for (GeneticVariant data1Var : data1) {
            if (++i % 1000 == 0) {
                System.out.println("Variant: " + i);
            }
            GeneticVariant data2Var = null;
            try {
                data2Var = data2.getSnpVariantByPos(data1Var.getSequenceName(), data1Var.getStartPos());
            }
            catch (Exception up) {
                System.out.println("Error looking up variant: " + data1Var.getSequenceName() + ":" + data1Var.getStartPos() + " in data2");
                throw up;
            }
            if (data2Var == null) continue;
            boolean swapNeeded = false;
            if (alleleComp && !data1Var.getVariantAlleles().sameAlleles(data2Var.getVariantAlleles()) && data1Var.getVariantAlleles().getComplement().sameAlleles(data2Var.getVariantAlleles())) {
                swapNeeded = true;
            }
            if (swapNeeded ? !data1Var.getVariantAlleles().getComplement().sameAlleles(data2Var.getVariantAlleles()) : !data1Var.getVariantAlleles().sameAlleles(data2Var.getVariantAlleles())) {
                System.err.println("Different alleles for " + data1Var.getPrimaryVariantId() + " " + data1Var.getVariantAlleles() + " vs " + data2Var.getVariantAlleles() + " " + data1Var.getSequenceName() + ":" + data1Var.getStartPos() + " vs " + data2Var.getSequenceName() + ":" + data2Var.getStartPos());
                ++skippedVar;
                continue;
            }
            ++comparedVar;
            float[] data1VarDosages = data1Var.getSampleDosages();
            float[] data2VarDosages = data2Var.getSampleDosages();
            List<Alleles> data1VarAlleles = data1Var.getSampleVariants();
            List<Alleles> data2VarAlleles = data2Var.getSampleVariants();
            if (data1Var.getVariantAlleles().get(0) != data2Var.getVariantAlleles().get(0)) {
                for (int j = 0; j < data2VarDosages.length; ++j) {
                    data2VarDosages[j] = (data2VarDosages[j] - 2.0f) * -1.0f;
                }
            }
            SimpleRegression varCor = new SimpleRegression();
            int snpData1CallCount = 0;
            int snpData2CallCount = 0;
            int snpIndenticalCall = 0;
            for (String sample : sharedSamples) {
                boolean data2Missing;
                double data1SampleDosage = data1VarDosages[data1SampleIndex.get(sample)];
                double data2SampleDosage = data2VarDosages[data2SampleIndex.get(sampleIdMap.get(sample))];
                Alleles data1SampleAllele = data1VarAlleles.get(data1SampleIndex.get(sample));
                Alleles data2SampleAllele = data2VarAlleles.get(data2SampleIndex.get(sampleIdMap.get(sample)));
                boolean data1Missing = data1SampleAllele.contains(Allele.ZERO) || data1SampleAllele.getAlleleCount() == 0 || data1SampleDosage < 0.0;
                boolean bl = data2Missing = data2SampleAllele.contains(Allele.ZERO) || data2SampleAllele.getAlleleCount() == 0 || data2SampleDosage < 0.0;
                if (!data1Missing) {
                    ++snpData1CallCount;
                    ((AtomicInteger)sampleData1CallCount.get(sample)).getAndIncrement();
                }
                if (!data2Missing) {
                    ++snpData2CallCount;
                    ((AtomicInteger)sampleData2CallCount.get(sample)).getAndIncrement();
                }
                if (data1Missing || data2Missing) continue;
                if (data1SampleAllele.sameAlleles(swapNeeded ? data2SampleAllele.getComplement() : data2SampleAllele)) {
                    ++snpIndenticalCall;
                    ((AtomicInteger)sampleIndenticalCallCount.get(sample)).getAndIncrement();
                }
                ((AtomicInteger)sampleVarCount.get(sample)).getAndIncrement();
                varCor.addData(data1SampleDosage, data2SampleDosage);
                ((SimpleRegression)sampleCor.get(sample)).addData(data1SampleDosage, data2SampleDosage);
            }
            outSnp.append(data1Var.getPrimaryVariantId());
            outSnp.append('\t');
            outSnp.append(data1Var.getSequenceName());
            outSnp.append('\t');
            outSnp.append(String.valueOf(data1Var.getStartPos()));
            outSnp.append('\t');
            outSnp.append(data1Var.getVariantAlleles().toString());
            outSnp.append('\t');
            outSnp.append(String.valueOf(varCor.getRSquare()));
            outSnp.append('\t');
            outSnp.append(String.valueOf((double)snpIndenticalCall / (double)varCor.getN()));
            outSnp.append('\t');
            outSnp.append(String.valueOf(varCor.getN()));
            outSnp.append('\t');
            outSnp.append(String.valueOf(data1Var.getMinorAllele()));
            outSnp.append('\t');
            outSnp.append(String.valueOf(data1Var.getMinorAlleleFrequency()));
            outSnp.append('\t');
            outSnp.append(String.valueOf(data2Var.getMinorAllele()));
            outSnp.append('\t');
            outSnp.append(String.valueOf(data2Var.getMinorAlleleFrequency()));
            outSnp.append('\t');
            outSnp.append(String.valueOf((double)snpData1CallCount / (double)sharedSamples.size()));
            outSnp.append('\t');
            outSnp.append(String.valueOf((double)snpData2CallCount / (double)sharedSamples.size()));
            outSnp.append('\n');
        }
        outSnp.close();
        System.out.println("Number of SNPs compared: " + comparedVar);
        System.out.println("Skipped vars due to incosistant alleles: " + skippedVar);
        BufferedWriter out = new BufferedWriter(new FileWriter(outputFilePath + ".sample"));
        out.append("sample");
        out.append('\t');
        out.append("r2");
        out.append('\t');
        out.append("identicalCall");
        out.append('\t');
        out.append("varCount");
        out.append('\t');
        out.append("callData1");
        out.append('\t');
        out.append("callData2");
        out.append('\n');
        for (String sample : sharedSamples) {
            out.append(sample);
            out.append('\t');
            out.append(Double.toString(((SimpleRegression)sampleCor.get(sample)).getRSquare()));
            out.append('\t');
            out.append(Double.toString((double)((AtomicInteger)sampleIndenticalCallCount.get(sample)).get() / (double)((SimpleRegression)sampleCor.get(sample)).getN()));
            out.append('\t');
            out.append(((AtomicInteger)sampleVarCount.get(sample)).toString());
            out.append('\t');
            out.append(String.valueOf((double)((AtomicInteger)sampleData1CallCount.get(sample)).get() / (double)comparedVar));
            out.append('\t');
            out.append(String.valueOf((double)((AtomicInteger)sampleData2CallCount.get(sample)).get() / (double)comparedVar));
            out.append('\n');
        }
        out.close();
    }

    static {
        OptionBuilder.withArgName("basePath");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription("Gentoype data 1");
        OptionBuilder.withLongOpt("data1");
        OptionBuilder.isRequired();
        OPTIONS.addOption(OptionBuilder.create("d1"));
        OptionBuilder.withArgName("type");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("The input data 1 type.\n* PED_MAP - plink PED MAP files.\n* PLINK_BED - plink BED BIM FAM files.\n* VCF - bgziped vcf with tabix index file\n* VCFFOLDER - matches all bgziped vcf files + tabix index in a folder\n* SHAPEIT2 - shapeit2 phased haplotypes .haps & .sample\n* GEN - Oxford .gen & .sample\n* GENFOLDER - matches all Oxford .gen & .sample\n* TRITYPER - TriTyper format folder");
        OptionBuilder.withLongOpt("data1Type");
        OptionBuilder.isRequired();
        OPTIONS.addOption(OptionBuilder.create("D1"));
        OptionBuilder.withArgName("basePath");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription("Gentoype data 2");
        OptionBuilder.withLongOpt("data2");
        OptionBuilder.isRequired();
        OPTIONS.addOption(OptionBuilder.create("d2"));
        OptionBuilder.withArgName("type");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("The input data 1 type.\n* PED_MAP - plink PED MAP files.\n* PLINK_BED - plink BED BIM FAM files.\n* VCF - bgziped vcf with tabix index file\n* VCFFOLDER - matches all bgziped vcf files + tabix index in a folder\n* SHAPEIT2 - shapeit2 phased haplotypes .haps & .sample\n* GEN - Oxford .gen & .sample\n* GENFOLDER - matches all Oxford .gen & .sample\n* TRITYPER - TriTyper format folder");
        OptionBuilder.withLongOpt("data2Type");
        OptionBuilder.isRequired();
        OPTIONS.addOption(OptionBuilder.create("D2"));
        OptionBuilder.withArgName("basePath");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription("Output base path");
        OptionBuilder.withLongOpt("output");
        OptionBuilder.isRequired();
        OPTIONS.addOption(OptionBuilder.create("o"));
        OptionBuilder.withArgName("path");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription("Sample ID mappings (data1Id\tdata2Id)");
        OptionBuilder.withLongOpt("sampleMap");
        OptionBuilder.isRequired();
        OPTIONS.addOption(OptionBuilder.create("s"));
        OptionBuilder.withArgName("double");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription("Min posterior probability to make a call in data 1. Default: 0.7");
        OptionBuilder.withLongOpt("prob1");
        OPTIONS.addOption(OptionBuilder.create("p1"));
        OptionBuilder.withArgName("double");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription("Min posterior probability to make a call in data 2. Default: 0.7");
        OptionBuilder.withLongOpt("prob2");
        OPTIONS.addOption(OptionBuilder.create("p2"));
        OptionBuilder.withArgName("path");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription("Variant include filter file data 1");
        OptionBuilder.withLongOpt("variantInclude");
        OPTIONS.addOption(OptionBuilder.create("v"));
        OptionBuilder.withArgName("string");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription("Force chr for dataset 1");
        OptionBuilder.withLongOpt("chr1");
        OPTIONS.addOption(OptionBuilder.create("c1"));
        OptionBuilder.withArgName("string");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription("Force chr for dataset 2");
        OptionBuilder.withLongOpt("chr2");
        OPTIONS.addOption(OptionBuilder.create("c2"));
        OptionBuilder.withArgName("double");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription("Maf filter data 2");
        OptionBuilder.withLongOpt("maf2");
        OPTIONS.addOption(OptionBuilder.create("m2"));
        OptionBuilder.withArgName("boolean");
        OptionBuilder.withDescription("If set check for swapped Alleles");
        OptionBuilder.withLongOpt("alleleComplement");
        OPTIONS.addOption(OptionBuilder.create("ac"));
    }
}

