/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.vcf;

import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.broad.tribble.util.ParsingUtils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.GenotypesContext;
import org.broadinstitute.variant.variantcontext.LazyGenotypesContext;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.writer.IntGenotypeFieldAccessors;
import org.broadinstitute.variant.vcf.VCFCompoundHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFHeaderLineCount;
import org.broadinstitute.variant.vcf.VCFInfoHeaderLine;

public class VCFEncoder {
    public static final Charset VCF_CHARSET = Charset.forName("ISO-8859-1");
    private static final String QUAL_FORMAT_STRING = "%.2f";
    private static final String QUAL_FORMAT_EXTENSION_TO_TRIM = ".00";
    private final IntGenotypeFieldAccessors GENOTYPE_FIELD_ACCESSORS = new IntGenotypeFieldAccessors();
    private VCFHeader header;
    private boolean allowMissingFieldsInHeader = false;

    public VCFEncoder(VCFHeader vCFHeader, boolean bl) {
        if (vCFHeader == null) {
            throw new NullPointerException("The VCF header must not be null.");
        }
        this.header = vCFHeader;
        this.allowMissingFieldsInHeader = bl;
    }

    @Deprecated
    public void setVCFHeader(VCFHeader vCFHeader) {
        this.header = vCFHeader;
    }

    @Deprecated
    public void setAllowMissingFieldsInHeader(boolean bl) {
        this.allowMissingFieldsInHeader = bl;
    }

    /*
     * WARNING - void declaration
     */
    public String encode(VariantContext variantContext) {
        Object object;
        Object object2;
        Object object3;
        if (this.header == null) {
            throw new NullPointerException("The header field must be set on the VCFEncoder before encoding records.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(variantContext.getChr()).append("\t");
        stringBuilder.append(String.valueOf(variantContext.getStart())).append("\t");
        stringBuilder.append(variantContext.getID()).append("\t");
        stringBuilder.append(variantContext.getReference().getDisplayString()).append("\t");
        if (variantContext.isVariant()) {
            void entry;
            object3 = variantContext.getAlternateAllele(0);
            object2 = ((Allele)object3).getDisplayString();
            stringBuilder.append((String)object2);
            boolean i = true;
            while (entry < variantContext.getAlternateAlleles().size()) {
                object3 = variantContext.getAlternateAllele((int)entry);
                object2 = ((Allele)object3).getDisplayString();
                stringBuilder.append(",");
                stringBuilder.append((String)object2);
                ++entry;
            }
        } else {
            stringBuilder.append(".");
        }
        stringBuilder.append("\t");
        if (!variantContext.hasLog10PError()) {
            stringBuilder.append(".");
        } else {
            stringBuilder.append(this.formatQualValue(variantContext.getPhredScaledQual()));
        }
        stringBuilder.append("\t");
        stringBuilder.append(this.getFilterString(variantContext)).append("\t");
        object3 = new TreeMap();
        for (Map.Entry list : variantContext.getAttributes().entrySet()) {
            if (!this.header.hasInfoLine((String)list.getKey())) {
                this.fieldIsMissingFromHeaderError(variantContext, (String)list.getKey(), "INFO");
            }
            if ((object = this.formatVCFField(list.getValue())) == null) continue;
            object3.put(list.getKey(), object);
        }
        this.writeInfoString((Map<String, String>)object3, stringBuilder);
        object2 = variantContext.getGenotypes();
        if (((GenotypesContext)object2).isLazyWithData() && ((LazyGenotypesContext)object2).getUnparsedGenotypeData() instanceof String) {
            stringBuilder.append("\t");
            stringBuilder.append(((LazyGenotypesContext)object2).getUnparsedGenotypeData().toString());
        } else {
            List<String> list = variantContext.calcVCFGenotypeKeys(this.header);
            if (!list.isEmpty()) {
                for (String string : list) {
                    if (this.header.hasFormatLine(string)) continue;
                    this.fieldIsMissingFromHeaderError(variantContext, string, "FORMAT");
                }
                object = ParsingUtils.join(":", list);
                stringBuilder.append("\t");
                stringBuilder.append((String)object);
                Map<Allele, String> map = this.buildAlleleStrings(variantContext);
                this.addGenotypeData(variantContext, map, list, stringBuilder);
            }
        }
        return stringBuilder.toString();
    }

    VCFHeader getVCFHeader() {
        return this.header;
    }

    boolean getAllowMissingFieldsInHeader() {
        return this.allowMissingFieldsInHeader;
    }

    private String getFilterString(VariantContext variantContext) {
        if (variantContext.isFiltered()) {
            for (String string : variantContext.getFilters()) {
                if (this.header.hasFilterLine(string)) continue;
                this.fieldIsMissingFromHeaderError(variantContext, string, "FILTER");
            }
            return ParsingUtils.join(";", ParsingUtils.sortList(variantContext.getFilters()));
        }
        if (variantContext.filtersWereApplied()) {
            return "PASS";
        }
        return ".";
    }

    private String formatQualValue(double d) {
        String string = String.format(QUAL_FORMAT_STRING, d);
        if (string.endsWith(QUAL_FORMAT_EXTENSION_TO_TRIM)) {
            string = string.substring(0, string.length() - QUAL_FORMAT_EXTENSION_TO_TRIM.length());
        }
        return string;
    }

    private void fieldIsMissingFromHeaderError(VariantContext variantContext, String string, String string2) {
        if (!this.allowMissingFieldsInHeader) {
            throw new IllegalStateException("Key " + string + " found in VariantContext field " + string2 + " at " + variantContext.getChr() + ":" + variantContext.getStart() + " but this key isn't defined in the VCFHeader.  We require all VCFs to have" + " complete VCF headers by default.");
        }
    }

    String formatVCFField(Object object) {
        String string;
        if (object == null) {
            string = ".";
        } else if (object instanceof Double) {
            string = VCFEncoder.formatVCFDouble((Double)object);
        } else if (object instanceof Boolean) {
            string = (Boolean)object != false ? "" : null;
        } else if (object instanceof List) {
            string = this.formatVCFField(((List)object).toArray());
        } else if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            if (n == 0) {
                return this.formatVCFField(null);
            }
            StringBuilder stringBuilder = new StringBuilder(this.formatVCFField(Array.get(object, 0)));
            for (int i = 1; i < n; ++i) {
                stringBuilder.append(",");
                stringBuilder.append(this.formatVCFField(Array.get(object, i)));
            }
            string = stringBuilder.toString();
        } else {
            string = object.toString();
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String formatVCFDouble(double d) {
        String string;
        if (d < 1.0) {
            if (d < 0.01) {
                if (!(Math.abs(d) >= 1.0E-20)) return "0.00";
                string = "%.3e";
                return String.format(string, d);
            } else {
                string = "%.3f";
            }
            return String.format(string, d);
        } else {
            string = QUAL_FORMAT_STRING;
        }
        return String.format(string, d);
    }

    static int countOccurrences(char c, String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n += string.charAt(i) == c ? 1 : 0;
        }
        return n;
    }

    static boolean isMissingValue(String string) {
        return VCFEncoder.countOccurrences(".".charAt(0), string) + VCFEncoder.countOccurrences(',', string) == string.length();
    }

    private void addGenotypeData(VariantContext variantContext, Map<Allele, String> map, List<String> list, StringBuilder stringBuilder) {
        int n = variantContext.getMaxPloidy(2);
        for (String string : this.header.getGenotypeSamples()) {
            int n2;
            stringBuilder.append("\t");
            Genotype genotype = variantContext.getGenotype(string);
            if (genotype == null) {
                genotype = GenotypeBuilder.createMissing(string, n);
            }
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (String string2 : list) {
                String string3;
                if (string2.equals("GT")) {
                    if (!genotype.isAvailable()) {
                        throw new IllegalStateException("GTs cannot be missing for some samples if they are available for others in the record");
                    }
                    this.writeAllele(genotype.getAllele(0), map, stringBuilder);
                    for (int i = 1; i < genotype.getPloidy(); ++i) {
                        stringBuilder.append(genotype.isPhased() ? "|" : "/");
                        this.writeAllele(genotype.getAllele(i), map, stringBuilder);
                    }
                    continue;
                }
                if (string2.equals("FT")) {
                    string3 = genotype.isFiltered() ? genotype.getFilters() : "PASS";
                } else {
                    int n3;
                    Comparable comparable;
                    Object object;
                    IntGenotypeFieldAccessors.Accessor accessor = this.GENOTYPE_FIELD_ACCESSORS.getAccessor(string2);
                    if (accessor != null) {
                        object = accessor.getValues(genotype);
                        if (object == null) {
                            string3 = ".";
                        } else if (((int[])object).length == 1) {
                            string3 = Integer.toString(object[0]);
                        } else {
                            comparable = new StringBuilder();
                            ((StringBuilder)comparable).append(object[0]);
                            for (n3 = 1; n3 < ((Object)object).length; ++n3) {
                                ((StringBuilder)comparable).append(",");
                                ((StringBuilder)comparable).append((int)object[n3]);
                            }
                            string3 = ((StringBuilder)comparable).toString();
                        }
                    } else {
                        object = genotype.hasExtendedAttribute(string2) ? genotype.getExtendedAttribute(string2) : ".";
                        comparable = this.header.getFormatHeaderLine(string2);
                        if (comparable != null && (n3 = ((VCFCompoundHeaderLine)comparable).getCount(variantContext)) > 1 && object.equals(".")) {
                            StringBuilder stringBuilder2 = new StringBuilder(".");
                            for (int i = 1; i < n3; ++i) {
                                stringBuilder2.append(",");
                                stringBuilder2.append(".");
                            }
                            object = stringBuilder2.toString();
                        }
                        string3 = this.formatVCFField(object);
                    }
                }
                if (string3 == null) continue;
                arrayList.add(string3);
            }
            for (n2 = arrayList.size() - 1; n2 >= 0 && VCFEncoder.isMissingValue((String)arrayList.get(n2)); --n2) {
                arrayList.remove(n2);
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                if (n2 > 0 || list.contains("GT")) {
                    stringBuilder.append(":");
                }
                stringBuilder.append((String)arrayList.get(n2));
            }
        }
    }

    private void writeInfoString(Map<String, String> map, StringBuilder stringBuilder) {
        if (map.isEmpty()) {
            stringBuilder.append(".");
            return;
        }
        boolean bl = true;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            VCFInfoHeaderLine vCFInfoHeaderLine;
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(";");
            }
            stringBuilder.append(entry.getKey());
            if (entry.getValue().equals("") || (vCFInfoHeaderLine = this.header.getInfoHeaderLine(entry.getKey())) != null && vCFInfoHeaderLine.getCountType() == VCFHeaderLineCount.INTEGER && vCFInfoHeaderLine.getCount() == 0) continue;
            stringBuilder.append("=");
            stringBuilder.append(entry.getValue());
        }
    }

    private Map<Allele, String> buildAlleleStrings(VariantContext variantContext) {
        HashMap<Allele, String> hashMap = new HashMap<Allele, String>(variantContext.getAlleles().size() + 1);
        hashMap.put(Allele.NO_CALL, ".");
        List<Allele> list = variantContext.getAlleles();
        for (int i = 0; i < list.size(); ++i) {
            hashMap.put(list.get(i), String.valueOf(i));
        }
        return hashMap;
    }

    private void writeAllele(Allele allele, Map<Allele, String> map, StringBuilder stringBuilder) {
        String string = map.get(allele);
        if (string == null) {
            throw new RuntimeException("Allele " + allele + " is not an allele in the variant context");
        }
        stringBuilder.append(string);
    }
}

